// This module is used for printing all the advertisements that the user has applied to.
// The module uses a separate "ilmoituksenhaku"-module to fetch advertisement-objects.
// The function takes access-token-string, user data-object and an applications-object as parameters.
// A new advertisements-array is first created. Then for each application in the applications-object
// the corresponding advertisement is fetched from the database, and the information is pushed to the
// new advertisements-array. The advertisement-array is then put to "hakemukset"-object's docs-field
// to enable the structural compatibility with the template.

const ilmoituksenhaku = require("../queries/ilmoitushaku");

module.exports = {

    "tulostaHakemukset" : async (token, userdata, applications, cb) => {

        let advertarray = [];
        let fragments = "title\ndesc";
		
		for (let hakemus of applications) {
			await ilmoituksenhaku.haeIlmoitus(hakemus.IlmoitusId, fragments, (ilmoitus) => {
				let item = {
							date: hakemus.date,
							HakemusId: hakemus.HakemusId,
							IlmoitusId: hakemus.IlmoitusId,
							title: ilmoitus.title,
							desc: ilmoitus.desc
							};
				advertarray.push(item);
			});
		}

        let hakemukset = [{ docs: advertarray }];

        cb({
            "logsign": false,
            "user": userdata,
            "token": token,
            "ruutu": "hakemukset",
            "modal": false,
            "kuvaus": null,
            "content": hakemukset,
            "modalcontent": null
        });
		
    }

};