// This module is used for printing the second page of the registration form. The function takes request's
// body-object, user data-object and an error-string as parameters. The error is a message that the 'register'
// -module has sent if the form hasn't been filled properly. First the function checks the validity of the
// information the user has submitted in the previous page of the registration form. Either if some of the
// textfields are empty, the email addresses or passwords don't match or the username already exists, a
// notification is printed out and proceeding will be disabled.

module.exports = {

    "fillLoput": async (rqstbody, userdata, error, cb) => {
		let notification = "";
		if (rqstbody.username == "" ||
			rqstbody.psswrd == "" ||
			rqstbody.psswrd2 == "" ||
			rqstbody.email == "" ||
			rqstbody.email2 == "") {
				notification = "<p style='color: red; text-shadow: 0px 0px 0px red;'>Täytä jokainen tekstikenttä!</p>";
			}
		if (rqstbody.psswrd != rqstbody.psswrd2) {
				notification += "<p style='color: red; text-shadow: 0px 0px 0px red;'>Salasanat eivät täsmää!</p>";
			}
		if (rqstbody.email != rqstbody.email2) {
				notification += "<p style='color: red; text-shadow: 0px 0px 0px red;'>Sähköpostiosoitteet eivät täsmää!</p>";
			}
		if (userdata) {
			notification += "<p style='color: red; text-shadow: 0px 0px 0px red;'>Käyttäjätunnuksesi on jo käytössä!</p>";
			}
		(notification == "" || error) ?
			cb(null, {
				"logsign": "sbmt",
				"user": null,
				"token": null,
				"ruutu": rqstbody.kuvaruutu,
				"modal": false,
				"content": null,
				"huomautus": error,
				"un": rqstbody.username,
				"pw": rqstbody.psswrd,
				"pw2": rqstbody.psswrd2,
				"em": rqstbody.email,
				"em2": rqstbody.email2,
				"etunimi": rqstbody.etunimi,
				"sukunimi": rqstbody.sukunimi,
				"spuoli": rqstbody.sukupuoli,
				"rooli": rqstbody.rooli,
				"osoite": rqstbody.kotiosoite,
				"pnumero": rqstbody.puhelinnumero
			}) :
			cb(notification);
	}
	
};