// This module is used for printing all the advertisements from the database.
// The function takes access-token-string, user data-object and advertisements-object as arguments.
// A new json is created to organize the advertisements according to their jobfields.
// Each advertisement from the original json is then pushed in the right slot of the new json-object.
// When a jobfields' slot has at least one advertisement in it, then also a header is added on top.

module.exports = {

    "tulostaIlmoitukset": async (token, userdata, ilmoitukset, cb) => {
        
        let ilmoitusarray = [{ arrayname: "Construction", docs: [] },
                               { arrayname: "Industry", docs: [] },
                            { arrayname: "Forestry", docs: [] },
                            { arrayname: "Logistics", docs: [] }];

        await ilmoitukset.forEach(element => {
            switch (element.ala) {
                case ('CONSTRUCTION'): ilmoitusarray[0].docs.push(element);
                break;
                case ('INDUSTRY'): ilmoitusarray[1].docs.push(element);
                break;
                case ('FORESTRY'): ilmoitusarray[2].docs.push(element);
                break;
                case ('LOGISTICS'): ilmoitusarray[3].docs.push(element);
            }
        });

        for (i = 0; i < 4; i++) {
            if (ilmoitusarray[i].docs.length > 0) {
                ilmoitusarray[i].docs.unshift("<h3>---------------- " + ilmoitusarray[i].arrayname + " ----------------</h3>");
            }
        }

        cb({
            "logsign": false,
            "user": userdata,
            "token": token,
            "ruutu": "haku",
            "modal": false,
            "kuvaus": null,
            "hakusana": "",
            "content": ilmoitusarray,
            "modalcontent": null,
            "all": true
        });
    }

};