// This module holds all the resolver functions that perform the right CRUD-operation to the database, when a graphql-query or -mutation has
// been made.

const { context } = require('../main');
const haeId = require('./idhaku');

const resolvers = {
	
	// query-funcions:
    Ilmoitukset: (args, context) =>					// finds all the advertisements from the database
        context().then(db => db.collection('advertisements').find().toArray()),
    Ilmoitus: (args, context) =>					// finds one advertisement that match the id
        context().then(db => db.collection('advertisements').findOne({ IlmoitusId: args.IlmoitusId })),
    Ilmoituksia: (args, context) =>					// finds those advertisements from the database that match the search criteria
        context().then(db => db.collection('advertisements').find({ title: { $regex: args.otsikko, $options: 'i' },
                                                                             "ala": args.toimiala, "maakunta": { "$in": args.alueet } }).toArray()),
	ilmoituksetKayttajan: (args, context) =>		// finds those advertisements from the database the author of which match the argument
        context().then(db => db.collection('advertisements').find({ auth: args.Kayttajatunnus }).toArray()),
    hakemuksetKayttajan: (args, context) =>			// finds those applications from the database the author of which match the argument
        context().then(db => db.collection('applications').find({ auth: args.Kayttajatunnus }).toArray()),
	hakemuksetIlmoituksen: (args, context) =>		// finds those applications from the database that are directed to the specific advertisement
		context().then(db => db.collection('applications').find({ IlmoitusId: args.Ilmoitustunnus }).toArray()),
    hakemusId: (args, context) =>                   // finds a specific application from the database that matches the id
        context().then(db => db.collection('applications').findOne({ HakemusId: args.Id })),
    haeKayttaja: (args, context) =>					// finds the document of user the username of which match the argument
        context().then(db => db.collection('users').findOne({ KayttajaTunnus: args.Kayttajatunnus })),
    cvHaeId: (args, context) =>                     // finds a cv file from the database that has the author same as the argument's username
        context().then(db => db.collection('fs.files').findOne({ metadata: { username: args.Kayttajatunnus }})),
		
	// mutation-functions:
    ilmoituksenLisays: (args, context) =>			// adds a new advertisement to the database
        Promise.all([haeId('advertID', context), context()]).then(result => result[1].collection('advertisements')
            .insertOne({ date: args.aika,
						IlmoitusId: result[0],
						title: args.otsikko,
                        desc: args.kuvaus,
                        ala: args.toimiala,
                        maakunta: args.alue,
						auth: args.kayttajaTunnus })).then(response => response.ops[0]),
	ilmoituksenTallennus: (args, context) =>		// updates the user document by pushing the advertisement id to the "Documents"-array
		context().then(db => db.collection('users').updateOne({ KayttajaTunnus: args.kayttajaTunnus }, { $push: { Documents: args.ilmoitusid }}))
				.then(() => { return "Ilmoitus tallennettu profiiliin." }),
    ilmoituksenPoisto: (args, context) =>			// deletes the advertisement from the database
        context().then(db => db.collection('advertisements').deleteOne({ IlmoitusId: args.id }))
            .then(() => { return "Ilmoitus poistettu onnistuneesti." }),
	ilmoituksenTallennusPoisto: (args, context) =>	// updates the user document by pulling the advertisement id from the "Documents"-array
		context().then(db => db.collection('users').updateOne({ KayttajaTunnus: args.kayttajatunnus }, { $pull: { Documents: args.ilmoitusid }}))
			.then(() => { return "Ilmoitus poistettu profiilista." }),
    ilmoituksenMuokkaus: (args, context) =>			// updates the advertisement document's title- and desc- fields
        context().then(db => db.collection('advertisements')
            .updateOne({ IlmoitusId: args.id }, { $set: { title: args.otsikko, desc: args.kuvaus, ala: args.toimiala, maakunta: args.alue } }))
            .then(() => { return "Ilmoitus muokattu onnistuneesti." }),
	hakemuksenLisays: (args, context) =>			// adds a new application to the database
		Promise.all([haeId('applicationID', context), context()]).then(result => result[1].collection('applications')
			.insertOne({ date: args.aika, HakemusId: result[0], title: args.otsikko, desc: args.kuvaus, auth: args.kayttajaTunnus, IlmoitusId: args.ilmoitusId }))
            .then(response => response.ops[0]),
    hakemusidLisays: (args, context) =>				// updates an advertisement document by pushing the application id to the "Hakemukset"-array
        context().then(db => db.collection('advertisements').updateOne({ IlmoitusId: args.ilmoitusid }, { $push: { Hakemukset: args.hakemusid }}))
			.then(() => { return "Hakemus lisätty ilmoitukseen." }),
    hakemusidTallennus: (args, context) =>			// updates a user document by pushing the application id to the "Documents"-array
        context().then(db => db.collection('users').updateOne({ KayttajaTunnus: args.kayttajatunnus }, { $push: { Documents: args.hakemusid }}))
				.then(() => { return "Hakemus tallennettu profiiliin." }),
    hakemuksenPoisto: (args, context) =>			// deletes an application from the database
                context().then(db => db.collection('applications').deleteOne({ HakemusId: args.id }))
                .then(() => { return "Hakemus poistettu onnistuneesti." }),
    hakemusidPoisto: (args, context) =>				// updates the advertisement document by pulling the application id from the "Hakemukset"-array
                context().then(db => db.collection('advertisements').updateOne({ IlmoitusId: args.ilmoitusid }, { $pull: { Hakemukset: args.hakemusid } }))
                .then(() => { return "Hakemus poistettu ilmoituksesta."}),
    hakemusTallennusPoisto: (args, context) =>		// updates the user document by pulling the application id from the "Documents"-array
		context().then(db => db.collection('users').updateOne({ KayttajaTunnus: args.kayttajatunnus }, { $pull: { Documents: args.hakemusid }}))
                .then(() => { return "Hakemus poistettu profiilista."}),
    tunnuksenLuonti: (args, context) =>				// creates a new user document to the database
        context().then(db => db.collection('users').insertOne({ date: args.aika,
																KayttajaTunnus: args.Kayttajatunnus,
                                                                SalaSana: args.Salasana,
                                                                EtuNimi: args.Etunimi,
                                                                SukuNimi: args.Sukunimi,
                                                                SukuPuoli: args.Sukupuoli,
                                                                Rooli: args.rooli,
																EmailAddress: args.Email,
																HomeAddress: args.Homeaddress,
																PhoneNumber: args.Phonenumber })).then(response => response.ops[0]),
    kuvanLisays: (args, context) =>                 // adds a profile picture to the user document as a binary string
            context().then(db => db.collection('users').updateOne({ KayttajaTunnus: args.Kayttajatunnus }, { $set: { Kuva: args.Kuva }}))
                .then(() => { return "Kuva lisätty onnistuneesti."}),
    kuvanPoisto: (args, context) =>                 // deletes the profile picture from the user document
            context().then(db => db.collection('users').updateOne({ KayttajaTunnus: args.Kayttajatunnus }, { $unset: { Kuva: null }}))
                .then(() => { return "Kuva poistettu onnistuneesti."}),
    cvnLisays: (args, context) =>                   // adds a cv file name string to the user document
            context().then(db => db.collection('users').updateOne({ KayttajaTunnus: args.Kayttajatunnus }, { $set: { Ansioluettelo: args.cvfile }}))
                .then(() => { return "CV lisätty onnistuneesti."}),
    cvnPoisto: (args, context) =>                   // deletes the cv from the user document
            context().then(db => db.collection('users').updateOne({ KayttajaTunnus: args.Kayttajatunnus }, { $unset: { Ansioluettelo: null }}))
                .then(() => { return "CV poistettu onnistuneesti."}),
    cvFileDelete: (args, context) =>                // deletes the cv file document from the fs.files collection
            context().then(db => db.collection('fs.files').deleteOne({ _id: args.Kayttajatunnus }))
                .then(() => { return "CVfile poistettu onnistuneesti."}),
    cvChunkDelete: (args, context) =>               // deletes the cv chunk document(s) from the fs.chunks collection
            context().then(db => db.collection('fs.chunks').deleteMany({ files_id: args.Kayttajatunnus }))
                .then(() => { return "CVChunks poistettu onnistuneesti."}),
    profiilinMuokkaus: (args, context) =>           // updates the user document textfields
            context().then(db => db.collection('users').updateOne({ KayttajaTunnus: args.Kayttajatunnus }, { $set: { EtuNimi: args.Etunimi,
                                                                                                                SukuNimi: args.Sukunimi,
                                                                                                                HomeAddress: args.Osoite,
                                                                                                                PhoneNumber: args.Puhelinnro,
                                                                                                                Description: args.Kuvaus }} ))
                .then(() => { return "Profiili muokattu onnistuneesti."}),
    salasananVaihto: (args, context) =>             // changes the user document password
            context().then(db => db.collection('users').updateOne({ KayttajaTunnus: args.Kayttajatunnus }, { $set: { SalaSana: args.newpsswrd }}))
            .then(() => { return "Salasana vaihdettu."}),
    profiilinPoisto: (args, context) =>             // deletes the user profile
            context().then(db => db.collection('users').deleteOne({ KayttajaTunnus: args.Kayttajatunnus }))
            .then(() => { return "Profiili poistettu tietokannasta." })
};

module.exports = resolvers;