// This module is used for creating a unique id integer for each advertisement / application
// that gets created. To accomplish this a collection named 'IDs' must be created in the
// database. This collection should have one document for application id and another for
// advertisement id with fields "'_id': 'applicationID'" or "'_id': 'advertID'"" and "'num': 0".
// This module increments the "num" field of the document by 1 and then returns the number,
// which is then put to the advertisement / application as a unique id.

const haeId = (nimi, cntxt) => {
    return new Promise((resolve, reject) => {
        cntxt().then(database => database.collection('IDs').findOneAndUpdate(
            { "_id": nimi },
            { $inc: { "num": 1 } },
            { returnNewDocument: true }
        )).then(doc => resolve(doc.value.num));
    });
};

module.exports = haeId;