ONT-Project

The aim of this project is to give an example of how a very simple server app works with Node.js, Express.js, GraphQL and MongoDB. The project works as a platform for a recruiter to publish advertisements of open job positions. Then a recruit or more likely a job seeker can apply to these positions he / she finds from the service.

For the program to run Node.js and MongoDB should be installed. To install dependencies open the project directory in cmd and run 'npm install'. To run the server enter 'node main' in cmd. Then open your browser url:'localhost:9000'.

The project uses bcrypt-module in password-hashing, ejs-template-engine, express, express-file-upload, express-graphql and graphql, jsonwebtoken for user authentication, mongodb, node-fetch for graphql-queries and sharp for compressing files.

The project has an entry file 'main.js' in the root directory. Then there are folders 'dboperations', 'helpers', 'icons',  'mutations', 'queries', 'schema', 'styles' and 'views'. The 'dboperations'-folder holds the resolver-functions for the database crud-operations and id-incrementation functions. The 'helpers'-, 'queries'- and 'mutations'-folders hold modules for all the different functions. The 'icons' folder holds all the image-files. The css-files are stored in the 'styles'-folder. The 'views'-folder holds all the template files.

'Schema.js'-file holds the GraphQL-schema for queries, mutations and types. It's located in the 'Schema'-folder. It's constructed with 'buildSchema()'-representation, which has some downsides to it, but I think it works enough well in this project.

When user creates a profile account, the password that is inserted is hashed before storing it to the database. A secret phrase is used in encrypting the password and in decrypting the stored hash when the stored password is later compared to the submitted password when user logs in. When a user sign/logs in, a json web token is created to authenticate session. An html page is printed that will store the token in the browser's localStorage. Then it's redirected to front page. I will later update the project and create a more secure solution with http-only cookie. The token will always be put to every button on the page in every subsequent action user makes.

Depending on the role that is specified during the profile creation different actions can be taken. Regardless of the user role, all users can search and read advertisements. In fact this action can be done outlogged as well. All users can edit their personal information or password and add a profile picture. They can also delete their user-account.

When user has chosen to create a 'recruiter'-profile, he / she can create advertisements that are displayed publicly on webpage. The advertisements can be later edited or deleted. The user can read application letters that are directed to the advertisement and also the information about the user that created the application.

When user has chosen to create a 'recruit'-profile, he / she can send applications to advertisements. The applications can be later deleted. A recruit-profile can also upload a cv-file.

During the project it became obvious that the GraphQL brings no value added, and it could have been just dropped out. However, if the project gets further developed maybe there's a potential benefit.

Copyright 2021 Tapani Voutilainen

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.