const { buildSchema } = require('graphql');

const schema = buildSchema(`

    type Query {
        Ilmoitukset: [Ilmoitus]
        Ilmoitus(IlmoitusId: Int): Ilmoitus
        Ilmoituksia(otsikko: String, toimiala: Field, alueet: [Region]): [Ilmoitus]
        ilmoituksetKayttajan(Kayttajatunnus: String): [Ilmoitus]
        hakemuksetKayttajan(Kayttajatunnus: String): [Hakemus]
        hakemuksetIlmoituksen(Ilmoitustunnus: Int): [Hakemus]
        hakemusId(Id: Int): Hakemus
        haeKayttaja(Kayttajatunnus: String): Kayttaja
    }

    type Mutation {
        ilmoituksenLisays(aika: String, otsikko: String, kuvaus: String, kayttajaTunnus: String, toimiala: Field, alue: Region): Ilmoitus
		ilmoituksenTallennus(ilmoitusid: Int, kayttajaTunnus: String): String
        ilmoituksenPoisto(id: Int): String
		ilmoituksenTallennusPoisto(kayttajatunnus: String, ilmoitusid: Int): String
        ilmoituksenMuokkaus(id: Int, otsikko: String, kuvaus: String, toimiala: Field, alue: Region): String
        hakemuksenLisays(aika: String, ilmoitusId: Int, otsikko: String, kuvaus: String, kayttajaTunnus: String): Hakemus
        hakemuksenPoisto(id: Int): String
        hakemusidLisays(ilmoitusid: Int, hakemusid: Int): String
        hakemusidPoisto(ilmoitusid: Int, hakemusid: Int): String
        hakemusidTallennus(kayttajatunnus: String, hakemusid: Int): String
        hakemusTallennusPoisto(kayttajatunnus: String, hakemusid: Int): String
        tunnuksenLuonti(aika: String,
						Kayttajatunnus: String,
						Salasana: String,
						Etunimi: String,
						Sukunimi: String,
						Sukupuoli: Gender,
						rooli: Role,
						Email: String,
						Homeaddress: String,
                        Phonenumber: String): Kayttaja
        kuvanLisays(Kayttajatunnus: String, Kuva: String): String
        kuvanPoisto(Kayttajatunnus: String): String
        cvnLisays(Kayttajatunnus: String, cvfile: String): String
        cvnPoisto(Kayttajatunnus: String): String
        cvFileDelete(Kayttajatunnus: String): String
        cvChunkDelete(Kayttajatunnus: String): String
        profiilinMuokkaus(Kayttajatunnus: String, Etunimi: String, Sukunimi: String, Osoite: String, Puhelinnro: String, Kuvaus: String): String
        salasananVaihto(Kayttajatunnus: String, newpsswrd: String): String
        profiilinPoisto(Kayttajatunnus: String): String
    }

    type Ilmoitus {
        _id: String
		date: String
        IlmoitusId: Int
        title: String
        desc: String
        ala: Field
        maakunta: Region
        auth: String
		Hakemukset: [Int]
    }

    type Kayttaja {
        _id: String
		date: String
        KayttajaTunnus: String
        SalaSana: String
        Kuva: String
        EtuNimi: String
        SukuNimi: String
        SukuPuoli: Gender
        Rooli: Role
        Description: String
		EmailAddress: String
		HomeAddress: String
        PhoneNumber: String
        Ansioluettelo: String
		Documents: [Int]
    }
	
	type Hakemus {
		_id: String
		HakemusId: Int
		date: String
		title: String
		desc: String
        auth: String
        IlmoitusId: Int
    }

    enum Field {
        CONSTRUCTION
        INDUSTRY
        FORESTRY
        LOGISTICS
    }
    
    enum Region {
        AHVENANMAA
        EKARJALA
        EPOHJANMAA
        ESAVO
        KAINUU
        KHAME
        KPOHJANMAA
        KSUOMI
        KYMENLAAKSO
        LAPPI
        PIRKANMAA
        POHJANMAA
        PKARJALA
        PPOHJANMAA
        PSAVO
        PHAME
        SATAKUNTA
        UUSIMAA
        VSUOMI
    }

    enum Gender {
        MALE
        FEMALE
    }

    enum Role {
        RECRUITER
        RECRUIT
    }

`);

module.exports = schema;