// This module is used for getting those advertisements from the database that match the search criteria.
// The function takes a request body-object as it's only parameter. It first creates an empty array to which
// it pushes objects with region information. The request body-object is searched through, and if it has
// regions selected then these regions' information is pushed to the array. Then another empty array is
// created to which each region's "tunniste"-field is pushed. If the request body-object's jobfield-field
// is "Valitse ala.", then obviously the user hasn't selected it, so it's null. The function then performs
// a graphql-query with node-fetch-module. The function returns the advertisements and the "regionlist"-array.

const fetch = require('node-fetch');
const { url } = require('../main');

module.exports = {

    "haeIlmoituksia": async (rqstbody, cb) => {

        let regions = [];
        if (rqstbody.ahven) regions.push({ tunniste: 'AHVENANMAA', kuvaus: 'Ahvenanmaa' });
        if (rqstbody.ekarja) regions.push({ tunniste: 'EKARJALA', kuvaus: 'Etelä-Karjala' });
        if (rqstbody.epohja) regions.push({ tunniste: 'EPOHJANMAA', kuvaus: 'Etelä-Pohjanmaa' });
        if (rqstbody.esav) regions.push({ tunniste: 'ESAVO', kuvaus: 'Etelä-Savo' });
        if (rqstbody.kainu) regions.push({ tunniste: 'KAINUU', kuvaus: 'Kainuu' });
        if (rqstbody.kanta) regions.push({ tunniste: 'KHAME', kuvaus: 'Kanta-Häme' });
        if (rqstbody.kpohja) regions.push({ tunniste: 'KPOHJANMAA', kuvaus: 'Keski-Pohjanmaa' });
        if (rqstbody.keski) regions.push({ tunniste: 'KSUOMI', kuvaus: 'Keski-Suomi' });
        if (rqstbody.kymi) regions.push({ tunniste: 'KYMENLAAKSO', kuvaus: 'Kymenlaakso' });
        if (rqstbody.lappi) regions.push({ tunniste: 'LAPPI', kuvaus: 'Lappi' });
        if (rqstbody.pirkka) regions.push({ tunniste: 'PIRKANMAA', kuvaus: 'Pirkanmaa' });
        if (rqstbody.pohja) regions.push({ tunniste: 'POHJANMAA', kuvaus: 'Pohjanmaa' });
        if (rqstbody.pkarja) regions.push({ tunniste: 'PKARJALA', kuvaus: 'Pohjois-Karjala' });
        if (rqstbody.ppohja) regions.push({ tunniste: 'PPOHJANMAA', kuvaus: 'Pohjois-Pohjanmaa' });
        if (rqstbody.psav) regions.push({ tunniste: 'PSAVO', kuvaus: 'Pohjois-Savo' });
        if (rqstbody.phame) regions.push({ tunniste: 'PHAME', kuvaus: 'Päijät-Häme' });
        if (rqstbody.sata) regions.push({ tunniste: 'SATAKUNTA', kuvaus: 'Satakunta' });
        if (rqstbody.uusi) regions.push({ tunniste: 'UUSIMAA', kuvaus: 'Uusimaa' });
        if (rqstbody.varsi) regions.push({ tunniste: 'VSUOMI', kuvaus: 'Varsinais-Suomi' });

        let regionlist = [];
        regions.forEach(region => {
            regionlist.push(region.tunniste);
        });
        
        if (rqstbody.jobfield == "Valitse ala.") rqstbody.jobfield = null;

        const data = JSON.stringify({
            query: `{
                Ilmoituksia(otsikko: "${rqstbody.otsikko}", toimiala: ${rqstbody.jobfield}, alueet: [${regionlist}]) {
                    IlmoitusId
                    title
                    desc
                    auth
                    date
                    maakunta
                }
            }`,
            variables: null
        });
        const vastaus = await fetch(
            url,
            {
                method: 'post',
                body: data,
                headers: {
                    'Content-Type': 'application/json'
                },
            }
        );

        const json = await vastaus.json();
        cb(json.data.Ilmoituksia, regions);
		
	}

};