// This module is used for getting all of the applications from the database, that are
// directed to a specific advertisement. The function takes an advertisement id-integer
// and a fragments-string as parameters. It then performs a graphql-query with
// node-fetch-module and returns the applications with fields specified in the fragments
// parameter.

const fetch = require('node-fetch');
const { url } = require('../main');

module.exports = {

    "haeHakemukset": async (tunnus, frags, cb) => {

        const data = JSON.stringify({
            query: `{
                hakemuksetIlmoituksen(Ilmoitustunnus: ${tunnus}) {
                    ${frags}
                }
                }`,
            variables: null
        });
        const vastaus = await fetch(
            url,
            {
                method: 'post',
                body: data,
                headers: {
                    'Content-Type': 'application/json'
                },
            }
        );
        const json = await vastaus.json();
        cb(json.data.hakemuksetIlmoituksen);
            
    }

};