// This module is used for updating the user document in the database by replacing the password with new one.
// The function takes a request body-objet and a user data-objet as it's parameters. It first compares the
// passwords submitted by user in web page to ensure that they match. It then compares the submitted password
// with the password hash in the database with bcrypt. If they both match, a hash is created from the new
// password with bcrypt. A graphql-mutation is then performed with node-fetch to save the new password hash to
// the user document. If the password the user submitted is invalid or the passwords aren't equal, then a
// notification is returned. The function returns modal content-string and notification-string or -boolean in callback.

const fetch = require('node-fetch');
const bcrypt = require('bcrypt');
const { url } = require('../main');

module.exports = {

    "vaihdaSalasana": async (rqstbody, userdata, cb) => {
        if (rqstbody.salasana1 == rqstbody.salasana2) {
            const match = await bcrypt.compare(rqstbody.psswrd, userdata.SalaSana);
            if (match) {
                const tiiviste = await bcrypt.hash(rqstbody.salasana1, 10);
                const data = JSON.stringify({
                    query: `mutation {
                        salasananVaihto(Kayttajatunnus: "${userdata.KayttajaTunnus}", newpsswrd: "${tiiviste}")
                    }`,
                        variables: null
                    });
                    const vastaus = await fetch(
                        url,
                        {
                            method: 'post',
                            body: data,
                            headers: {
                                'Content-Type': 'application/json'
                            },
                        }
                    );
        
                const json = await vastaus.json();
                console.log(json.data.salasananVaihto);
                var huomautus = false;
                var modalcontent = "vahvistus";
            } else {
                var huomautus = "Väärä salasana!";
                var modalcontent = "vaihto";
            }
        } else {
            var huomautus = "Salasanat eivät täsmää!";
            var modalcontent = "vaihto";
        }
		
		cb(huomautus, modalcontent);
		
    }

};