// This module is used in updating an advertisement document with new modified values.
// The function takes the request body-object as it's only parameter. The description
// text that the user has submitted is first modified by escaping the angle-brackets
// and replacing the line breaks with "<br>". Then a grahpql-mutation is performed
// with node-fetch.

const fetch = require('node-fetch');
const { url } = require('../main');

module.exports = {

    "teeMuutokset": async (rqst, cb) => {
        let kuvaus = rqst.body.desc.replace(/(<|>)/gm,"").replace(/(\r\n|\n|\r)/gm,"<br>");
        const data = JSON.stringify({
            query: `mutation {
                ilmoituksenMuokkaus(id: ${rqst.body.IlmoitusId},
                                    otsikko: "${rqst.body.title}",
                                    kuvaus: "${kuvaus}",
                                    toimiala: ${rqst.body.ala},
                                    alue: ${rqst.body.maakunta})
            }`,
            variables: null
        });
        const vastaus = await fetch(
            url,
            {
                method: 'post',
                body: data,
                headers: {
                    'Content-Type': 'application/json'
                },
            }
        );
        const json = await vastaus.json();
        console.log(json.data.ilmoituksenMuokkaus);
        cb();
    }

};