// This module is used for updating a user document in the database by deleting an application id
// from user document's "Documents"-field. The function takes an application id-integer and a
// username-string as parameters. Then a graphql-mutation is performed with a node-fetch-module.

const fetch = require('node-fetch');
const { url } = require('../main');

module.exports = {

    "poistaTallennus": async (tunnus, ktunnus, cb) => {
        const data = JSON.stringify({
            query: `mutation {
                hakemusTallennusPoisto(kayttajatunnus: "${ktunnus}", hakemusid: ${tunnus})
                    }`,
            variables: null
        });
        const vastaus = await fetch(
            url,
            {
                method: 'post',
                body: data,
                headers: {
                    'Content-Type': 'application/json'
                },
            }
        );
        const json = await vastaus.json();
        console.log(json.data.hakemusTallennusPoisto);
        cb();
    }

};