// This module is used in adding an application id to a specific advertisement-document's
// applications-field in the database. The function takes an advertisement id-integer and an
// application id-integer as parameters. Then a graphql-mutation is performed with node-fetch-module.

const fetch = require('node-fetch');
const { url } = require('../main');

module.exports = {

    "lisaaHakemus": async (modalcontent, hakid, cb) => {
        let parsed = JSON.parse(modalcontent);
        const data = JSON.stringify({
            query: `mutation {
                        hakemusidLisays(ilmoitusid: ${parsed.IlmoitusId}, hakemusid: ${hakid})
                    }`,
            variables: null
        });
        const vastaus = await fetch(
            url,
            {
                method: 'post',
                body: data,
                headers: {
                    'Content-Type': 'application/json'
                },
            }
        );
        const json = await vastaus.json();
        console.log(json.data.hakemusidLisays);
        cb();
    }

};