// This module is used in adding a new application to the database. The function takes a request
// body-object and a username-string as parameters. The application's description-field the user
// has filled and submitted is first modified by escaping the angle-brackets and replacing the
// line breaks with "<br>". A datetime is also created and added to the mutation. A new application
// id is returned.

const fetch = require('node-fetch');
const { url } = require('../main');

module.exports = {

    "lahetaHakemus": async (rqstbody, username, cb) => {
        let hakemustext = rqstbody.hakemusteksti.replace(/(<|>)/gm, "").replace(/(\r\n|\n|\r)/gm, "<br>");
        let modalcontent = JSON.parse(rqstbody.mdlcntnt);
        const date = new Date();
        const datestring = date.toString();
        const data = JSON.stringify({
            query: `mutation {
                    hakemuksenLisays(aika: "${datestring}", ilmoitusId: ${modalcontent.IlmoitusId}, otsikko: "${rqstbody.otsikko}", kuvaus: "${hakemustext}", kayttajaTunnus: "${username}") {
                        HakemusId
                        }
                    }`,
            variables: null
        });
        const vastaus = await fetch(
            url,
            {
                method: 'post',
                body: data,
                headers: {
                    'Content-Type': 'application/json'
                },
            }
        );
        const json = await vastaus.json();
        cb(json.data.hakemuksenLisays.HakemusId);
    }

};