// This module is used for checking whether the cv upload has been done correctly. The function takes a request
// files-object as a parameter. First it checks if no file has been attached. Then it checks whether the file
// extension is invalid. Then the right notification-string is returned (if any). The "tiedosto"-field 1 in
// huomautus-object indicates a cv file (not image which is 0). The "lause"-string is the notification that is
// printed on the screen.

module.exports = {

    "tarkistaTiedosto": async (rqstfiles, cb) => {
        
        let huomautus = { tiedosto: null, lause: null };

        if (rqstfiles == null || !rqstfiles.cv || Object.keys(rqstfiles.cv).length === 0) {
            
            huomautus.tiedosto = 1;
            huomautus.lause = "Valitse ensin tiedosto!";
            
        } else {
            
            let parts = rqstfiles.cv.name.split(".");
            let xtnsn = (parts[parts.length - 1].toLowerCase());

            if (xtnsn != 'docx' && xtnsn != 'doc' && xtnsn != 'pdf' && xtnsn != 'txt' && xtnsn != 'rtf') {

                huomautus.tiedosto = 1;
                huomautus.lause = "Väärä tiedostomuoto! Tuetut tiedostomuodot ovat doc, pdf, txt ja rtf.";

            }
                   
        }
                
        cb(huomautus);
    
    }
                 
};