// This module is used to log user in to the webpage.
// The function takes request body-object and user data-object as parameters.
// The user's submitted password is compared to the password-hash in the "userdata"-object with bcrypt.
// If they match, a token is then signed for 12 hours with the username the user submitted.
// Then a new html-page will be displayed on the browser, that will automatically clear localStorage
// and set a new item "access_token" with the created token value to it, and redirects to front page.
// Should the user data-object be undefined or the passwords non-matched, a notification will be displayed.

const bcrypt = require('bcrypt');
var jwt = require('jsonwebtoken');
const { secret } = require('../main');

module.exports = {

    "kirjaudu": async (rqstbody, userdata, cb) => {

        const print = {
            "logsign": "log",
            "user": null,
            "token": null,
            "ruutu": rqstbody.kuvaruutu,
            "modal": false,
            "content": null,
            "huomautus": "Username or password incorrect!",
            "un": "",
            "pw": ""
        };

        if (userdata) {

            const match = await bcrypt.compare(rqstbody.password, userdata.SalaSana);

            if (match) {
                
                const token = jwt.sign({ username: rqstbody.username }, secret, { expiresIn: 43200 });
                let silta = `
                <!DOCTYPE html>
                    <html>
                        <head>
                            <meta charset="UTF-8">
                            <script>
                                window.onload = () => {
                                    setTimeout(() => {
                                        document.getElementById('send').click();
                                    }, 1000);
                                };
                                localStorage.clear();
                                localStorage.setItem('access_token', '${token}');
                            </script>
                        </head>
                        <body>
                            <h4>Odota hetki.</h4>
                            <form method="POST" action="/home">
                                <input type="hidden" name="access" value='${token}'>
                                <button style='visibility: hidden' id="send">Siirry etusivulle.</button>
                            </form>
                        <body>
                    </html>
                `;

                cb(null, silta);

            } else {

                cb(print);

            }

        } else {

            cb(print);

        }

    }

};