// This module is used for verifying the access-token submitted in the web-page.
// The function takes an access-token-string as a parameter. Then whether a token
// exists, it checks out it's validity with jwt.verify-operation with a pre-defined
// string. If the token is invalid, an error is returned. If the token is valid,
// the username-string is returned. And if no token exists, only null is returned
// in the callback.

const jwt = require('jsonwebtoken');
const { secret } = require('../main');

module.exports = {

    "tarkistaJWT" : async (token, cb) => {

        if (token) {

            let auth = await jwt.verify(token, secret, (err, data) => {
                if (err) {
                    console.log(err);
                    cb(err);
                }
                return data;
            });
                
			cb(null, auth.username);

        } else {

            cb(null);
        
        }
		
    }

};