// This module is used for checking whether the form used for adding a new advertisement is filled correctly.
// The function takes request's body-object, user data-object, screen- and modal-strings as parameters. The
// function first checks if both the jobfield and region selections are made. Then it also checks whether either
// of the textfields are empty. If something is missing, a notification is printed out. If not, then the process
// moves forward.

module.exports = {

    "tarkistaIlmoitus": async (rqstbody, userdata, kuvaruutu, modaali, cb) => {
        
        if (rqstbody.cnt) { var content = rqstbody.cnt; } else { var content = null; }
        let notification = "";

		if (rqstbody.ala == null || rqstbody.maakunta == "va") {
            notification = "<p style='color: red; text-shadow: 0px 0px 0px;'>Ala- ja alue-kentät ovat pakolliset!</p>";
        }

        if (rqstbody.title == "" || rqstbody.desc == "") {
            notification += "<p style='color: red; text-shadow: 0px 0px 0px;'>Täytä molemmat tekstikentät!</p>";
        }

        if (notification == "") {

            cb();

        } else {

            cb( Error, {
                "logsign": false,
                "user": userdata,
                "token": rqstbody.access,
                "ruutu": kuvaruutu,
                "modal": modaali,
                "ilmoitus": rqstbody,
                "content": JSON.parse(content),
                "huomautus": notification
            });

        }

	}
	
};