package ogakisoft.android.gesture.reform;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import ogakisoft.android.util.LOG;
import android.os.Parcel;
import android.os.Parcelable;

public class Feature implements Parcelable {
	private static final int IO_BUFFER_SIZE = 32 * 1024; // 32K
	private static final String TAG = "Feature";
	
	int strokes_count = 0;
	int vertical_straight = 0;
	int horizontal_straight = 0;
	int right_angle = 0;
	int slant_right_up = 0;
	int slant_right_down = 0;
	int slant_left_up = 0;
	int slant_left_down = 0;

	@Override
	public int describeContents() {
		return 0;
	}

	public static Feature deserialize(DataInputStream in) throws IOException {
		final Feature f = new Feature();
		f.strokes_count = in.readInt();
		f.vertical_straight = in.readInt();
		f.horizontal_straight = in.readInt();
		f.right_angle = in.readInt();
		f.slant_right_up = in.readInt();
		f.slant_right_down = in.readInt();
		f.slant_left_up = in.readInt();
		f.slant_left_down = in.readInt();
		return f;
	}
	
	public void serialize(DataOutputStream out) throws IOException {
		out.writeInt(strokes_count);
		out.writeInt(vertical_straight);
		out.writeInt(horizontal_straight);
		out.writeInt(right_angle);
		out.writeInt(slant_right_up);
		out.writeInt(slant_right_down);
		out.writeInt(slant_left_up);
		out.writeInt(slant_left_down);
	}

	@Override
	public void writeToParcel(Parcel out, int flags) {
		boolean result = false;
		final ByteArrayOutputStream byteStream = new ByteArrayOutputStream(
				IO_BUFFER_SIZE);
		final DataOutputStream outStream = new DataOutputStream(byteStream);
		try {
			serialize(outStream);
			result = true;
		} catch (IOException e) {
			LOG.e(TAG, "writeToParcel: {0}", e);
		} finally {
			try {
				outStream.close();
				byteStream.close();
			} catch (IOException e) {
				LOG.e(TAG, "writeToParcel: {0}", e);
			}
		}
		if (result) {
			out.writeByteArray(byteStream.toByteArray());
		}
	}
	
//	public static final Parcelable.Creator<Feature> CREATOR = new Parcelable.Creator<Feature>() {
//		public Feature createFromParcel(Parcel in) {
//			Feature feature = null;
//			final DataInputStream inStream = new DataInputStream(
//					new ByteArrayInputStream(in.createByteArray()));
//			try {
//				feature = deserialize(inStream);
//			} catch (IOException e) {
//				LOG.e(TAG, "createFromParcel: {0}", e.getMessage());
//			} finally {
//				if (null != inStream) {
//					try {
//						inStream.close();
//					} catch (IOException e) {
//						LOG.e(TAG, "createFromParcel: {0}", e.getMessage());
//					}
//				}
//			}
//			return feature;
//		}
//
//		public Feature[] newArray(int size) {
//			return new Feature[size];
//		}
//	};
	
	@Override
	public String toString() {
		return "Feature [strokes_count=" + strokes_count
				+ ", vertical_straight=" + vertical_straight
				+ ", horizontal_straight=" + horizontal_straight
				+ ", right_angle=" + right_angle + ", slant_right_up="
				+ slant_right_up + ", slant_right_down=" + slant_right_down + ", slant_left_up="+
				+slant_left_up + ", slant_left_down="+ slant_left_down + "]";
	}

}
