
package ogakisoft.android.util;

public class Vector {
    // private static final String TAG = "Vector";
    public float x;

    public float y;

    public Vector() {
        x = 0f;
        y = 0f;
    }

    public Vector(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vector add(Vector v) {
        x += v.x;
        y += v.y;
        return this;
    }

    public Vector sub(Vector v) {
        x -= v.x;
        y -= v.y;
        return this;
    }

    public Vector reverse() {
        x *= -1;
        y *= -1;
        return this;
    }

    public Vector normalize() {
        float length = (float) Math.sqrt(x * x + y * y);
        if (length < 0.0001f)
            length = 1.0f;
        x /= length;
        y /= length;
        return this;
    }

//    public static float argument(float x, float y) {
//        double radians = 0;
//        if (x == 0) {
//            if (y > 0)
//                radians = Math.PI / 2;
//            else
//                radians = Math.PI * 3 / 2;
//        } else {
//            double tan = y / Math.abs(x);
//            radians = Math.atan(tan);
//            if (x < 0) {
//                radians = Math.PI - radians;
//            } else {
//                if (y < 0) {
//                    radians = 2 * Math.PI + radians;
//                }
//            }
//        }
//        return (float) radians;
//    }
}
