/*
	nullptr Interpreter.
	(C) 2015 VOSystems.
*/

#pragma once

#include<vector>
#include<string>
#include<regex>
#include<fstream>

#include"Interpreter.h"
#include"Module.h"
#include"Preprocessor.h"

namespace VOSystemsNullptr
{
	class Nullptr
	{
	private:
		Core::Interpreter m_int;
		Core::Module m_module;
		Core::Preprocessor m_pre;
	public:

	};

	namespace BasicTypes
	{

		typedef struct _Int{
			unsigned long long data;
			bool positive;
		}Int;

		class IntManager
		{
		private:
			BasicTypes::Int m_data;
			std::string m_name;
			
		public:
			IntManager(std::string name, Int data) :m_name(name),m_data(data) {};
			IntManager(void){};
			void operator=(Int data);

			BasicTypes::Int operator+(BasicTypes::Int i);
			BasicTypes::Int operator-(BasicTypes::Int i);
			BasicTypes::Int operator*(BasicTypes::Int i);
			BasicTypes::Int operator/(BasicTypes::Int i);
			BasicTypes::Int operator%(BasicTypes::Int i);
			BasicTypes::Int operator()(void);
			std::string operator()(char type);
			std::string operator()(BasicTypes::Int i, char type);
			bool operator==(IntManager to);
			bool operator!=(IntManager to);
			bool operator<(IntManager to);
			bool operator<=(IntManager to);
			bool operator>(IntManager to);
			bool operator>=(IntManager to);
			
			BasicTypes::Int GetValue(void);
			std::string GetName(void);
		};

		BasicTypes::Int operator+(BasicTypes::Int,BasicTypes::Int);
		BasicTypes::Int operator-(BasicTypes::Int,BasicTypes::Int);
		BasicTypes::Int operator*(BasicTypes::Int,BasicTypes::Int);
		BasicTypes::Int operator/(BasicTypes::Int,BasicTypes::Int);
		BasicTypes::Int operator%(BasicTypes::Int,BasicTypes::Int);

		typedef struct _String{
			std::string name;
			std::string data;
		}String;

		typedef struct _Bool{
			bool data;
			std::string name;
		}Bool;
	}
	
	namespace System{

		enum Types{
			NotFound=0,
			BoolType=1,
			IntType=2,
			StringType=4,
		};

		typedef struct _Identifier{
			std::string name;
			std::streamoff pos;
			unsigned char type;
		}Identifier;

		typedef std::vector<Identifier> IdentifierList;

		class FileOperator
		{
		private:
			size_t m_eip;
			std::string m_src;
			std::string m_separator;

		public:
			FileOperator(std::string source, std::string separator) :m_src(source), m_separator(separator), m_eip(0) {};

			std::string operator()(void);
			std::string operator()(size_t startpoint);
			std::string operator=(std::string source);

			streamoff GetStreamOffset(void) const;
		};

		class StringModule
		{
		public:
			std::vector<std::string> Split(const std::string &str, const std::string &delim);//񕪊
			std::string Replace(std::string src, std::string before, std::string after);//u
			bool Find(const std::string& str, const std::string& find);//񌟍
		};
	}
#define loop(count)	for(size_t LoopCounter=0; LoopCounter<count; LoopCounter++)
}