/*
	nullptr interpreter
	(C) 2015 VOSystems.
*/

#include"nullptr.h"
#include"Interpreter.h"
#include<iostream>
#include<fstream>
#include<direct.h>
#include<cctype>
#include<algorithm>
#include<Windows.h>

using namespace VOSystemsNullptr;
using namespace std;

vector<string> System::StringModule::Split(const string &str, const string &delim)
{
	vector<string> res;
	size_t current = 0, found, delimlen = delim.size();
	while ((found = str.find(delim, current)) != string::npos) {
		res.push_back(string(str, current, found - current));
		current = found + delimlen;
	}
	res.push_back(string(str, current, str.size() - current));
	return res;
}

std::string System::StringModule::Replace(std::string src, std::string before, std::string after)
{
	std::string::size_type  Pos(src.find(before));

	while (Pos != std::string::npos){
		src.replace(Pos, before.length(), after);
		Pos = src.find(before, Pos + after.length());
	}

	return src;
}

bool System::StringModule::Find(const string& str, const string& find)
{
	return(str.find(find) != string::npos);
}

Nullptr::Nullptr(std::string file) :m_src(file), m_eip(ios_base::beg)
{
	cout<<"VOSystems nullptr Interpreter [Version "<<m_major<<"."<<m_minor<<"."<<m_build<<"]"<<endl;
	cout<<"Copyright (C) 2015 VOSystems. All rights reserved."<<endl<<endl;
	Extract();
}

Nullptr::~Nullptr(void)
{
	_rmdir("NullptrTmp");
}



void Nullptr::Work(void)
{
	do{
		LineLoad();

		if (Find(m_workline,m_stdout)) {
			Screen(m_workline);
			
		}else if(Find(m_workline,m_stdin)){
			Keyboard(m_workline);

		}else if(Find(m_workline,m_stderr)){
			EScreen(m_workline);

		}else if(Find(m_workline,"Int") || Find(m_workline,"String")){
			NewVar(m_workline);

		}else if(Find(m_workline,"Thread")){

		}

	}while(!m_workline.empty());

	cout<<endl<<endl;
	for(int C=3; C>0;C--){
		cout<<"\r"<<C<<" second(s) remaining until the automatic termination."<<flush;
		Sleep(1000);
	}
}

void Nullptr::LineLoad(void)
{
	ifstream fin(m_src);
	fin.seekg(m_eip,ios_base::beg);

	char buf[1024] = {0};
	fin.get(buf, 1024, ';');
	
	m_workline = buf;
	m_workline = Replace(m_workline, "\n", "");
	m_workline = Replace(m_workline, "\r", "");
	m_workline = Replace(m_workline, "\t", "");
	m_workline = Replace(m_workline, ";", "");

	m_eip = fin.tellg();
	m_eip++;
	fin.close();
}

