/*

*/

#include<direct.h>
#include<fstream>

#include"Preprocessor.h"

using namespace VOSystemsNullptr::Core;
using namespace std;

Preprocessor::Preprocessor(string source) :fope(source,"\n") {}

void Preprocessor::Extract(void)
{
	_mkdir("NullptrTmp");
	ofstream fout("./NullptrTmp/Extracted.nullptr");
	string line;
	do{
		line=fope();

		if (Find(line, "#include")) {
			string str(line.begin()+line.find_first_of('\"')+1, line.begin()+line.find_last_of('\"'));

			ifstream ufile(str);

			if(!ufile)goto ErrorNext;

			ufile.seekg(0,ios_base::end);
			size_t len=ufile.tellg();
			ufile.seekg(0,ios_base::beg);

			char* ch=new char[len];

			ufile.read(ch,len);

			fout<<ch<<endl;

			delete ch;

		}else if (regex_match(line, regex("#pragma comment(lib,\".+\""))) {
			string str(line.begin()+line.find_first_of('\"')+1, line.begin()+line.find_last_of('\"'));

			ifstream ufile(str+".nullptrmodule");
			if(!ufile)goto ErrorNext;
			ufile.close();

			m_modulefiles.push_back(str+".nullptrmodule");
		}else{
			fout<<line<<";"<<endl;
		}
	ErrorNext:;
	}while(!line.empty());

	fope = "./NullptrTmp/Extracted.nullptr";
}

void Preprocessor::Trim(void)
{
	ofstream fout("./NullptrTmp/Prerocessed.nullptr");
	string line;
	bool lcomment=false;
	do{
		line=fope();
		
		if(Find(line,"//")){
			bool first=false;

			for(size_t C=0; C<line.size(); C++){
				if(line[C]=='/' && !first){
					first=true;

				}else if(line[C]=='/'){
					break;

				}else if(first && line[C]!='/'){
					fout<<"/"<<line[C];
					first=false;

				}else{
					fout<<line[C];

				}
			}
		}else if(Find(line,"/*")){
			bool first=false;

			for(size_t C=0; C<line.size(); C++){
				if(line[C]=='/' && !first){
					first=true;

				}else if(line[C]=='*'){
					break;

				}else if(first && line[C]!='*'){
					fout<<"/"<<line[C];
					first=false;

				}else{
					fout<<line[C];

				}
			}

			lcomment=true;

		}else if(Find(line,"*/")){
			for(size_t C=0; C<line.size()-1; C++){
				if(line[C]=='*' && line[C]=='/'){
					fout<<string(line.begin()+C,line.end());
					break;
				}
			}
			lcomment=false;

		}else{
			if(!lcomment){
				fout<<line;
			}
		}
	}while(!line.empty());
}

void Preprocessor::LoadLib(Library& module)
{
	regex func_regex(R"(.+ .+(Int \d+\s*,\s*String \d+\s*,\s*bool \d+\s*);*)");
	regex bool_regex(R"(bool .+(Int \d+\s*,\s*String \d+\s*,\s*bool \d+\s*);*)");
	regex int_regex(R"(Int .+(Int \d+\s*,\s*String \d+\s*,\s*bool \d+\s*);*)");
	regex str_regex(R"(String .+(Int \d+\s*,\s*String \d+\s*,\s*bool \d+\s*);*)");

	string line;
	
	for(size_t C=0; C<m_modulefiles.size(); C++){
		System::FileOperator fop(m_modulefiles[C],";");
		do{
			line=fop();
			if(regex_match(line,func_regex)){
				LibraryFunction mf;
				mf.dllname=m_modulefiles[C];
				string::iterator start;
				
				if(regex_match(line,bool_regex)){
					mf.mode=System::BoolType;
					start=line.begin()+5;

				}else if(regex_match(line,int_regex)){
					mf.mode=System::IntType;
					start=line.begin()+4;

				}else if(regex_match(line,str_regex)){
					mf.mode=System::StringType;
					start=line.begin()+7;

				}else{
					mf.mode=System::NotFound;
					start=line.begin()+4;

				}
				char name[32]={0};
				for(size_t C=0; *start!='(' || C<32; start++ ,C++)name[C]=*start;
				mf.name=name;
				
				size_t whrint=line.find_last_of("Int")+4;
				size_t whrstr=line.find_last_of("String")+7;
				size_t whrbool=line.find_last_of("bool")+5;

				mf.ArguBool=stoul(string(line.begin()+whrbool, line.begin()+line.find_last_of(")")));
				mf.ArguInt=stoul(string(line.begin()+whrint, line.begin()+whrstr-7));
				mf.ArguString=stoul(string(line.begin()+whrstr, line.begin()+whrbool-4));
				
				module.push_back(mf);
			}
		}while(!line.empty());
	}
}

void RegID(VOSystemsNullptr::System::IdentifierList& idlist, uint8_t type, const VOSystemsNullptr::System::FileOperator& fope, string line)
{
	VOSystemsNullptr::System::Identifier id;
	id.type=type;
	id.pos=fope.GetStreamOffset();
	
	string::iterator start,end;
	switch(type){
	case VOSystemsNullptr::System::NotFound:
	default:
		break;

	case VOSystemsNullptr::System::IntType:
		start=line.begin()+4;
		break;
	case VOSystemsNullptr::System::StringType:
		start=line.begin()+7;
	case VOSystemsNullptr::System::BoolType:
		start=line.begin()+5;
	}
	id.name=string(start,line.begin()+line.find_first_of('('));

	idlist.push_back(id);

	return;
}

void Preprocessor::LoadId(System::IdentifierList& list)
{
	regex 
		bool_regex(R"(bool[\s\t]+.+)"),
		int_regex(R"(Int[\s\t]+.+)"),
		str_regex(R"(String[\s\t]+.+)");

	System::FileOperator fope(m_src,";");
	string line;
	do{
		line=fope();

		if(regex_match(line,bool_regex)){
			RegID(list,System::BoolType,fope,line);

		}else if(regex_match(line,int_regex)){
			RegID(list,System::IntType,fope,line);

		}else if(regex_match(line,str_regex)){
			RegID(list,System::StringType,fope,line);

		}

	}while(!line.empty());
}