/****************************************
*VaneOS.h
*Vane Operating System Common Header
*(C) 2014 VOSystems.
****************************************/

/*INCLUDE GUARD*/
#ifndef VANEOS_H
#define VANEOS_H

#define local static
#define DEBUG while(getchar()!='\n')
void write_mem_8(int,int);
void farjmp(int eip,int cs);

void io_hlt(void);
void io_cli(void);
void io_sti(void);
void io_stihlt(void);
int io_in8(int port);
void io_out8(int port, int data);
int io_load_eflags(void);
void io_store_eflags(int eflags);

int Check_VESA(void);
void ScreenVGA_Graphic(void);

extern int vram_start_address;
extern char vmode;
extern short scrnX,scrnY;

void init_all(void);
int getmsg(int msg_num);
void sendmsg(int msg,int msg_num);

#define COL8_000000		0
#define COL8_FF0000		1
#define COL8_00FF00		2
#define COL8_FFFF00		3
#define COL8_0000FF		4
#define COL8_FF00FF		5
#define COL8_00FFFF		6
#define COL8_FFFFFF		7
#define COL8_C6C6C6		8
#define COL8_840000		9
#define COL8_008400		10
#define COL8_848400		11
#define COL8_000084		12
#define COL8_840084		13
#define COL8_008484		14
#define COL8_848484		15

/*DEFINE COMMON*/
typedef unsigned char  BYTE;
typedef unsigned short WORD;
typedef unsigned long  DWORD;

typedef unsigned long long u_int8_t;
typedef unsigned int u_int4_t;
typedef unsigned short u_int2_t;
typedef unsigned short u_int1_t;

#define ADR_BOOTINFO	0x00000ff0
#define ADR_DISKIMG		0x00100000
#define FAT_DISK_PLASE	0x00020000
#define BPB_SECTOR		63
#define SECTOR_SIZE		512

#define EX_CHAR_SHORT(source)	(unsigned short)(*source++ <<8) | *source++

typedef struct
{
	char bootstrap_code[3];
	char label[8];
	unsigned short sector_byte;
	unsigned char clust_sector;
	unsigned short reserved_sector;
	unsigned char fat;
	unsigned short root_dir_entry;
	unsigned short sector;
	unsigned char media_code;
	unsigned short fat_sector;
	unsigned short track_sector;
	unsigned short drive_head;
	unsigned int un_known_sector;
	unsigned int all_sector;
	unsigned int one_fat_sector;
	unsigned short flag;
	unsigned short fs_ver;
	unsigned int root_dir_start_clust_no;
	unsigned short fs_sys_info;
	unsigned short back_up_sector;
	char reserved[12];
	unsigned char physical_drive_no;
	char reserved2;
	char boot_signature;
	unsigned int volume_s_ID;
	char volume_label[11];
	char fs_type[8];
}bpb_data_t;

#endif
