/*

*/
#include<VaneOS.h>

unsigned char* file_readBPB(void)
{
	unsigned char *BPB,*BPB_source=(unsigned char*)(BPB_SECTOR*SECTOR_SIZE);
	int C=0;
	for(C=0;C<0x52;C++)
	{
		BPB[C]=BPB_source[C];
	}
	return BPB;
}

void generate_bpb(bpb_data_t* bpb,const unsigned char* source)
{
	int c=0;
	for(c=0;c<3;c++)
		bpb->bootstrap_code[c]=*source++;
	for(c=0;c<8;c++)
		bpb->label[c]=*source++;
	bpb->sector_byte=EX_CHAR_SHORT(source);
	bpb->clust_sector=*source++;
	bpb->reserved_sector=EX_CHAR_SHORT(source);
	bpb->fat=*source++;
}
/*
0x11	ルートディレクトリエントリ数 (FAT32 では 0)	2
0x13	全セクタ数 (FAT32 では 0)	2
0x15	メディアコード	1
0x16	FAT のセクタ数	2
0x18	1 トラックあたりのセクタ数	2
0x1a	ドライブのヘッド数	2
0x1c	不可視セクタ数	4
0x20	全セクタ数	4
0x24	FAT 1 つあたりのセクタ数	4
0x28	フラグ	2
0x2a	ファイルシステムバージョン	2
0x2c	ルートディレクトリの開始クラスタ番号	4
0x30	ファイルシステム情報のセクタ番号	2
0x32	バックアップセクタ番号	2
0x34	予約	12
0x40	物理ドライブ番号	1
0x41	予約	1
0x42	ブートシグネチャ	1
0x43	ボリュームシリアル ID	4
0x47	ボリュームラベル	11
0x52	ファイルシステムタイプ	8
*/
void file_readfat(int *fat,unsigned char *img,unsigned int sector)
{
	int i,j=0;
	for(i=0;i<sector;i+=2)
	{
		fat[i+0]=(img[j+0] | img[j+1]<<8) & 0xfff;
		fat[i+1]=(img[j+1]>>4 | img[j+2]<<4) & 0xfff;
		j+=3;
	}
	return;
}

void file_loadfile(int clustno,int size,char* buf,int* fat,char* img)
{
	int i;
	while(1)
	{
		if(size<=512)
		{
			for(i=0;i<size;i++)
			{
				buf[i]=img[clustno*512+i];
			}
			break;
		}
		for(i=0;i<512;i++)
		{
			buf[i]=img[clustno*512+i];
		}
		size-=512;
		buf+=512;
		clustno=fat[clustno];
	}
	return;
}
