﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Windows;
using System.Windows.Interop;
using Forms = System.Windows.Forms;

namespace JoinNotes
{
    /// <summary>
    /// Application.xaml の相互作用ロジック
    /// </summary>
    public partial class Application : System.Windows.Application
    {
        internal const int WM_HOTKEY = 0x312;
        internal const int WM_ACTIVATEAPP = 0x1C;
        internal const int WM_APP = 0x8000;
        internal const int WM_APP_ACTIVATEAPP = WM_APP + 1;
        internal const int SW_RESTORE = 9;

        internal static Dictionary<string, int> HotKeyId = new Dictionary<string, int> { };
        internal static Dictionary<string, HotKey> HotKey = new Dictionary<string, HotKey> { };

        internal static Search searchWindow;
        internal static Config configWindow;
        internal static Forms.Form aboutWindow;
        //internal static Menu mainWindow;
        internal static NotifyTray mainWindow;
        //internal static Menu NotifyContainer { get; set; }
        internal static Window NotifyContainer { get; set; }
        internal static FileInfo HelpFile;
        //internal string basepath;
        internal static DirectoryInfo DocumentPath;
        internal static DirectoryInfo DocumentPathDefault;

        //internal static Window MainWindow { get; private set; }
        internal static Application Instance { get; private set; }

        internal Dictionary<Uri, Editor> EditorWindows = new Dictionary<Uri, Editor> { };
        internal HashSet<Editor> UntitledEditorWindows = new HashSet<Editor> { };

        internal static string NotifyContainerTitle { get; private set; }
        internal static Microsoft.VisualBasic.ApplicationServices.AssemblyInfo AssemblyInfo { get; private set; }

        static Application()
        {
            __t.test();
        }

        public Application()
        {
            this.Exit += new ExitEventHandler(Application_Exit);
        }

        protected override void OnStartup(StartupEventArgs e)
        {
            Application.Instance = this;
            Application.AssemblyInfo = new Microsoft.VisualBasic.ApplicationServices.AssemblyInfo(Assembly.GetExecutingAssembly());

            Application.NotifyContainerTitle = Assembly.GetEntryAssembly().GetName().Name + " " + this.GetType().Name;

            var current = Process.GetCurrentProcess();


            //HACK: なぜかApplication.xamlの<Application.Resources>セクションで定義するとデザイン時にファイルが見つからないエラーが出るので、ここで指定。
            this.Resources.Source = new Uri(@"pack://application:,,,/JoinNotes;component/Themes/Generic.xaml");

            Application.HelpFile = new FileInfo("JoinNotes.chm");

            //// デバッグ用
            //var otherProcs = Process.GetProcessesByName("JoinNotes").ToList();
            //otherProcs.AddRange(Process.GetProcessesByName("JoinNotes.vshost"));
            //otherProcs = otherProcs.Where(p => p.Id != current.Id).ToList();

            //FIXME: リリース時はこちら
            var otherProcs = Process.GetProcessesByName(current.ProcessName).Where(p => p.MainModule.FileName == current.MainModule.FileName && p.Id != current.Id).ToList();

            if (otherProcs.Count() == 0)
            {
                Application.Current.MainWindow = Application.mainWindow;
                //Application.Current.MainWindow = Application.searchWindow;

                ////FIXME: remove
                //Application.Current.MainWindow.Show();

                base.OnStartup(e);
            }
            else
            {
                Debug.Assert(otherProcs.Count() >= 1);
                otherProcs.ForEach(new Action<Process>((p) => Debug.WriteLine(new { p.MainWindowHandle, p.MainWindowTitle }, "Send wakeup message to ")));
                //Util.WakeupWindow(otherProcs.First().MainWindowHandle);
                Util.WakeupWindow(otherProcs.First());
                //Util.WakeupWindow(otherProcs.First().Handle);
                this.Shutdown();
            }
        }

        //FIXME: OnStartupと統合
        void Application_Startup(object sender, StartupEventArgs e)
        {
            //{
            //    var activateHotKey = new HotKey(Application.mainWindow.Handle,
            //        Menu.HotKey_ActivateHotKeyId,
            //        System.Windows.Forms.Keys.Oem5, // Oem5: \
            //        System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.Alt); //HACK: Keys.AltはShiftキーのこと。
            //    Menu.HotKey_ActivateHotKey = activateHotKey;
            //}

            //searchWindow.Show();
            //editorWindow.Owner = Application.Current.MainWindow;

            //mainWindow.Show();
            //editorWindow.Show();
            //searchWindow.Show();
            //configWindow.Show();

            //this.ShutdownMode = System.Windows.ShutdownMode.OnExplicitShutdown;
            this.ShutdownMode = System.Windows.ShutdownMode.OnMainWindowClose;

            //Application.mainWindow = new Menu();
            Application.mainWindow = new NotifyTray();
            Application.NotifyContainer = Application.mainWindow;

            //HACK: 一度表示しないとなぜかプロセス外からEnumWindows()で発見できないので
            Application.NotifyContainer.Show();
            Application.NotifyContainer.Hide();

            Application.searchWindow = new Search();
            Application.configWindow = new Config();
            Application.aboutWindow = new AboutBox1();

            //Application.searchWindow.Owner = Application.mainWindow;
            //Application.configWindow.Owner = Application.mainWindow;

            Application.Current.MainWindow.Closed += new EventHandler(Window_Closed);
            configWindow.Closed += new EventHandler(Window_Closed);

            Application.Instance.ApplySettings();

            InvokeStartupTask();

            //Application.Current.MainWindow.Show();
        }

        internal void InvokeStartupTask()
        {
            //FIXME: スタートアップ時に開くウィンドウは別の設定項目に
            var classname = JoinNotes.Properties.Settings.Default.StartupWindowClassName;
            Window startupWindow;
            if (classname == typeof(Editor).Name)
                startupWindow = Editor.Create(Util.ValidateFilename(JoinNotes.Properties.Settings.Default.StartPageName) + @".join.rtf");
            else
                startupWindow = this.GetWindow(classname);

            startupWindow.Show();
            startupWindow.Activate();
        }

        //void App_Startup(object sender, StartupEventArgs e)
        //{
        //    Debug.Assert(Application.mainWindow != null && Application.mainWindow is NotifyTray);
        //    //Application.NotifyContainer = new Menu();
        //    Application.NotifyContainer = Application.mainWindow;
        //}

        //FIXME: Application_Exitと統合
        protected override void OnExit(ExitEventArgs e)
        {
            base.OnExit(e);

            if (searchWindow != null)
                searchWindow.Close();
            if (configWindow != null)
                configWindow.Close();
            if (mainWindow != null)
                mainWindow.Close();
        }

        internal void Window_Closed(object sender, EventArgs e)
        {
            var c = (Window)sender;

            if (hiddenWindows.Contains(c))
                hiddenWindows.Remove(c);
        }

        void Application_Exit(object sender, ExitEventArgs e)
        {
            Application.NotifyContainer.Close();

            if (Application.HotKey["ActivateHotKey"] != null)
                try
                {
                    Application.HotKey["ActivateHotKey"].Unregister();
                }
                catch (Win32Exception ex)
                {
                    Debug.WriteLine(ex.Message, ex.Source);
                }
        }

        internal Window GetWindow(string classname)
        {
            Window ret;

            //FIXME: ComboBoxでのラベルと設定値の対応付け方法
            if (classname == typeof(Editor).Name)
            {
                ret = Editor.Create();

                //FIXME: GetWindowかEditor.Create()か一方に統一
                //FIXME: Create(string) -> Create(ValidFilename型)
                //ret = Editor.Create(Util.ValidateFilename(JoinNotes.Properties.Settings.Default.StartPageName) + @".join.rtf");
            }
            else if (classname == typeof(Search).Name)
            {
                if (Application.searchWindow == null)
                    Application.searchWindow = new Search();
                ret = Application.searchWindow;
            }
            else if (classname == typeof(Config).Name)
            {
                if (Application.configWindow == null)
                    Application.configWindow = new Config();
                ret = Application.configWindow;
            }
            else if (classname == typeof(NotifyTray).Name)
            {
                if (Application.mainWindow == null)
                    Application.mainWindow = new NotifyTray();
                ret = Application.mainWindow;
            }
            else
            {
                ret = null;
                Debug.Fail("GetWindow", "classname: " + classname);
            }

            return ret;
        }

        internal static void SwitchApplicationVisibility()
        {
            // ウィンドウが1つでも表示されていれば、全てを記録して非表示。1つも表示されていなければ記録してあるWindowを全て表示。
            var ws = new List<Window>(Application.Current.Windows.Cast<Window>());
            if (ws.Exists(w => w.IsVisible))
                InactivateWindows();
            else
                ActivateWindows();
        }

        private static HashSet<Window> hiddenWindows = new HashSet<Window> { };
        internal static void InactivateWindows()
        {
            Application.hiddenWindows.Clear();

            var ws = new List<Window>(Application.Current.Windows.Cast<Window>());
            foreach (var w in ws.Where(w => w.IsVisible))
            {
                w.Visibility = Visibility.Collapsed;
                Application.hiddenWindows.Add(w);
            }
        }

        internal static void ActivateWindows()
        {
            var ws = new List<Window>(Application.Current.Windows.Cast<Window>());
            foreach (var w in ws.Where(w => Application.hiddenWindows.Contains(w)))
            {
                w.Show();
                if (w.WindowState == WindowState.Minimized)
                    w.WindowState = WindowState.Normal;
                w.Activate();
                Application.hiddenWindows.Remove(w);
            }
        }

        void ApplySettings()
        {
            // 設定の読み込み・有効化

            {
                //FIXME: ActivateHotkeyを型にあった名前に
                var hotKeyName = "ActivateHotKey";
                ApplySettings2(hotKeyName);
            }
            {
                //FIXME: OpenWindowHotKeyを型にあった名前に
                var hotKeyName = "OpenWindowHotKey";
                ApplySettings2(hotKeyName);
            }

            //try
            //{
            //    //FIXME: OpenWindowHotKeyを型にあった名前に
            //    var keys = Properties.Settings.Default.OpenWindowHotKey;
            //    //var hotKey = new HotKey(Application.mainWindow.Handle,
            //    var hotKey = new HotKey(new WindowInteropHelper(Application.mainWindow).Handle,
            //        NotifyTray.HotKey_OpenWindowHotKeyId,
            //        keys & Forms.Keys.KeyCode,
            //        keys & Forms.Keys.Modifiers);
            //    NotifyTray.HotKey_OpenWindowHotKey = hotKey;
            //}
            //catch (Win32Exception ex)
            //{
            //    Debug.WriteLine(ex.Message, ex.Source);
            //}

            try
            {
                Application.DocumentPathDefault = new DirectoryInfo(Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments, Environment.SpecialFolderOption.None), @"JoinNotes"));

                //FIXME: 設定をApplicationに置くかConfigに置くか
                Application.DocumentPath = (JoinNotes.Properties.Settings.Default.DocumentPath == "")
                    ? new DirectoryInfo(Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments, Environment.SpecialFolderOption.None), Application.AssemblyInfo.ProductName))
                    : new DirectoryInfo(JoinNotes.Properties.Settings.Default.DocumentPath);
                //FIXME: ディレクトリが無ければモードレスな警告をするだけに。ディレクトリ設定はデフォルトと見なす。
                if (!Application.DocumentPath.Exists) Application.DocumentPath.Create();
            }
            catch (Exception ex)
            {
                Debug.WriteLine(ex.Message, ex.Source);
            }
        }

        private void ApplySettings2(string hotKeyName)
        {
            try
            {
                var keys = (Forms.Keys)JoinNotes.Properties.Settings.Default[hotKeyName];
                //var hotKey = new HotKey(Application.mainWindow.Handle,
                var hotKey = new HotKey(new WindowInteropHelper(Application.mainWindow).Handle,
                    Application.HotKeyId[hotKeyName],
                    keys & Forms.Keys.KeyCode,
                    keys & Forms.Keys.Modifiers);
                Application.HotKey[hotKeyName] = hotKey;
            }
            catch (Win32Exception ex)
            {
                Debug.WriteLine(ex.Message, ex.Source);
            }
        }

    }

}
