/*
 * roma kana converter rule structure
 *
 * $Id: rkmap.h,v 1.6 2002/11/05 15:38:58 yusuke Exp $
 */

static const struct rk_rule rk_rule_alphabet[] =
{
	{"a", "a", NULL},
	{"b", "b", NULL},
	{"c", "c", NULL},
	{"d", "d", NULL},
	{"e", "e", NULL},
	{"f", "f", NULL},
	{"g", "g", NULL},
	{"h", "h", NULL},
	{"i", "i", NULL},
	{"j", "j", NULL},
	{"k", "k", NULL},
	{"l", "l", NULL},
	{"m", "m", NULL},
	{"n", "n", NULL},
	{"o", "o", NULL},
	{"p", "p", NULL},
	{"q", "q", NULL},
	{"r", "r", NULL},
	{"s", "s", NULL},
	{"t", "t", NULL},
	{"u", "u", NULL},
	{"v", "v", NULL},
	{"w", "w", NULL},
	{"x", "x", NULL},
	{"y", "y", NULL},
	{"z", "z", NULL},
	{"A", "A", NULL},
	{"B", "B", NULL},
	{"C", "C", NULL},
	{"D", "D", NULL},
	{"E", "E", NULL},
	{"F", "F", NULL},
	{"G", "G", NULL},
	{"H", "H", NULL},
	{"I", "I", NULL},
	{"J", "J", NULL},
	{"K", "K", NULL},
	{"L", "L", NULL},
	{"M", "M", NULL},
	{"N", "N", NULL},
	{"O", "O", NULL},
	{"P", "P", NULL},
	{"Q", "Q", NULL},
	{"R", "R", NULL},
	{"S", "S", NULL},
	{"T", "T", NULL},
	{"U", "U", NULL},
	{"V", "V", NULL},
	{"W", "W", NULL},
	{"X", "X", NULL},
	{"Y", "Y", NULL},
	{"Z", "Z", NULL},

	{NULL, NULL, NULL}
};

static const struct rk_rule rk_rule_walphabet[] =
{
	{"a", "", NULL},
	{"b", "", NULL},
	{"c", "", NULL},
	{"d", "", NULL},
	{"e", "", NULL},
	{"f", "", NULL},
	{"g", "", NULL},
	{"h", "", NULL},
	{"i", "", NULL},
	{"j", "", NULL},
	{"k", "", NULL},
	{"l", "", NULL},
	{"m", "", NULL},
	{"n", "", NULL},
	{"o", "", NULL},
	{"p", "", NULL},
	{"q", "", NULL},
	{"r", "", NULL},
	{"s", "", NULL},
	{"t", "", NULL},
	{"u", "", NULL},
	{"v", "", NULL},
	{"w", "", NULL},
	{"x", "", NULL},
	{"y", "", NULL},
	{"z", "", NULL},
	{"A", "", NULL},
	{"B", "", NULL},
	{"C", "", NULL},
	{"D", "", NULL},
	{"E", "", NULL},
	{"F", "", NULL},
	{"G", "", NULL},
	{"H", "", NULL},
	{"I", "", NULL},
	{"J", "", NULL},
	{"K", "", NULL},
	{"L", "", NULL},
	{"M", "", NULL},
	{"N", "", NULL},
	{"O", "", NULL},
	{"P", "", NULL},
	{"Q", "", NULL},
	{"R", "", NULL},
	{"S", "", NULL},
	{"T", "", NULL},
	{"U", "", NULL},
	{"V", "", NULL},
	{"W", "", NULL},
	{"X", "", NULL},
	{"Y", "", NULL},
	{"Z", "", NULL},

	{NULL, NULL, NULL}
};

#define SKK_LIKE_KIGO_MAP \
	{"z/", "", NULL}, \
	{"z[", "", NULL}, \
	{"z]", "", NULL}, \
	{"z,", "", NULL}, \
	{"z.", "", NULL}, \
	{"z-", "", NULL}, \
	{"zh", "", NULL}, \
	{"zj", "", NULL}, \
	{"zk", "", NULL}, \
	{"zl", "", NULL}

static const struct rk_rule rk_rule_hiragana[] =
{
	SKK_LIKE_KIGO_MAP,

	{"a", "", NULL},
	{"i", "", NULL},
	{"u", "", NULL},
	{"e", "", NULL},
	{"o", "", NULL},

	{"xa", "", NULL},
	{"xi", "", NULL},
	{"xu", "", NULL},
	{"xe", "", NULL},
	{"xo", "", NULL},
	
	{"ka", "", NULL},
	{"ki", "", NULL},
	{"ku", "", NULL},
	{"ke", "", NULL},
	{"ko", "", NULL},

	{"kya", "", NULL},
	{"kyi", "", NULL},
	{"kyu", "", NULL},
	{"kye", "", NULL},
	{"kyo", "", NULL},

	{"k", "", "k"},

	{"ga", "", NULL},
	{"gi", "", NULL},
	{"gu", "", NULL},
	{"ge", "", NULL},
	{"go", "", NULL},

	{"gya", "", NULL},
	{"gyi", "", NULL},
	{"gyu", "", NULL},
	{"gye", "", NULL},
	{"gyo", "", NULL},

	{"g", "", "g"},

	{"sa", "", NULL},
	{"si", "", NULL},
	{"su", "", NULL},
	{"se", "", NULL},
	{"so", "", NULL},

	{"sya", "", NULL},
	{"syi", "", NULL},
	{"syu", "", NULL},
	{"sye", "", NULL},
	{"syo", "", NULL},

	{"sha", "", NULL},
	{"shi", "", NULL},
	{"shu", "", NULL},
	{"she", "", NULL},
	{"sho", "", NULL},

	{"s", "", "s"},

	{"za", "", NULL},
	{"zi", "", NULL},
	{"zu", "", NULL},
	{"ze", "", NULL},
	{"zo", "", NULL},

	{"zya", "", NULL},
	{"zyi", "", NULL},
	{"zyu", "", NULL},
	{"zye", "", NULL},
	{"zyo", "", NULL},

	{"z", "", "z"},

	{"ja", "", NULL},
	{"ji", "", NULL},
	{"ju", "", NULL},
	{"je", "", NULL},
	{"jo", "", NULL},

	{"jya", "", NULL},
	{"jyi", "", NULL},
	{"jyu", "", NULL},
	{"jye", "", NULL},
	{"jyo", "", NULL},

	{"j", "", "j"},

	{"ta", "", NULL},
	{"ti", "", NULL},
	{"tu", "", NULL},
	{"te", "", NULL},
	{"to", "", NULL},
	{"t.", "t", NULL},  /* ǿǤ alt-cannadic ñؤб */

	{"tya", "", NULL},
	{"tyi", "", NULL},
	{"tyu", "", NULL},
	{"tye", "", NULL},
	{"tyo", "", NULL},

	{"tha", "Ƥ", NULL},
	{"thi", "Ƥ", NULL},
	{"thu", "Ƥ", NULL},
	{"the", "Ƥ", NULL},
	{"tho", "Ƥ", NULL},

	{"t", "", "tc"},

	{"cha", "", NULL},
	{"chi", "", NULL},
	{"chu", "", NULL},
	{"che", "", NULL},
	{"cho", "", NULL},

	{"tsu", "", NULL},
	{"xtu", "", NULL},
	{"xtsu", "", NULL},

	{"c", "", "c"},

	{"da", "", NULL},
	{"di", "", NULL},
	{"du", "", NULL},
	{"de", "", NULL},
	{"do", "", NULL},

	{"dya", "¤", NULL},
	{"dyi", "¤", NULL},
	{"dyu", "¤", NULL},
	{"dye", "¤", NULL},
	{"dyo", "¤", NULL},

	{"dha", "Ǥ", NULL},
	{"dhi", "Ǥ", NULL},
	{"dhu", "Ǥ", NULL},
	{"dhe", "Ǥ", NULL},
	{"dho", "Ǥ", NULL},

	{"d", "", "d"},

	{"na", "", NULL},
	{"ni", "", NULL},
	{"nu", "", NULL},
	{"ne", "", NULL},
	{"no", "", NULL},

	{"nya", "ˤ", NULL},
	{"nyi", "ˤ", NULL},
	{"nyu", "ˤ", NULL},
	{"nye", "ˤ", NULL},
	{"nyo", "ˤ", NULL},

	{"n", "", NULL},
	{"nn", "", NULL},

	{"ha", "", NULL},
	{"hi", "", NULL},
	{"hu", "", NULL},
	{"he", "", NULL},
	{"ho", "", NULL},

	{"hya", "Ҥ", NULL},
	{"hyi", "Ҥ", NULL},
	{"hyu", "Ҥ", NULL},
	{"hye", "Ҥ", NULL},
	{"hyo", "Ҥ", NULL},

	{"h", "", "h"},

	{"fa", "դ", NULL},
	{"fi", "դ", NULL},
	{"fu", "", NULL},
	{"fe", "դ", NULL},
	{"fo", "դ", NULL},

	{"fya", "դ", NULL},
	{"fyi", "դ", NULL},
	{"fyu", "դ", NULL},
	{"fye", "դ", NULL},
	{"fyo", "դ", NULL},

	{"f", "", "f"},

	{"ba", "", NULL},
	{"bi", "", NULL},
	{"bu", "", NULL},
	{"be", "", NULL},
	{"bo", "", NULL},

	{"bya", "Ӥ", NULL},
	{"byi", "Ӥ", NULL},
	{"byu", "Ӥ", NULL},
	{"bye", "Ӥ", NULL},
	{"byo", "Ӥ", NULL},

	{"b", "", "b" },

	{"pa", "", NULL},
	{"pi", "", NULL},
	{"pu", "", NULL},
	{"pe", "", NULL},
	{"po", "", NULL},

	{"pya", "Ԥ", NULL},
	{"pyi", "Ԥ", NULL},
	{"pyu", "Ԥ", NULL},
	{"pye", "Ԥ", NULL},
	{"pyo", "Ԥ", NULL},

	{"p", "", "p"},

	{"ma", "", NULL},
	{"mi", "", NULL},
	{"mu", "", NULL},
	{"me", "", NULL},
	{"mo", "", NULL},

	{"mya", "ߤ", NULL},
	{"myi", "ߤ", NULL},
	{"myu", "ߤ", NULL},
	{"mye", "ߤ", NULL},
	{"myo", "ߤ", NULL},

	{"m", "", "bp"},
	{"m", "", "m"},

	{"y", "", "y"},
	{"ya", "", NULL},
	{"yu", "", NULL},
	{"yo", "", NULL},

	{"xya", "", NULL},
	{"xyu", "", NULL},
	{"xyo", "", NULL},

	{"r", "", "r"},
	{"ra", "", NULL},
	{"ri", "", NULL},
	{"ru", "", NULL},
	{"re", "", NULL},
	{"ro", "", NULL},

	{"rya", "", NULL},
	{"ryi", "ꤣ", NULL},
	{"ryu", "", NULL},
	{"rye", "ꤧ", NULL},
	{"ryo", "", NULL},

	{"xwa", "", NULL},
	{"wa", "", NULL},
	{"wi", "", NULL},
	{"xwi", "", NULL},
	{"we", "", NULL},
	{"xwe", "", NULL},
	{"wo", "", NULL},

	{"va", "", NULL},
	{"vi", "", NULL},
	{"vu", "", NULL},
	{"ve", "", NULL},
	{"vo", "", NULL},

	{"VA", "", NULL},   /* Debianͳ衩Ρ֥ץѥåư */
	{"VI", "", NULL},
	{"VU", "", NULL},
	{"VE", "", NULL},
	{"VO", "", NULL},



/* ľܥ */
	{"A", "", NULL},
	{"I", "", NULL},
	{"U", "", NULL},
	{"E", "", NULL},
	{"O", "", NULL},

	{"XA", "", NULL},
	{"XI", "", NULL},
	{"XU", "", NULL},
	{"XE", "", NULL},
	{"XO", "", NULL},

	{"KA", "", NULL},
	{"KI", "", NULL},
	{"KU", "", NULL},
	{"KE", "", NULL},
	{"KO", "", NULL},

	{"KYA", "", NULL},
	{"KYI", "", NULL},
	{"KYU", "", NULL},
	{"KYE", "", NULL},
	{"KYO", "", NULL},

	{"K", "", "K"},

	{"GA", "", NULL},
	{"GI", "", NULL},
	{"GU", "", NULL},
	{"GE", "", NULL},
	{"GO", "", NULL},

	{"GYA", "", NULL},
	{"GYI", "", NULL},
	{"GYU", "", NULL},
	{"GYE", "", NULL},
	{"GYO", "", NULL},

	{"G", "", "G"},

	{"SA", "", NULL},
	{"SI", "", NULL},
	{"SU", "", NULL},
	{"SE", "", NULL},
	{"SO", "", NULL},

	{"SYA", "", NULL},
	{"SYI", "", NULL},
	{"SYU", "", NULL},
	{"SYE", "", NULL},
	{"SYO", "", NULL},

	{"SHA", "", NULL},
	{"SHI", "", NULL},
	{"SHU", "", NULL},
	{"SHE", "", NULL},
	{"SHO", "", NULL},

	{"S", "", "S"},

	{"ZA", "", NULL},
	{"ZI", "", NULL},
	{"ZU", "", NULL},
	{"ZE", "", NULL},
	{"ZO", "", NULL},

	{"ZYA", "", NULL},
	{"ZYI", "", NULL},
	{"ZYU", "", NULL},
	{"ZYE", "", NULL},
	{"ZYO", "", NULL},

	{"Z", "", "Z"},

	{"JA", "", NULL},
	{"JI", "", NULL},
	{"JU", "", NULL},
	{"JE", "", NULL},
	{"JO", "", NULL},

	{"JYA", "", NULL},
	{"JYI", "", NULL},
	{"JYU", "", NULL},
	{"JYE", "", NULL},
	{"JYO", "", NULL},

	{"J", "", "J"},

	{"TA", "", NULL},
	{"TI", "", NULL},
	{"TU", "", NULL},
	{"TE", "", NULL},
	{"TO", "", NULL},
	{"T.", "t", NULL},  /* ǿǤ alt-cannadic ñؤб */

	{"TYA", "", NULL},
	{"TYI", "", NULL},
	{"TYU", "", NULL},
	{"TYE", "", NULL},
	{"TYO", "", NULL},

	{"THA", "ƥ", NULL},
	{"THI", "ƥ", NULL},
	{"THU", "ƥ", NULL},
	{"THE", "ƥ", NULL},
	{"THO", "ƥ", NULL},

	{"T", "", "TC"},

	{"CHA", "", NULL},
	{"CHI", "", NULL},
	{"CHU", "", NULL},
	{"CHE", "", NULL},
	{"CHO", "", NULL},

	{"TSU", "", NULL},
	{"XTU", "", NULL},
	{"XTSU", "", NULL},

	{"C", "", "C"},

	{"DA", "", NULL},
	{"DI", "", NULL},
	{"DU", "", NULL},
	{"DE", "", NULL},
	{"DO", "", NULL},

	{"DYA", "¥", NULL},
	{"DYI", "¥", NULL},
	{"DYU", "¥", NULL},
	{"DYE", "¥", NULL},
	{"DYO", "¥", NULL},

	{"DHA", "ǥ", NULL},
	{"DHI", "ǥ", NULL},
	{"DHU", "ǥ", NULL},
	{"DHE", "ǥ", NULL},
	{"DHO", "ǥ", NULL},

	{"D", "", "D"},

	{"NA", "", NULL},
	{"NI", "", NULL},
	{"NU", "", NULL},
	{"NE", "", NULL},
	{"NO", "", NULL},

	{"NYA", "˥", NULL},
	{"NYI", "˥", NULL},
	{"NYU", "˥", NULL},
	{"NYE", "˥", NULL},
	{"NYO", "˥", NULL},

	{"N", "", NULL},
	{"NN", "", NULL},

	{"HA", "", NULL},
	{"HI", "", NULL},
	{"HU", "", NULL},
	{"HE", "", NULL},
	{"HO", "", NULL},

	{"HYA", "ҥ", NULL},
	{"HYI", "ҥ", NULL},
	{"HYU", "ҥ", NULL},
	{"HYE", "ҥ", NULL},
	{"HYO", "ҥ", NULL},

	{"H", "", "H"},

	{"FA", "ե", NULL},
	{"FI", "ե", NULL},
	{"FU", "", NULL},
	{"FE", "ե", NULL},
	{"FO", "ե", NULL},

	{"FYA", "ե", NULL},
	{"FYI", "ե", NULL},
	{"FYU", "ե", NULL},
	{"FYE", "ե", NULL},
	{"FYO", "ե", NULL},

	{"F", "", "F"},

	{"BA", "", NULL},
	{"BI", "", NULL},
	{"BU", "", NULL},
	{"BE", "", NULL},
	{"BO", "", NULL},

	{"BYA", "ӥ", NULL},
	{"BYI", "ӥ", NULL},
	{"BYU", "ӥ", NULL},
	{"BYE", "ӥ", NULL},
	{"BYO", "ӥ", NULL},

	{"B", "", NULL},

	{"PA", "", NULL},
	{"PI", "", NULL},
	{"PU", "", NULL},
	{"PE", "", NULL},
	{"PO", "", NULL},

	{"PYA", "ԥ", NULL},
	{"PYI", "ԥ", NULL},
	{"PYU", "ԥ", NULL},
	{"PYE", "ԥ", NULL},
	{"PYO", "ԥ", NULL},

	{"P", "", "P"},

	{"MA", "", NULL},
	{"MI", "", NULL},
	{"MU", "", NULL},
	{"ME", "", NULL},
	{"MO", "", NULL},

	{"MYA", "ߥ", NULL},
	{"MYI", "ߥ", NULL},
	{"MYU", "ߥ", NULL},
	{"MYE", "ߥ", NULL},
	{"MYO", "ߥ", NULL},

	{"M", "", "BP"},

	{"Y", "", "Y"},
	{"YA", "", NULL},
	{"YU", "", NULL},
	{"YO", "", NULL},

	{"XYA", "", NULL},
	{"XYU", "", NULL},
	{"XYO", "", NULL},

	{"R", "", "R"},
	{"RA", "", NULL},
	{"RI", "", NULL},
	{"RU", "", NULL},
	{"RE", "", NULL},
	{"RO", "", NULL},

	{"RYA", "", NULL},
	{"RYI", "ꥣ", NULL},
	{"RYU", "", NULL},
	{"RYE", "ꥧ", NULL},
	{"RYO", "", NULL},

	{"XWA", "", NULL},
	{"WA", "", NULL},
	{"WI", "", NULL},
	{"XWI", "", NULL},
	{"WE", "", NULL},
	{"XWE", "", NULL},
	{"WO", "", NULL},

/*	{"VA", "", NULL}, */
/*	{"VI", "", NULL}, */
/*	{"VU", "", NULL}, */
/*	{"VE", "", NULL}, */
/*	{"VO", "", NULL}, */



/* ʤˤʸڤ */
/*	{"A", "", NULL}, */
/*	{"I", "", NULL}, */
/*	{"U", "", NULL}, */
/*	{"E", "", NULL}, */
/*	{"O", "", NULL}, */

	{"Xa", "", NULL},
	{"Xi", "", NULL},
	{"Xu", "", NULL},
	{"Xe", "", NULL},
	{"Xo", "", NULL},

	{"Ka", "", NULL},
	{"Ki", "", NULL},
	{"Ku", "", NULL},
	{"Ke", "", NULL},
	{"Ko", "", NULL},

	{"Kya", "", NULL},
	{"Kyi", "", NULL},
	{"Kyu", "", NULL},
	{"Kye", "", NULL},
	{"Kyo", "", NULL},

	{"K", "", "k"},

	{"Ga", "", NULL},
	{"Gi", "", NULL},
	{"Gu", "", NULL},
	{"Ge", "", NULL},
	{"Go", "", NULL},

	{"Gya", "", NULL},
	{"Gyi", "", NULL},
	{"Gyu", "", NULL},
	{"Gye", "", NULL},
	{"Gyo", "", NULL},

	{"G", "", "g"},

	{"Sa", "", NULL},
	{"Si", "", NULL},
	{"Su", "", NULL},
	{"Se", "", NULL},
	{"So", "", NULL},

	{"Sya", "", NULL},
	{"Syi", "", NULL},
	{"Syu", "", NULL},
	{"Sye", "", NULL},
	{"Syo", "", NULL},

	{"Sha", "", NULL},
	{"Shi", "", NULL},
	{"Shu", "", NULL},
	{"She", "", NULL},
	{"Sho", "", NULL},

	{"S", "", "s"},

	{"Za", "", NULL},
	{"Zi", "", NULL},
	{"Zu", "", NULL},
	{"Ze", "", NULL},
	{"Zo", "", NULL},

	{"Zya", "", NULL},
	{"Zyi", "", NULL},
	{"Zyu", "", NULL},
	{"Zye", "", NULL},
	{"Zyo", "", NULL},

	{"Z", "", "z"},

	{"Ja", "", NULL},
	{"Ji", "", NULL},
	{"Ju", "", NULL},
	{"Je", "", NULL},
	{"Jo", "", NULL},

	{"Jya", "", NULL},
	{"Jyi", "", NULL},
	{"Jyu", "", NULL},
	{"Jye", "", NULL},
	{"Jyo", "", NULL},

	{"J", "", "j"},

	{"Ta", "", NULL},
	{"Ti", "", NULL},
	{"Tu", "", NULL},
	{"Te", "", NULL},
	{"To", "", NULL},

	{"Tya", "", NULL},
	{"Tyi", "", NULL},
	{"Tyu", "", NULL},
	{"Tye", "", NULL},
	{"Tyo", "", NULL},

	{"Tha", "Ƥ", NULL},
	{"Thi", "Ƥ", NULL},
	{"Thu", "Ƥ", NULL},
	{"The", "Ƥ", NULL},
	{"Tho", "Ƥ", NULL},

	{"T", "", "tc"},

	{"Cha", "", NULL},
	{"Chi", "", NULL},
	{"Chu", "", NULL},
	{"Che", "", NULL},
	{"Cho", "", NULL},

	{"Tsu", "", NULL},
	{"Xtu", "", NULL},
	{"Xtsu", "", NULL},

	{"C", "", "c"},

	{"Da", "", NULL},
	{"Di", "", NULL},
	{"Du", "", NULL},
	{"De", "", NULL},
	{"Do", "", NULL},

	{"Dya", "¤", NULL},
	{"Dyi", "¤", NULL},
	{"Dyu", "¤", NULL},
	{"Dye", "¤", NULL},
	{"Dyo", "¤", NULL},

	{"Dha", "Ǥ", NULL},
	{"Dhi", "Ǥ", NULL},
	{"Dhu", "Ǥ", NULL},
	{"Dhe", "Ǥ", NULL},
	{"Dho", "Ǥ", NULL},

	{"D", "", "d"},

	{"Na", "", NULL},
	{"Ni", "", NULL},
	{"Nu", "", NULL},
	{"Ne", "", NULL},
	{"No", "", NULL},

	{"Nya", "ˤ", NULL},
	{"Nyi", "ˤ", NULL},
	{"Nyu", "ˤ", NULL},
	{"Nye", "ˤ", NULL},
	{"Nyo", "ˤ", NULL},

/*	{"N", "", NULL}, */
	{"Nn", "", NULL},

	{"Ha", "", NULL},
	{"Hi", "", NULL},
	{"Hu", "", NULL},
	{"He", "", NULL},
	{"Ho", "", NULL},

	{"Hya", "Ҥ", NULL},
	{"Hyi", "Ҥ", NULL},
	{"Hyu", "Ҥ", NULL},
	{"Hye", "Ҥ", NULL},
	{"Hyo", "Ҥ", NULL},

	{"H", "", "h"},

	{"Fa", "դ", NULL},
	{"Fi", "դ", NULL},
	{"Fu", "", NULL},
	{"Fe", "դ", NULL},
	{"Fo", "դ", NULL},

	{"Fya", "դ", NULL},
	{"Fyi", "դ", NULL},
	{"Fyu", "դ", NULL},
	{"Fye", "դ", NULL},
	{"Fyo", "դ", NULL},

	{"F", "", "f"},

	{"Ba", "", NULL},
	{"Bi", "", NULL},
	{"Bu", "", NULL},
	{"Be", "", NULL},
	{"Bo", "", NULL},

	{"Bya", "Ӥ", NULL},
	{"Byi", "Ӥ", NULL},
	{"Byu", "Ӥ", NULL},
	{"Bye", "Ӥ", NULL},
	{"Byo", "Ӥ", NULL},

/*	{"B", "", NULL}, */

	{"Pa", "", NULL},
	{"Pi", "", NULL},
	{"Pu", "", NULL},
	{"Pe", "", NULL},
	{"Po", "", NULL},

	{"Pya", "Ԥ", NULL},
	{"Pyi", "Ԥ", NULL},
	{"Pyu", "Ԥ", NULL},
	{"Pye", "Ԥ", NULL},
	{"Pyo", "Ԥ", NULL},

	{"P", "", "p"},

	{"Ma", "", NULL},
	{"Mi", "", NULL},
	{"Mu", "", NULL},
	{"Me", "", NULL},
	{"Mo", "", NULL},

	{"Mya", "ߤ", NULL},
	{"Myi", "ߤ", NULL},
	{"Myu", "ߤ", NULL},
	{"Mye", "ߤ", NULL},
	{"Myo", "ߤ", NULL},

	{"M", "", "bp"},

	{"Y", "", "y"},
	{"Ya", "", NULL},
	{"Yu", "", NULL},
	{"Yo", "", NULL},

	{"Xya", "", NULL},
	{"Xyu", "", NULL},
	{"Xyo", "", NULL},

	{"R", "", "r"},
	{"Ra", "", NULL},
	{"Ri", "", NULL},
	{"Ru", "", NULL},
	{"Re", "", NULL},
	{"Ro", "", NULL},

	{"Rya", "", NULL},
	{"Ryi", "ꤣ", NULL},
	{"Ryu", "", NULL},
	{"Rye", "ꤧ", NULL},
	{"Ryo", "", NULL},

	{"Xwa", "", NULL},
	{"Wa", "", NULL},
	{"Wi", "", NULL},
	{"Xwi", "", NULL},
	{"We", "", NULL},
	{"Xwe", "", NULL},
	{"Wo", "", NULL},

	{"Va", "", NULL},
	{"Vi", "", NULL},
	{"Vu", "", NULL},
	{"Ve", "", NULL},
	{"Vo", "", NULL},



	{NULL, NULL, NULL}
};

static const struct rk_rule rk_rule_katakana[] =
{
	SKK_LIKE_KIGO_MAP,

	{"a", "", NULL},
	{"i", "", NULL},
	{"u", "", NULL},
	{"e", "", NULL},
	{"o", "", NULL},

	{"xa", "", NULL},
	{"xi", "", NULL},
	{"xu", "", NULL},
	{"xe", "", NULL},
	{"xo", "", NULL},
	
	{"ka", "", NULL},
	{"ki", "", NULL},
	{"ku", "", NULL},
	{"ke", "", NULL},
	{"ko", "", NULL},

	{"kya", "", NULL},
	{"kyi", "", NULL},
	{"kyu", "", NULL},
	{"kye", "", NULL},
	{"kyo", "", NULL},

	{"k", "", "k"},

	{"ga", "", NULL},
	{"gi", "", NULL},
	{"gu", "", NULL},
	{"ge", "", NULL},
	{"go", "", NULL},

	{"gya", "", NULL},
	{"gyi", "", NULL},
	{"gyu", "", NULL},
	{"gye", "", NULL},
	{"gyo", "", NULL},

	{"g", "", "g"},

	{"sa", "", NULL},
	{"si", "", NULL},
	{"su", "", NULL},
	{"se", "", NULL},
	{"so", "", NULL},

	{"sya", "", NULL},
	{"syi", "", NULL},
	{"syu", "", NULL},
	{"sye", "", NULL},
	{"syo", "", NULL},

	{"sha", "", NULL},
	{"shi", "", NULL},
	{"shu", "", NULL},
	{"she", "", NULL},
	{"sho", "", NULL},

	{"s", "", "s"},

	{"za", "", NULL},
	{"zi", "", NULL},
	{"zu", "", NULL},
	{"ze", "", NULL},
	{"zo", "", NULL},

	{"zya", "", NULL},
	{"zyi", "", NULL},
	{"zyu", "", NULL},
	{"zye", "", NULL},
	{"zyo", "", NULL},

	{"z", "", "z"},

	{"ja", "", NULL},
	{"ji", "", NULL},
	{"ju", "", NULL},
	{"je", "", NULL},
	{"jo", "", NULL},

	{"jya", "", NULL},
	{"jyi", "", NULL},
	{"jyu", "", NULL},
	{"jye", "", NULL},
	{"jyo", "", NULL},

	{"j", "", "j"},

	{"ta", "", NULL},
	{"ti", "", NULL},
	{"tu", "", NULL},
	{"te", "", NULL},
	{"to", "", NULL},
	{"t.", "t", NULL},  /* ǿǤ alt-cannadic ñؤб */

	{"tya", "", NULL},
	{"tyi", "", NULL},
	{"tyu", "", NULL},
	{"tye", "", NULL},
	{"tyo", "", NULL},

	{"tha", "ƥ", NULL},
	{"thi", "ƥ", NULL},
	{"thu", "ƥ", NULL},
	{"the", "ƥ", NULL},
	{"tho", "ƥ", NULL},

	{"t", "", "tc"},

	{"cha", "", NULL},
	{"chi", "", NULL},
	{"chu", "", NULL},
	{"che", "", NULL},
	{"cho", "", NULL},

	{"tsu", "", NULL},
	{"xtu", "", NULL},
	{"xtsu", "", NULL},

	{"c", "", "c"},

	{"da", "", NULL},
	{"di", "", NULL},
	{"du", "", NULL},
	{"de", "", NULL},
	{"do", "", NULL},

	{"dya", "¥", NULL},
	{"dyi", "¥", NULL},
	{"dyu", "¥", NULL},
	{"dye", "¥", NULL},
	{"dyo", "¥", NULL},

	{"dha", "ǥ", NULL},
	{"dhi", "ǥ", NULL},
	{"dhu", "ǥ", NULL},
	{"dhe", "ǥ", NULL},
	{"dho", "ǥ", NULL},

	{"d", "", "d"},

	{"na", "", NULL},
	{"ni", "", NULL},
	{"nu", "", NULL},
	{"ne", "", NULL},
	{"no", "", NULL},

	{"nya", "˥", NULL},
	{"nyi", "˥", NULL},
	{"nyu", "˥", NULL},
	{"nye", "˥", NULL},
	{"nyo", "˥", NULL},

	{"n", "", NULL},
	{"nn", "", NULL},

	{"ha", "", NULL},
	{"hi", "", NULL},
	{"hu", "", NULL},
	{"he", "", NULL},
	{"ho", "", NULL},

	{"hya", "ҥ", NULL},
	{"hyi", "ҥ", NULL},
	{"hyu", "ҥ", NULL},
	{"hye", "ҥ", NULL},
	{"hyo", "ҥ", NULL},

	{"h", "", "h"},

	{"fa", "ե", NULL},
	{"fi", "ե", NULL},
	{"fu", "", NULL},
	{"fe", "ե", NULL},
	{"fo", "ե", NULL},

	{"fya", "ե", NULL},
	{"fyi", "ե", NULL},
	{"fyu", "ե", NULL},
	{"fye", "ե", NULL},
	{"fyo", "ե", NULL},

	{"f", "", "f"},

	{"ba", "", NULL},
	{"bi", "", NULL},
	{"bu", "", NULL},
	{"be", "", NULL},
	{"bo", "", NULL},

	{"bya", "ӥ", NULL},
	{"byi", "ӥ", NULL},
	{"byu", "ӥ", NULL},
	{"bye", "ӥ", NULL},
	{"byo", "ӥ", NULL},

	{"b", "", NULL},

	{"pa", "", NULL},
	{"pi", "", NULL},
	{"pu", "", NULL},
	{"pe", "", NULL},
	{"po", "", NULL},

	{"pya", "ԥ", NULL},
	{"pyi", "ԥ", NULL},
	{"pyu", "ԥ", NULL},
	{"pye", "ԥ", NULL},
	{"pyo", "ԥ", NULL},

	{"p", "", "p"},

	{"ma", "", NULL},
	{"mi", "", NULL},
	{"mu", "", NULL},
	{"me", "", NULL},
	{"mo", "", NULL},

	{"mya", "ߥ", NULL},
	{"myi", "ߥ", NULL},
	{"myu", "ߥ", NULL},
	{"mye", "ߥ", NULL},
	{"myo", "ߥ", NULL},

	{"m", "", "bp"},

	{"y", "", "y"},
	{"ya", "", NULL},
	{"yu", "", NULL},
	{"yo", "", NULL},

	{"xya", "", NULL},
	{"xyu", "", NULL},
	{"xyo", "", NULL},

	{"r", "", "r"},
	{"ra", "", NULL},
	{"ri", "", NULL},
	{"ru", "", NULL},
	{"re", "", NULL},
	{"ro", "", NULL},

	{"rya", "", NULL},
	{"ryi", "ꥣ", NULL},
	{"ryu", "", NULL},
	{"rye", "ꥧ", NULL},
	{"ryo", "", NULL},

	{"xwa", "", NULL},
	{"wa", "", NULL},
	{"wi", "", NULL},
	{"xwi", "", NULL},
	{"we", "", NULL},
	{"xwe", "", NULL},
	{"wo", "", NULL},

	{"va", "", NULL},
	{"vi", "", NULL},
	{"vu", "", NULL},
	{"ve", "", NULL},
	{"vo", "", NULL},

	{NULL, NULL, NULL}
};

static const struct rk_rule rk_rule_hankaku_kana[] =
{
	SKK_LIKE_KIGO_MAP,

	{"a", "", NULL},
	{"i", "", NULL},
	{"u", "", NULL},
	{"e", "", NULL},
	{"o", "", NULL},

	{"xa", "", NULL},
	{"xi", "", NULL},
	{"xu", "", NULL},
	{"xe", "", NULL},
	{"xo", "", NULL},
	
	{"ka", "", NULL},
	{"ki", "", NULL},
	{"ku", "", NULL},
	{"ke", "", NULL},
	{"ko", "", NULL},

	{"kya", "", NULL},
	{"kyi", "k", NULL},
	{"kyu", "", NULL},
	{"kye", "", NULL},
	{"kyo", "", NULL},

	{"k", "", "k"},

	{"ga", "", NULL},
	{"gi", "", NULL},
	{"gu", "", NULL},
	{"ge", "", NULL},
	{"go", "", NULL},

	{"gya", "ގ", NULL},
	{"gyi", "ގ", NULL},
	{"gyu", "ގ", NULL},
	{"gye", "ގ", NULL},
	{"gyo", "ގ", NULL},

	{"g", "", "g"},

	{"sa", "", NULL},
	{"si", "", NULL},
	{"su", "", NULL},
	{"se", "", NULL},
	{"so", "", NULL},

	{"sya", "", NULL},
	{"syi", "", NULL},
	{"syu", "", NULL},
	{"sye", "", NULL},
	{"syo", "", NULL},

	{"sha", "", NULL},
	{"shi", "", NULL},
	{"shu", "", NULL},
	{"she", "", NULL},
	{"sho", "", NULL},

	{"s", "", "s"},

	{"za", "", NULL},
	{"zi", "", NULL},
	{"zu", "", NULL},
	{"ze", "", NULL},
	{"zo", "", NULL},

	{"zya", "ގ", NULL},
	{"zyi", "ގ", NULL},
	{"zyu", "ގ", NULL},
	{"zye", "ގ", NULL},
	{"zyo", "ގ", NULL},

	{"z", "", "z"},

	{"ja", "ގ", NULL},
	{"ji", "", NULL},
	{"ju", "ގ", NULL},
	{"je", "ގ", NULL},
	{"jo", "ގ", NULL},

	{"jya", "ގ", NULL},
	{"jyi", "ގ", NULL},
	{"jyu", "ގ", NULL},
	{"jye", "ގ", NULL},
	{"jyo", "ގ", NULL},

	{"j", "", "j"},

	{"ta", "", NULL},
	{"ti", "", NULL},
	{"tu", "", NULL},
	{"te", "", NULL},
	{"to", "", NULL},
	{"t.", "t", NULL},  /* ǿǤ alt-cannadic ñؤб */

	{"tya", "", NULL},
	{"tyi", "", NULL},
	{"tyu", "", NULL},
	{"tye", "", NULL},
	{"tyo", "", NULL},

	{"tha", "Î", NULL},
	{"thi", "Î", NULL},
	{"thu", "", NULL},
	{"the", "", NULL},
	{"tho", "", NULL},

	{"t", "", "tc"},

	{"cha", "", NULL},
	{"chi", "", NULL},
	{"chu", "", NULL},
	{"che", "", NULL},
	{"cho", "", NULL},

	{"tsu", "", NULL},
	{"xtu", "", NULL},
	{"xtsu", "", NULL},

	{"c", "", "c"},

	{"da", "", NULL},
	{"di", "", NULL},
	{"du", "", NULL},
	{"de", "Î", NULL},
	{"do", "Ď", NULL},

	{"dya", "ގ", NULL},
	{"dyi", "ގ", NULL},
	{"dyu", "ގ", NULL},
	{"dye", "ގ", NULL},
	{"dyo", "ގ", NULL},

	{"dha", "Îގ", NULL},
	{"dhi", "Îގ", NULL},
	{"dhu", "Îގ", NULL},
	{"dhe", "Îގ", NULL},
	{"dho", "Îގ", NULL},

	{"d", "", "d"},

	{"na", "", NULL},
	{"ni", "", NULL},
	{"nu", "", NULL},
	{"ne", "", NULL},
	{"no", "", NULL},

	{"nya", "Ǝ", NULL},
	{"nyi", "Ǝ", NULL},
	{"nyu", "Ǝ", NULL},
	{"nye", "Ǝ", NULL},
	{"nyo", "Ǝ", NULL},

	{"n", "", NULL},
	{"nn", "", NULL},

	{"ha", "", NULL},
	{"hi", "", NULL},
	{"hu", "", NULL},
	{"he", "", NULL},
	{"ho", "", NULL},

	{"hya", "ˎ", NULL},
	{"hyi", "ˎ", NULL},
	{"hyu", "ˎ", NULL},
	{"hye", "ˎ", NULL},
	{"hyo", "ˎ", NULL},

	{"h", "", "h"},

	{"fa", "̎", NULL},
	{"fi", "̎", NULL},
	{"fu", "", NULL},
	{"fe", "̎", NULL},
	{"fo", "̎", NULL},

	{"fya", "̎", NULL},
	{"fyi", "̎", NULL},
	{"fyu", "̎", NULL},
	{"fye", "̎", NULL},
	{"fyo", "̎", NULL},

	{"f", "", "f"},

	{"ba", "ʎ", NULL},
	{"bi", "ˎ", NULL},
	{"bu", "̎", NULL},
	{"be", "͎", NULL},
	{"bo", "Ύ", NULL},

	{"bya", "ˎގ", NULL},
	{"byi", "ˎގ", NULL},
	{"byu", "ˎގ", NULL},
	{"bye", "ˎގ", NULL},
	{"byo", "ˎގ", NULL},

	{"b", "", NULL},

	{"pa", "ʎ", NULL},
	{"pi", "ˎ", NULL},
	{"pu", "̎", NULL},
	{"pe", "͎", NULL},
	{"po", "Ύ", NULL},

	{"pya", "ˎߎ", NULL},
	{"pyi", "ˎߎ", NULL},
	{"pyu", "ˎߎ", NULL},
	{"pye", "ˎߎ", NULL},
	{"pyo", "ˎߎ", NULL},

	{"p", "", "p"},

	{"ma", "", NULL},
	{"mi", "", NULL},
	{"mu", "", NULL},
	{"me", "", NULL},
	{"mo", "", NULL},

	{"mya", "Ў", NULL},
	{"myi", "Ў", NULL},
	{"myu", "Ў", NULL},
	{"mye", "Ў", NULL},
	{"myo", "Ў", NULL},

	{"m", "", "bp"},

	{"y", "", "y"},
	{"ya", "", NULL},
	{"yu", "", NULL},
	{"yo", "", NULL},

	{"xya", "", NULL},
	{"xyu", "", NULL},
	{"xyo", "", NULL},

	{"r", "", "r"},
	{"ra", "", NULL},
	{"ri", "", NULL},
	{"ru", "", NULL},
	{"re", "", NULL},
	{"ro", "", NULL},

	{"rya", "؎", NULL},
	{"ryi", "؎", NULL},
	{"ryu", "؎", NULL},
	{"rye", "؎", NULL},
	{"ryo", "؎", NULL},

	{"xwa", "", NULL},
	{"wa", "", NULL},
	{"wi", "", NULL},
	{"xwi", "", NULL},
	{"we", "", NULL},
	{"xwe", "", NULL},
	{"wo", "", NULL},

	{"va", "ގ", NULL},
	{"vi", "ގ", NULL},
	{"vu", "", NULL},
	{"ve", "ގ", NULL},
	{"vo", "ގ", NULL},

	{NULL, NULL, NULL}
};

/*
 * Local variables:
 *  c-indent-level: 8
 *  c-basic-offset: 8
 * End:
 */

/* [ End of File ] */
/* vim:ts=8 sw=2 nomodified:
 */
