/*
 * ʸ⤷ñİʾ奻åȤˤmetawordȤư
 * ǤϳƼmetaword
 *
 * init_metaword_tab() metawordΤξ
 * anthy_make_metaword_all() contextmetaword
 * anthy_print_metaword() ꤵ줿metawordɽ
 *
 * Funded by IPA̤Ƨեȥ¤ 2001 10/29
 * Copyright (C) 2000-2006 TABATA Yusuke
 * Copyright (C) 2004-2006 YOSHIDA Yuichi
 * Copyright (C) 2000-2003 UGAWA Tomoharu
 */
#if 0		/* Patched by G-HAL */
#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#include <anthy/record.h>
#include <anthy/splitter.h>
#include <anthy/xchar.h>
#include <anthy/xstr.h>
#include <anthy/segment.h>
#include <anthy/segclass.h>
#include "wordborder.h"
#else
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
/* #if defined(HAVE_MALLOC_H)
# include <malloc.h>
#endif */
#if defined(HAVE_STDIO_H)
# include <stdio.h>
#endif
#if defined(HAVE_MATH_H)
# include <math.h>
#endif
#if defined(HAVE_STRING_H)
# include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
# include <strings.h>
#endif

#include "anthy/settings.h"		/* Patched by G-HAL, Fri,17 Oct,2008 */
#include "anthy/record.h"
#include "anthy/splitter.h"
#include "anthy/xchar.h"
#include "anthy/xstr.h"
#include "anthy/segment.h"
#include "anthy/segclass.h"
#include "src-worddic/dic_ent.h"	/* Patched by G-HAL, Thu,26 Nov,2009 - Fri,27 Nov,2009 */
#include "src-splitter/lattice.h"	/* Patched by G-HAL, Mon,27 Apr,2009 */
#include "src-splitter/metaword.h"	/* Patched by G-HAL, Fri,01 May,2009 */
#include "wordborder.h"
#endif

/* Ƽmeta_wordɤΤ褦˽뤫 */
#if 0	/* Patched by G-HAL, Wed,05 Nov,2008, Sat,24 Jan,2009, Sun,08 Feb,2009, Wed,18 Feb,2009, Tue,24 Feb,2009 */
struct metaword_type_tab_ anthy_metaword_type_tab[] = {
  {MW_DUMMY,"dummy",MW_STATUS_NONE,MW_CHECK_SINGLE},
  {MW_SINGLE,"single",MW_STATUS_NONE,MW_CHECK_SINGLE},
  {MW_WRAP,"wrap",MW_STATUS_WRAPPED,MW_CHECK_WRAP},
  {MW_COMPOUND_HEAD,"compound_head",MW_STATUS_NONE,MW_CHECK_COMPOUND},
  {MW_COMPOUND,"compound",MW_STATUS_NONE,MW_CHECK_NONE},
  {MW_COMPOUND_LEAF,"compound_leaf",MW_STATUS_COMPOUND,MW_CHECK_NONE},
  {MW_COMPOUND_PART,"compound_part",MW_STATUS_COMPOUND_PART,MW_CHECK_SINGLE},
  {MW_V_RENYOU_A,"v_renyou_a",MW_STATUS_COMBINED,MW_CHECK_BORDER},
  {MW_V_RENYOU_NOUN,"v_renyou_noun",MW_STATUS_COMBINED,MW_CHECK_BORDER},
  {MW_NUMBER,"number",MW_STATUS_COMBINED,MW_CHECK_NUMBER},
  {MW_OCHAIRE,"ochaire",MW_STATUS_OCHAIRE,MW_CHECK_OCHAIRE},
  /**/
  {MW_END,"end",MW_STATUS_NONE,MW_CHECK_NONE}
};
#else
struct metaword_type_tab_ anthy_metaword_type_tab[] = {
  [MW_DUMMY]                         = {MW_DUMMY,"dummy",MW_STATUS_NONE,MW_CHECK_SINGLE},
  [MW_SINGLE]                        = {MW_SINGLE,"single",MW_STATUS_NONE,MW_CHECK_SINGLE},
  [MW_WRAP]                          = {MW_WRAP,"wrap",MW_STATUS_WRAPPED,MW_CHECK_WRAP},
  [MW_COMPOUND_HEAD]                 = {MW_COMPOUND_HEAD,"compound_head",MW_STATUS_NONE,MW_CHECK_COMPOUND},
  [MW_COMPOUND]                      = {MW_COMPOUND,"compound",MW_STATUS_NONE,MW_CHECK_COMPOUND},	/* MW_CHECK_NONE}, */ /* Patched by G-HAL, Wed,22 Jul,2009 */
  [MW_COMPOUND_LEAF]                 = {MW_COMPOUND_LEAF,"compound_leaf",MW_STATUS_COMPOUND,MW_CHECK_SINGLE},	/* MW_CHECK_NONE}, */ /* Patched by G-HAL, Wed,22 Jul,2009 */
  [MW_COMPOUND_PART]                 = {MW_COMPOUND_PART,"compound_part",MW_STATUS_COMPOUND_PART,MW_CHECK_SINGLE},
  [MW_V_RENYOU_A]                    = {MW_V_RENYOU_A,"v_renyou_a",MW_STATUS_COMBINED,MW_CHECK_BORDER},
  [MW_V_RENYOU_NOUN]                 = {MW_V_RENYOU_NOUN,"v_renyou_noun",MW_STATUS_COMBINED,MW_CHECK_BORDER},
  [MW_NUMBER]                        = {MW_NUMBER,"number",MW_STATUS_COMBINED,MW_CHECK_NUMBER},
  [MW_OCHAIRE]                       = {MW_OCHAIRE,"ochaire",MW_STATUS_OCHAIRE,MW_CHECK_OCHAIRE},
  [MW_OCHAIREwithoutDEP]             = {MW_OCHAIREwithoutDEP,"ochaire",MW_STATUS_OCHAIREwithoutDEP,MW_CHECK_OCHAIRE},
  [MW_OCHAIREwithoutINDEP]           = {MW_OCHAIREwithoutINDEP,"ochaire",MW_STATUS_OCHAIREwithoutINDEP,MW_CHECK_OCHAIRE},
  [MW_OCHAIREwithoutINDEPwithoutDEP] = {MW_OCHAIREwithoutINDEPwithoutDEP,"ochaire",MW_STATUS_OCHAIREwithoutINDEPwithoutDEP,MW_CHECK_OCHAIRE},
  [MW_CANDHISTORY]                   = {MW_CANDHISTORY,"candhistory",MW_STATUS_CANDHISTORY,MW_CHECK_SINGLE},
  /**/
  [MW_END]                           = {MW_END,"end",MW_STATUS_NONE,MW_CHECK_NONE}
};
#endif

static void
combine_metaword(struct splitter_context *sc, struct meta_word *mw);

#if 0	/* Patched by G-HAL, Tue,11 Aug,2009 */
/* ƥmetawordɲä */
void
anthy_commit_meta_word(struct splitter_context *sc,
		       struct meta_word *mw)
{
  struct word_split_info_cache *info = sc->word_split_info;
  /* ƱĥΡɤΥꥹ */
  mw->next = info->cnode[mw->from].mw;
  info->cnode[mw->from].mw = mw;
  /**/
  if (anthy_splitter_debug_flags() & SPLITTER_DEBUG_MW) {
    anthy_print_metaword(sc, mw);
  }
}
#else
/** ѴƥȤˡѴ metaword ɲä
 *@param[in,out]	sc		Ѵƥ
 *@param[in]		mw		ϿѴ
 */
void anthy_commit_meta_word( struct splitter_context* sc, struct meta_word* mw )
{
  struct word_split_info_cache* const info = sc->word_split_info;
  struct char_node* const cnode = (mw->from <= sc->char_count) ? &(info->cnode[mw->from]) : NULL;
  struct meta_word* mw1;

  if (NULL == cnode) {
    return;
  }

  for (mw1 = cnode->mw; mw1; mw1 = mw1->next) {
    if (mw == mw1) {
      return;
    }
  }
  mw->next = cnode->mw;
  cnode->mw = mw;

  if (anthy_splitter_debug_flags() & SPLITTER_DEBUG_MW) {
    anthy_print_metaword( sc, mw );
  }
  return;
}
#endif

static void
print_metaword_features(int features)
{
  if (features & MW_FEATURE_SV) {
    printf(":sv");
  }
  if (features & MW_FEATURE_WEAK_CONN) {
    printf(":weak");
  }
  if (features & MW_FEATURE_SUFFIX) {
    printf(":suffix");
  }
  if (features & MW_FEATURE_NUM) {
    printf(":num");
  }
  if (features & MW_FEATURE_CORE1) {
    printf(":c1");
  }
  if (features & MW_FEATURE_HIGH_FREQ) {
    printf(":hf");
  }
}

static void
anthy_do_print_metaword(struct splitter_context *sc,
			struct meta_word *mw,
			int indent)
{
  int i;
  for (i = 0; i < indent; i++) {
    printf(" ");
  }
  printf("*meta word type=%s(%d-%d):score=%d:seg_class=%s",
	 anthy_metaword_type_tab[mw->type].name,
	 mw->from, mw->len, mw->score,
	 anthy_seg_class_name(mw->seg_class));
  print_metaword_features(mw->mw_features);
  printf(":can_use=%d*\n", mw->can_use);
  if (mw->wl) {
    anthy_print_word_list(sc, mw->wl);
  }
  if (mw->cand_hint.str) {
    printf("(");
    anthy_putxstr(&mw->cand_hint);
    printf(")\n");
  }
  if (mw->mw1) {
    anthy_do_print_metaword(sc, mw->mw1, indent + 1);
  }
  if (mw->mw2) {
    anthy_do_print_metaword(sc, mw->mw2, indent + 1);
  }
}

void
anthy_print_metaword(struct splitter_context *sc,
		     struct meta_word *mw)
{
  anthy_do_print_metaword(sc, mw, 0);
}

#if 0	/* Patched by G-HAL, Fri,01 May,2009 */
static struct meta_word *
alloc_metaword(struct splitter_context *sc)
#else
struct meta_word* const alloc_metaword( struct splitter_context* const sc )
#endif
{
  struct meta_word *mw;
  mw = (struct meta_word*) anthy_smalloc(sc->word_split_info->MwAllocator);
  mw->type = MW_SINGLE;
  mw->score = 0;
  mw->struct_score = 0;
  mw->extra_score = -1;		/* Patched by G-HAL, Wed,04 Feb,2009 */
  mw->dep_word_hash = 0;
  mw->core_wt = anthy_wt_none;
  mw->mw_features = 0;
  mw->dep_class = DEP_NONE;
  mw->wl = NULL;
  mw->mw1_left  = NULL;		/* Patched by G-HAL, Fri,14 Nov,2008 */
  mw->mw1_right = NULL;		/* Patched by G-HAL, Thu,27 Aug,2009 */
  mw->mw1 = NULL;
  mw->mw2 = NULL;
  mw->cand_hint.str = NULL;
  mw->cand_hint.len = 0;
  mw->seg_class = SEG_HEAD;
  mw->can_use = ok;
  mw->ochaire_opposite     = 0;	/* Patched by G-HAL, Mon,17 Nov,2008 */
  mw->ochaire_phrase_score = 0;	/* Patched by G-HAL, Mon,17 Nov,2008 */
  mw->ochaire_total_len    = 0;	/* Patched by G-HAL, Mon,17 Nov,2008 */
  mw->cand_hint_freq          = 0;	/* Patched by G-HAL, Thu,20 Nov,2008 */
  mw->cand_hint_learned_freq  = 0;	/* Patched by G-HAL, Sat,21 Feb,2009 */
  mw->cand_hint_depth_of_dep  = 0;	/* Patched by G-HAL, Thu,20 Nov,2008 */
  mw->cand_hint_length_of_dep = 0;	/* Patched by G-HAL, Sat,24 Jan,2009 */
  return mw;
}


/*
 * wlƬʬʬʸȤƼФ
 */
static void
get_surrounding_text(struct splitter_context* sc,
		     struct word_list* wl,
		     xstr* xs_pre, xstr* xs_post)
{
    int post_len = wl->part[PART_DEPWORD].len + wl->part[PART_POSTFIX].len;
    int pre_len = wl->part[PART_PREFIX].len;

    xs_pre->str = sc->ce[wl->from].c;
    xs_pre->len = pre_len;
    xs_post->str = sc->ce[wl->from + wl->len - post_len].c;
    xs_post->len = post_len;
}

static int
count_vu(xstr *xs) {
  int i, r = 0;
  for (i = 0; i < xs->len; i++) {
    if (xs->str[i] == KK_VU) {
      r++;
    }
  }
  return r;
}

/*
 * ʣǤwln֤ʬФmwˤ
 */
static struct meta_word*
make_compound_nth_metaword(struct splitter_context* sc,
			   compound_ent_t ce, int nth,
			   struct word_list* wl,
			   enum metaword_type type)
{
  int i;
  int len = 0;
  int from = wl->from;
  int seg_num = anthy_compound_get_nr_segments(ce);
  struct meta_word* mw;
  xstr xs_pre, xs_core, xs_post;

  get_surrounding_text(sc, wl, &xs_pre, &xs_post);

  for (i = 0; i <= nth; ++i) {
    xstr part;
    from += len;
    len = anthy_compound_get_nth_segment_len(ce, i);
    part.str = sc->ce[from].c;
    part.len = len;
    len -= count_vu(&part);
    if (i == 0) {
      len += xs_pre.len;
    }
    if (i == seg_num - 1) {
      len += xs_post.len;
    }
  }

  mw = alloc_metaword(sc);
  mw->from = from;
  mw->len = len;
  mw->type = type;
  mw->score = 1000;
 #if 1		/* Patched by G-HAL, Thu,20 Nov,2008, Sat,24 Jan,2009, Mon,04 May,2009 */
  {
    i = 0;
    mw->cand_hint_freq = 0;
    if (0 < wl->part[PART_PREFIX].len) {
      mw->cand_hint_freq += wl->part[PART_PREFIX].freq;
      i++;
    }
    if (0 < wl->part[PART_CORE].len) {
      mw->cand_hint_freq += wl->part[PART_CORE].freq;
      i++;
    }
    if (0 < wl->part[PART_POSTFIX].len) {
      mw->cand_hint_freq += wl->part[PART_POSTFIX].freq;
      i++;
    }
    if (0 < i) {
      mw->cand_hint_freq /= i;
    }
    if (mw->cand_hint_freq < 1) {
      mw->cand_hint_freq = 1;
    }
  }
  if ((from + len) == (wl->from + wl->len)) {
    if (wl->part[PART_DEPWORD].freq < 0) {
      mw->cand_hint_depth_of_dep  = - wl->part[PART_DEPWORD].freq;
      mw->cand_hint_length_of_dep = wl->part[PART_DEPWORD].len;
    }
  }
 #endif
  mw->seg_class = wl->seg_class;

  anthy_compound_get_nth_segment_xstr(ce, nth, &xs_core);
  if (nth == 0) {
    anthy_xstrcat(&mw->cand_hint, &xs_pre);
  }
  anthy_xstrcat(&mw->cand_hint, &xs_core);
  if (nth == seg_num - 1) {
    anthy_xstrcat(&mw->cand_hint, &xs_post);
  }
  return mw;
}


/*
 * metawordºݤ˷礹
 */
static struct meta_word *
anthy_do_cons_metaword(struct splitter_context *sc,
		       enum metaword_type type,
		       struct meta_word *mw, struct meta_word *mw2)
{
  struct meta_word *n;

  n = alloc_metaword(sc);
  n->from = mw->from;
  n->len = mw->len + (mw2 ? mw2->len : 0);

  if (mw2) {
    n->score = (int)( sqrt( (double)mw->score ) * sqrt( (double)mw2->score ) );
  } else {
    n->score = mw->score;
  }
  n->type = type;
  n->mw1 = mw;
 #if 1		/* Patched by G-HAL, Thu,20 Nov,2008, Sat,24 Jan,2009, Sat,21 Feb,2009 */
  n->cand_hint_freq          = mw->cand_hint_freq;
  n->cand_hint_learned_freq  = mw->cand_hint_learned_freq;
  n->cand_hint_depth_of_dep  = mw->cand_hint_depth_of_dep;
  n->cand_hint_length_of_dep = mw->cand_hint_length_of_dep;
 #endif
  n->mw2 = mw2;
  if (mw2) {
   #if 1		/* Patched by G-HAL, Thu,20 Nov,2008, Sat,24 Jan,2009, Sat,21 Feb,2009 */
    n->cand_hint_freq          = mw2->cand_hint_freq;
    n->cand_hint_learned_freq  = mw2->cand_hint_learned_freq;
    n->cand_hint_depth_of_dep  = mw2->cand_hint_depth_of_dep;
    n->cand_hint_length_of_dep = mw2->cand_hint_length_of_dep;
   #endif
    n->seg_class = mw2->seg_class;
    n->nr_parts = mw->nr_parts + mw2->nr_parts;
    n->dep_word_hash = mw2->dep_word_hash;
  } else {
    n->seg_class = mw->seg_class;
    n->nr_parts = mw->nr_parts;
    n->dep_word_hash = mw->dep_word_hash;
  }
  anthy_commit_meta_word(sc, n);
  return n;
}

/*
 * ʣѤmeta_word롣
 */
static void
make_compound_metaword(struct splitter_context* sc, struct word_list* wl)
{
  int i, j;
  seq_ent_t se = wl->part[PART_CORE].seq;
  int ent_num = anthy_get_nr_dic_ents(se, NULL);

  for (i = 0; i < ent_num; ++i) {
    compound_ent_t ce;
    int seg_num;
    struct meta_word *mw = NULL;
    struct meta_word *mw2 = NULL;
    struct meta_word* mw_right = NULL;	/* Patched by G-HAL, Thu,23 Jul,2009 */
    if (!anthy_get_nth_dic_ent_is_compound(se, i)) {
      continue;
    }
    ce = anthy_get_nth_compound_ent(se, i);
    seg_num = anthy_compound_get_nr_segments(ce);

    for (j = seg_num - 1; j >= 0; --j) {
      enum metaword_type type;
      mw = make_compound_nth_metaword(sc, ce, j, wl, MW_COMPOUND_LEAF);
      mw->ochaire_phrase_score = seg_num * 100;	/* Patched by G-HAL, Thu,23 Jul,2009 */
      anthy_commit_meta_word(sc, mw);
     #if 1	/* Patched by G-HAL, Thu,23 Jul,2009, Thu,27 Aug,2009 */
      if (mw_right) {
	mw_right->mw1_left = mw;
	mw->mw1_right      = mw_right;
      }
      mw_right = mw;
     #endif

      type = j == 0 ? MW_COMPOUND_HEAD : MW_COMPOUND;
      mw2 = anthy_do_cons_metaword(sc, type, mw, mw2);
    }
  }
}

/*
 * ʣθġʸ礷meta_word롣
 */
static void
make_compound_part_metaword(struct splitter_context* sc, struct word_list* wl)
{
  int i, j, k;
  seq_ent_t se = wl->part[PART_CORE].seq;
  int ent_num = anthy_get_nr_dic_ents(se, NULL);

  for (i = 0; i < ent_num; ++i) {
    compound_ent_t ce;
    int seg_num;
    struct meta_word *mw = NULL;
    struct meta_word *mw2 = NULL;

    if (!anthy_get_nth_dic_ent_is_compound(se, i)) {
      continue;
    }

    ce = anthy_get_nth_compound_ent(se, i);
    seg_num = anthy_compound_get_nr_segments(ce);

    /*  */
    for (j = seg_num - 1; j >= 0; --j) {
      mw = make_compound_nth_metaword(sc, ce, j, wl, MW_COMPOUND_PART);
      for (k = j - 1; k >= 0; --k) {
	mw2 = make_compound_nth_metaword(sc, ce, k, wl, MW_COMPOUND_PART);
	mw2->len += mw->len;
	mw2->score += mw->score;
       #if 1		/* Patched by G-HAL, Thu,20 Nov,2008, Sat,24 Jan,2009, Sat,21 Feb,2009 */
	mw2->cand_hint_freq          = mw->cand_hint_freq;
	mw2->cand_hint_learned_freq  = mw->cand_hint_learned_freq;
	mw2->cand_hint_depth_of_dep  = mw->cand_hint_depth_of_dep;
	mw2->cand_hint_length_of_dep = mw->cand_hint_length_of_dep;
       #endif
	anthy_xstrcat(&mw2->cand_hint, &mw->cand_hint);

	anthy_commit_meta_word(sc, mw2);
	mw = mw2;
      }
    }
  }
}

/*
 * ñʸñ
 */
static void
make_simple_metaword(struct splitter_context *sc, struct word_list* wl)
{
  int i;	/* Patched by G-HAL, Thu,20 Nov,2008 */
  struct meta_word *mw = alloc_metaword(sc);
  mw->wl = wl;
  mw->from = wl->from;
  mw->len = wl->len;
  mw->score = 1000;
 #if 1		/* Patched by G-HAL, Thu,20 Nov,2008, Sat,24 Jan,2009 */
  {
    i = 0;
    mw->cand_hint_freq = 0;
    if (0 < wl->part[PART_PREFIX].len) {
      mw->cand_hint_freq += wl->part[PART_PREFIX].freq;
      i++;
    }
    if (0 < wl->part[PART_CORE].len) {
      mw->cand_hint_freq += wl->part[PART_CORE].freq;
      i++;
    }
    if (0 < wl->part[PART_POSTFIX].len) {
      mw->cand_hint_freq += wl->part[PART_POSTFIX].freq;
      i++;
    }
    if (0 < i) {
      mw->cand_hint_freq /= i;
    }
    if (mw->cand_hint_freq < 1) {
      mw->cand_hint_freq = 1;
    }
  }
  if (wl->part[PART_DEPWORD].freq < 0) {
    mw->cand_hint_depth_of_dep  = - wl->part[PART_DEPWORD].freq;
    mw->cand_hint_length_of_dep = wl->part[PART_DEPWORD].len;
  }
 #endif
  mw->type = MW_SINGLE;
  mw->dep_class = wl->part[PART_DEPWORD].dc;
  mw->seg_class = wl->seg_class;
  if (wl->part[PART_CORE].len) {
    mw->core_wt = wl->part[PART_CORE].wt;
  }
  mw->nr_parts = NR_PARTS;
  mw->dep_word_hash = wl->dep_word_hash;
  mw->mw_features = wl->mw_features;
  anthy_commit_meta_word(sc, mw);
}

/*
 * wordlistĤʤ롢metaword
 */
static void
make_metaword_from_word_list(struct splitter_context *sc)
{
  int i;
  for (i = 0; i < sc->char_count; i++) {
    struct word_list *wl;
    for (wl = sc->word_split_info->cnode[i].wl;
	 wl; wl = wl->next) {
      if (wl->is_compound) {
       #if 0	/* Patched by G-HAL, Tue,10 Nov,2009 */
	make_compound_part_metaword(sc, wl);
	make_compound_metaword(sc, wl);
       #else
	if (!anthy_settings.anthy_mode.proccorpus) {
	  make_compound_part_metaword(sc, wl);
	  make_compound_metaword(sc, wl);
	}
       #endif
      } else {
	make_simple_metaword(sc, wl);
      }
    }
  }
}

/*
 * metawordꥹ˷礹
 */
static struct meta_word *
list_metaword(struct splitter_context *sc,
	      enum metaword_type type,
	      struct meta_word *mw, struct meta_word *mw2)
{
  struct meta_word *wrapped_mw = anthy_do_cons_metaword(sc, type, mw2, NULL);
  struct meta_word *n = anthy_do_cons_metaword(sc, type, mw, wrapped_mw);

  n->mw_features = mw->mw_features | mw2->mw_features;

  return n;
}

/*
 * ưϢѷ + ƻ첽 ֡䤹פʤ
 */
static void
try_combine_v_renyou_a(struct splitter_context *sc,
		       struct meta_word *mw, struct meta_word *mw2)
{
  wtype_t w2;
  if (!mw->wl || !mw2->wl) return;

  w2 = mw2->wl->part[PART_CORE].wt;

  if (mw->wl->head_pos == POS_V &&
      mw->wl->tail_ct == CT_RENYOU &&
      anthy_wtype_get_pos(w2) == POS_D2KY) {
    /* ƻǤϤΤǼΥå */
    if (anthy_get_seq_ent_wtype_freq(mw2->wl->part[PART_CORE].seq,
				     anthy_wtype_a_tail_of_v_renyou)) {
      list_metaword(sc, MW_V_RENYOU_A, mw, mw2);
    }
  }
}

/*
 * ưϢѷ + ̾첽(#D2T35)  (Τ)פʤ
 */
static void
try_combine_v_renyou_noun(struct splitter_context *sc,
			  struct meta_word *mw, struct meta_word *mw2)
{
  wtype_t w2;
  if (!mw->wl || !mw2->wl) return;

  w2 = mw2->wl->part[PART_CORE].wt;
  if (mw->wl->head_pos == POS_V &&
      mw->wl->tail_ct == CT_RENYOU &&
      anthy_wtype_get_pos(w2) == POS_NOUN &&
      anthy_wtype_get_scos(w2) == SCOS_T40) {
    list_metaword(sc, MW_V_RENYOU_NOUN, mw, mw2);
  }
}

/*
 * 礹
 */
static void
try_combine_number(struct splitter_context *sc,
		 struct meta_word *mw1, struct meta_word *mw2)
{
  struct word_list *wl1 = mw1->wl;
  struct word_list *wl2 = mw2->wl;
  struct meta_word *combined_mw;
  int recursive = wl2 ? 0 : 1; /* combinedmw礹1 */

  /* mwϿ */

  if (anthy_wtype_get_pos(wl1->part[PART_CORE].wt) != POS_NUMBER) return;
  if (recursive) {
    /* mwϿ礷mw */
    if (mw2->type != MW_NUMBER) return;
    wl2 = mw2->mw1->wl;
  } else {
    /* mwϿ */
    if (anthy_wtype_get_pos(wl2->part[PART_CORE].wt) != POS_NUMBER) return;
  }
  /* mwθʸդƤʤ */
  if (wl1->part[PART_POSTFIX].len == 0 &&
      wl1->part[PART_DEPWORD].len == 0) {
    int scos1 = anthy_wtype_get_scos(wl1->part[PART_CORE].wt);
    int scos2 = anthy_wtype_get_scos(wl2->part[PART_CORE].wt);

    /* #NNоݳ */
    if (scos2 == SCOS_NONE) return;
    /*
       mwμˤäơˤĤȤǤ뱦mwμबѤ
       㤨аθˤ岯ĤȤǤʤ
       彽θˤϡ碌ưʤɤĤȤǤ
     */
    switch (scos1) {
    case SCOS_N1:
      if (scos2 == SCOS_N1) return; /* ˰夬ĤƤϤʤ */
    case SCOS_N10:
      if (scos2 == SCOS_N10) return; /* ˽彽ĤƤϤʤ */
    case SCOS_N100:
      if (scos2 == SCOS_N100) return; /* ɴɴĤƤϤʤ */
    case SCOS_N1000:
      if (scos2 == SCOS_N1000) return; /* 餬ĤƤϤʤ */
    case SCOS_N10000:
      /* 岯Ĥʤɤϡ
	 ĤǤˤĤȤǤ */
      break;
    default:
      return;
    }

    if (recursive) {
      combined_mw = anthy_do_cons_metaword(sc, MW_NUMBER, mw1, mw2);
    } else {
      /* Ʒ礹ϸnullĤlistˤ */
      combined_mw = list_metaword(sc, MW_NUMBER, mw1, mw2);
    }
    combine_metaword(sc, combined_mw);
  }
}

/* ٤metawordȷǤ뤫å */
static void
try_combine_metaword(struct splitter_context *sc,
		     struct meta_word *mw1, struct meta_word *mw2)
{
  if (!mw1->wl) return;

  /* metawordηԤˤϡ³
     metawordƬʤȤɬ */
  if (mw2->wl && mw2->wl->part[PART_PREFIX].len > 0) {
    return;
  }

  try_combine_v_renyou_a(sc, mw1, mw2);
  try_combine_v_renyou_noun(sc, mw1, mw2);
  try_combine_number(sc, mw1, mw2);
}

static void
combine_metaword(struct splitter_context *sc, struct meta_word *mw)
{
  struct word_split_info_cache *info = sc->word_split_info;
  int i;

  if (mw->mw_features & MW_FEATURE_DEP_ONLY) {
    /* °ʸȤϷ礷ʤ */
    return;
  }

  for (i = mw->from - 1; i >= 0; i--) {
    struct meta_word *mw_left;
    for (mw_left = info->cnode[i].mw; mw_left; mw_left = mw_left->next) {
      if (mw_left->from + mw_left->len == mw->from) {
	/* Ǥ뤫å */
	try_combine_metaword(sc, mw_left, mw);
      }
    }
  }
}

static void
combine_metaword_all(struct splitter_context *sc)
{
  int i;

  struct word_split_info_cache *info = sc->word_split_info;
  /* metawordκüˤ롼 */
  for (i = sc->char_count - 1; i >= 0; i--){
    struct meta_word *mw;
    /* metawordΥ롼 */
    for (mw = info->cnode[i].mw;
	 mw; mw = mw->next) {
      combine_metaword(sc, mw);
    }
  }
}

static void
make_dummy_metaword(struct splitter_context *sc, int from,
		    int len, int orig_len)
{
  int score = 0;
  struct meta_word *mw, *n;

  for (mw = sc->word_split_info->cnode[from].mw; mw; mw = mw->next) {
   if (mw->len != orig_len) continue;
    if (mw->score > score) {
      score = mw->score;
    }
  }

  n = alloc_metaword(sc);
  n->type = MW_DUMMY;
  n->from = from;
  n->len = len;
  n->score = 3 * score * len / orig_len;
 #if 1		/* Patched by G-HAL, Thu,20 Nov,2008, Sat,24 Jan,2009, Sat,21 Feb,2009 */
  n->cand_hint_freq          = 0;
  n->cand_hint_learned_freq  = 0;
  n->cand_hint_depth_of_dep  = 0;
  n->cand_hint_length_of_dep = 0;
 #endif
  if (mw) {
    mw->nr_parts = 0;
  }
  anthy_commit_meta_word(sc, n);
}

/*
 * ʸ򿭤Ф餽ФƤ
 */
static void
make_expanded_metaword_all(struct splitter_context *sc)
{
  int i, j;
 #if 1	/* Patched by G-HAL, Tue,10 Nov,2009 */
  if (anthy_settings.anthy_mode.anonymous) {
    return;
  }
 #endif
  if (anthy_select_section(EXPANDPAIR, 0) == -1) {	/* Patched by G-HAL, Fri,17 Oct,2008 */
    return ;
  }
  for (i = 0; i < sc->char_count; i++) {
    for (j = 1; j < sc->char_count - i; j++) {
      /* ƤʬʸФ */
      xstr xs;
      xs.len = j;
      xs.str = sc->ce[i].c;
      if (anthy_select_row(&xs, 0) == 0) {
	/* ʬʸϲ˳оݤȤʤä */
        int k;
        int nr = anthy_get_nr_values();
        for (k = 0; k < nr; k++) {
          xstr *exs;
          exs = anthy_get_nth_xstr(k);
          if (exs && exs->len <= sc->char_count - i) {
            xstr txs;
            txs.str = sc->ce[i].c;
            txs.len = exs->len;
            if (!anthy_xstrcmp(&txs, exs)) {
              make_dummy_metaword(sc, i, txs.len, j);
            }
          }
        }
      }
    }
  }
}

#if 0	/* Patched by G-HAL, Fri,01 May,2009 */
/* ؽmetaword */
static void
make_ochaire_metaword(struct splitter_context *sc,
		      int from, int len)
{
  struct meta_word *mw;
  int count;
  int s;
  int j;
  int seg_len;
  int mw_len = 0;
  xstr* xs;

  (void)len;

  /* ʸ */
  count = anthy_get_nth_value(0);
  /* ֱʸΤʸιפ׻ */
  for (s = 0, j = 0; j < count - 1; j++) {
    s += anthy_get_nth_value(j * 2 + 1);
  }
  /* ֱʸmetaword */
  xs = anthy_get_nth_xstr((count - 1) * 2 + 2);
  if (!xs) {
    return ;
  }
  seg_len = anthy_get_nth_value((count - 1) * 2 + 1);
  mw = alloc_metaword(sc);
  mw->type = MW_OCHAIRE;
  mw->from = from + s;
  mw->len = seg_len;
  mw->score = OCHAIRE_SCORE;
  mw->cand_hint.str = (xchar*) malloc(sizeof(xchar)*xs->len);
  anthy_xstrcpy(&mw->cand_hint, xs);
  anthy_commit_meta_word(sc, mw);
  mw_len += seg_len;
  /* ʳʸmetaword */
  for (j-- ; j >= 0; j--) {
    struct meta_word *n;
    seg_len = anthy_get_nth_value(j * 2 + 1);
    s -= seg_len;
    xs = anthy_get_nth_xstr(j * 2 + 2);
    if (!xs) {
      return ;
    }
    n = alloc_metaword(sc);
    n->type = MW_OCHAIRE;
    /* metawordĤʤ */
    n->mw1 = mw;
    n->from = from + s;
    n->len = seg_len;
    n->score = OCHAIRE_SCORE;
    n->cand_hint.str = (xchar*) malloc(sizeof(xchar)*xs->len);
    anthy_xstrcpy(&n->cand_hint, xs);
    anthy_commit_meta_word(sc, n);
    mw = n;
    mw_len += seg_len;
  }
}

/*
 * ʣʸȤ򤫤鸡
 */
static void
make_ochaire_metaword_all(struct splitter_context *sc)
{
  int i;
  if (anthy_select_section(OCHAIRE, 0) == -1) {	/* Patched by G-HAL, Fri,17 Oct,2008 */
    return ;
  }

  for (i = 0; i < sc->char_count; i++) {
    xstr xs;
    xs.len = sc->char_count - i;
    xs.str = sc->ce[i].c;
    if (anthy_select_longest_row(&xs) == 0) {
      xstr* key;
      int len;
      /* anthy_mark_row_used();*/	/* Don't learn OCHAIRE in the middle of conversion. Patched by G-HAL, Thu,21 Aug,2008 */
      key = anthy_get_index_xstr();
      len = key->len;

      make_ochaire_metaword(sc, i, len);
      /* 󸫤Ĥä meta_word μʸϤ */
      i += len - 1;
      break;
    }
  }
}
#endif

static void
add_dummy_metaword(struct splitter_context *sc,
		   int from)
{
  struct meta_word *n;
  n = alloc_metaword(sc);
  n->from = from;
  n->len = 1;
  n->type = MW_SINGLE;
  n->score = 1;
 #if 1		/* Patched by G-HAL, Thu,20 Nov,2008, Sat,24 Jan,2009, Sat,21 Feb,2009 */
  n->cand_hint_freq          = 0;
  n->cand_hint_learned_freq  = 0;
  n->cand_hint_depth_of_dep  = 0;
  n->cand_hint_length_of_dep = 0;
 #endif
  n->seg_class = SEG_BUNSETSU;
  anthy_commit_meta_word(sc, n);
}

/* ꤷmetawordwrapjʸĹmeta_word */
#if 0	/* Patched by G-HAL, Wed,18 Feb,2009, Tue,19 May,2009 */
static void
expand_meta_word(struct splitter_context *sc,
		 struct meta_word *mw, int from, int len,
		 int destroy_seg_class, int j)
#else
static void expand_meta_word( struct splitter_context* const sc,
		 struct meta_word* const mw,
		 int from, int len,
		 int destroy_seg_class,
		 int adjust_score,
		 enum dep_class dc,
		 int j )
#endif
{
  struct meta_word *n;
  n = alloc_metaword(sc);
  n->from = from;
  n->len = len + j;
  if (mw) {
    n->type = MW_WRAP;
    n->mw1 = mw;
    n->score = mw->score;
   #if 1		/* Patched by G-HAL, Thu,20 Nov,2008, Sat,24 Jan,2009, Sat,21 Feb,2009 */
    n->score += adjust_score;
    if (n->score < 1) {
      n->score = 1;
    }
    n->cand_hint_freq          = mw->cand_hint_freq;
    n->cand_hint_learned_freq  = mw->cand_hint_learned_freq;
    n->cand_hint_depth_of_dep  = mw->cand_hint_depth_of_dep + j;
    n->cand_hint_length_of_dep = mw->cand_hint_length_of_dep + j;
   #endif
    n->nr_parts = mw->nr_parts;
    if (destroy_seg_class) {
      n->seg_class = SEG_BUNSETSU;
      n->score /= 10;
    } else {
      n->seg_class = mw->seg_class;
    }
  } else {
    n->type = MW_SINGLE;
    n->score = 1;
   #if 1		/* Patched by G-HAL, Thu,20 Nov,2008, Sat,24 Jan,2009, Sat,21 Feb,2009 */
    n->cand_hint_freq          = 0;
    n->cand_hint_learned_freq  = 0;
    n->cand_hint_depth_of_dep  = j;
    n->cand_hint_length_of_dep = j;
   #endif
    n->seg_class = SEG_BUNSETSU;
  }
  n->dep_class = dc;	/* Patched by G-HAL, Tue,19 May,2009 */
  anthy_commit_meta_word(sc, n);
}

/*
 * metawordθλ¿ʸ򤯤äĤmetaword
 */
static void
make_metaword_with_depchar(struct splitter_context *sc,
			   struct meta_word *mw)
{
  int j;
  int destroy_seg_class = 0;
 #if 0	/* Patched by G-HAL, Wed,18 Feb,2009, Tue,19 May,2009 */
 #else
  int adjust_score = 0;
  enum dep_class dc = DEP_NONE;
 #endif
  int from = mw ? mw->from : 0;
  int len = mw ? mw->len : 0;

  /* metawordľʸμĴ٤ */
  int type;
  if (sc->char_count <= from + len) {
    return ;
  }
 #if 0		/* Patched by G-HAL, Wed,19 Nov,2008, Wed,18 Nov,2009, Tue,19 May,2009 */
  type = anthy_get_xchar_type(*sc->ce[from + len].c);
  if (!(type & XCT_SYMBOL) &&
      !(type & XCT_PART)) {
    return;
  }
 #else
  type = anthy_get_xchar_type(*sc->ce[from + len].c);
  if (anthy_settings.anthy_mode.depgraph.with_xct_symbol && (type & XCT_SYMBOL)) {
    /* °첽⡼ */
  } else if (anthy_settings.anthy_mode.depgraph.with_xct_part && (type & XCT_PART)) {
    /* ֤äפ°첽⡼ */
    const size_t	cur_ptr = from + len;
   # if !defined(USE_ICONV)	/* Patched by G-HAL, Sun,14 Jun,2009 */
    const enum XCT_t	last_type50 = (0 < cur_ptr) ? anthy_get_xchar_type50(sc->ce[cur_ptr -1].c[0]) : XCT_NONE;
    const enum XCT_t	type50      = anthy_get_xchar_type50(*sc->ce[from + len].c);
    if (((XCT_KANA_MASK & last_type50) / XCT_KANA_LSB) & ((XCT_PART_MASK & type50) / XCT_PART_LSB)) {
      dc = DEP_PART;
    } else {
      dc = DEP_PART_GUESS;
    }
   # else
    const enum XCT_t	last_type = (0 < cur_ptr) ? anthy_get_xchar_type(sc->ce[cur_ptr -1].c[0]) : XCT_NONE;
    if (((XCT_KANA_MASK & last_type) / XCT_KANA_LSB) & ((XCT_PART_MASK & type) / XCT_PART_LSB)) {
      dc = DEP_PART;
    } else {
      dc = DEP_PART_GUESS;
    }
   # endif
    adjust_score = anthy_settings.anthy_mode.depgraph.score.decrease_biasscore_xct_part;
  } else {
    /* ʳʸ°ˤʤ
     * ġĶ⤳Ȧʤɡ
     */
    return;
  }
 #endif
  if (type & XCT_PUNCTUATION) {
    /* ʤ̤ʸˤ */
    return ;
  }

  /* ƱʸǤʤФäĤΤ򤦤 */
  for (j = 0; from + len + j < sc->char_count; j++) {
    int p = from + len + j;
    if ((anthy_get_xchar_type(*sc->ce[p].c) != type)) {
      break;
    }
    if (!(p + 1 < sc->char_count) ||
	*sc->ce[p].c != *sc->ce[p + 1].c) {
      destroy_seg_class = 1;
    }
  }

  /* Υ롼פȴjˤΩǤʤʸοäƤ */

 #if 0	/* Patched by G-HAL, Wed,18 Feb,2009, Tue,19 May,2009 */
  /* ΩǤʤʸΤǡդmetaword */
  if (j > 0) {
    expand_meta_word(sc, mw, from, len, destroy_seg_class, j);
  }
 #else
  /* ΩǤʤʸΤǡդmetaword */
  for (;0 < j; --j) {
    expand_meta_word( sc, mw, from, len, destroy_seg_class, adjust_score, dc, j );
  }
  return;
 #endif
}

static void
make_metaword_with_depchar_all(struct splitter_context *sc)
{
  int i;
  struct word_split_info_cache *info = sc->word_split_info;

  /* metawordФ */
  for (i = 0; i < sc->char_count; i++) {
    struct meta_word *mw;
    for (mw = info->cnode[i].mw;
	 mw; mw = mw->next) {
      make_metaword_with_depchar(sc, mw);
    }
    if (!info->cnode[i].mw) {
      /**/
      add_dummy_metaword(sc, i);
    }
  }
  /* ʸκüϤޤ */
  make_metaword_with_depchar(sc, NULL);
}

static int
is_single(xstr* xs)
{
  int i;
  int xct;
  for (i = xs->len - 1; i >= 1; --i) {
    xct = anthy_get_xchar_type(xs->str[i]);
    if (!(xct & XCT_PART)) {
      return 0;
    }
  }
  return 1;
}

static void
bias_to_single_char_metaword(struct splitter_context *sc)
{
  int i;

  for (i = sc->char_count - 1; i >= 0; --i) {
    struct meta_word *mw;
    xstr xs;
    int xct;

    struct char_node *cnode = &sc->word_split_info->cnode[i];

    /* åξϰʸʸǤ */
    xct = anthy_get_xchar_type(*sc->ce[i].c);
    if (xct & (XCT_OPEN|XCT_CLOSE)) {
      continue;
    }

    xs.str = sc->ce[i].c;
    for (mw = cnode->mw; mw; mw = mw->next) {
      /* °Τߤʸϸʤ */
      if (mw->mw_features & MW_FEATURE_DEP_ONLY) {
	continue;
      }
      /* ʸ(+ľˤĤʤʸη֤)Υ򲼤 */
      xs.len = mw->len;
      if (is_single(&xs)) {
	mw->score /= 10;
      }
    }
  }
}

#if 0	/* Patched by G-HAL, Wed,24 Jun,2009 */
void
anthy_mark_border_by_metaword(struct splitter_context* sc,
			      struct meta_word* mw)
{
  struct word_split_info_cache* info = sc->word_split_info;
  if (!mw) return;

  switch (mw->type) {
  case MW_DUMMY:
    /* BREAK THROUGH */
  case MW_SINGLE:
    /* BREAK THROUGH */
  case MW_COMPOUND_PART:
    info->seg_border[mw->from] = 1;
    break;
  case MW_COMPOUND_LEAF:
    info->seg_border[mw->from] = 1;
    info->best_mw[mw->from] = mw;
    mw->can_use = ok;
    break;
  case MW_COMPOUND_HEAD:
    /* BREAK THROUGH */
  case MW_COMPOUND:
    /* BREAK THROUGH */
  case MW_NUMBER:
    info->best_mw[mw->mw1->from] = mw->mw1;
    anthy_mark_border_by_metaword(sc, mw->mw1);
    anthy_mark_border_by_metaword(sc, mw->mw2);
    break;
  case MW_V_RENYOU_A:
    /* BREAK THROUGH */
  case MW_V_RENYOU_NOUN:
    info->seg_border[mw->from] = 1;
    break;
  case MW_WRAP:
    anthy_mark_border_by_metaword(sc, mw->mw1);
    break;
  case MW_OCHAIRE:
    info->seg_border[mw->from] = 1;
    anthy_mark_border_by_metaword(sc, mw->mw1);
    break;
  default:
    break;
  }
}
#else
/** ڤäʸФ best_mw ꤹ
 *@param[in,out]	wsic			
 *@param[in]		mw			ϸ mw
 *
 *		Tue,04 Nov,2008
 *		Thu,20 Nov,2008
 *		Sat,24 Jan,2009
 *		Sun,08 Feb,2009
 */
static void
set_bestmw_by_metaword( struct word_split_info_cache* const wsic,
		       struct meta_word* const mw )
{
  if (!wsic || !mw) {
    return;
  }

  switch (mw->type) {
  case MW_DUMMY:
  case MW_SINGLE:
  case MW_COMPOUND_PART:
    break;
  case MW_COMPOUND_LEAF:
    wsic->best_mw[mw->from] = mw;
    mw->can_use = ok;
    break;
  case MW_COMPOUND_HEAD:
  case MW_COMPOUND:
  case MW_NUMBER:
    if (mw->mw1) {
      wsic->best_mw[mw->mw1->from] = mw->mw1;
    }
    set_bestmw_by_metaword( wsic, mw->mw1 );
    set_bestmw_by_metaword( wsic, mw->mw2 );
    break;
  case MW_V_RENYOU_A:
  case MW_V_RENYOU_NOUN:
    break;
  case MW_WRAP:
    set_bestmw_by_metaword( wsic, mw->mw1 );
    break;
  case MW_OCHAIRE:
  case MW_OCHAIREwithoutDEP:
  case MW_OCHAIREwithoutINDEP:
  case MW_OCHAIREwithoutINDEPwithoutDEP:
    set_bestmw_by_metaword( wsic, mw->mw1 );
    break;
  case MW_CANDHISTORY:
    break;
  case MW_END:
  default:
    break;
  }
  return;
}

void anthy_mark_border_by_metaword( struct splitter_context* sc, struct meta_word* mw )
{
  struct word_split_info_cache* const wsic = sc->word_split_info;
  if (!mw) return;
  wsic->seg_border[mw->from] = 1;
  set_bestmw_by_metaword( wsic, mw );
  return;
}
#endif

void
anthy_make_metaword_all(struct splitter_context *sc)
{
  /* ޤword_listĤmetaword */
  make_metaword_from_word_list(sc);

  /* metaword礹 */
  combine_metaword_all(sc);

  /* 礵줿ʸ */
  make_expanded_metaword_all(sc);

  /* Ĺʤɤε桢¾ε */
  make_metaword_with_depchar_all(sc);

  /* 򤤤 */
 #if 0	/* Patched by G-HAL, Tue,04 Nov,2008, Sun,26 Apr,2009 ,Fri,01 May,2009, Tue,10 Nov,2009 */
  make_ochaire_metaword_all(sc);
 #else
  if (!anthy_settings.anthy_mode.anonymous) {
    anthy_make_metaword_by_candhistory( sc );
    anthy_make_metaword_by_ochaire( sc );
    anthy_make_metaword_by_keepaliveochaire( sc );
    anthy_make_metaword_by_keepalivecompound( sc );
  }
 #endif

  /* ʸʸϸ */
  bias_to_single_char_metaword(sc);
}

/**
 * ꤵ줿ΰ򥫥Сmetaword
 *
 *@comment
 *	Ѵ
 */
int
anthy_get_nr_metaword(struct splitter_context *sc,
		     int from, int len)
{
  struct meta_word *mw;
  int n;

  for (n = 0, mw = sc->word_split_info->cnode[from].mw;
       mw; mw = mw->next) {
   #if 0		/* Patched by G-HAL, Sun,17 May,2009 */
    if (mw->len == len && mw->can_use == ok) {
   #else
    if ((mw->len == len) && (ng < mw->can_use)) {
   #endif
      n++;
    }
  }
  return n;
}

/**
 * ꤵ줿ΰ򥫥Сmetaword֤
 *
 *@comment
 *	Ѵ
 */
struct meta_word *
anthy_get_nth_metaword(struct splitter_context *sc,
		      int from, int len, int nth)
{
  struct meta_word *mw;
  int n;
  for (n = 0, mw = sc->word_split_info->cnode[from].mw;
       mw; mw = mw->next) {
   #if 0		/* Patched by G-HAL, Sun,17 May,2009 */
    if (mw->len == len && mw->can_use == ok) {
   #else
    if ((mw->len == len) && (ng < mw->can_use)) {
   #endif
      if (n == nth) {
	return mw;
      }
      n++;
    }
  }
  return NULL;
}
/* vim:ts=8 sw=2 nomodified:
 */
