/*
 * Comments in this program are written in Japanese,
 * because this program is a Japanese input method.
 * (many Japanese gramatical terms will appear.)
 *
 * Kana-Kanji conversion engine Anthy.
 * ̾Ѵ󥸥Anthy(󥷡)
 *
 * Funded by IPA̤Ƨեȥ¤ 2001 9/22
 * Funded by IPA̤Ƨեȥ¤ 2005
 * Copyright (C) 2000-2007 TABATA Yusuke, UGAWA Tomoharu
 * Copyright (C) 2004-2006 YOSHIDA Yuichi
 * Copyright (C) 2000-2007 KMC(Kyoto University Micro Computer Club)
 * Copyright (C) 2001-2002 TAKAI Kosuke, Nobuoka Takahiro
 *
 */
/*
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
/*
 * AnthyѴǽϥ饤֥ȤƹƤꡢ
 * եˤϥ饤֥󶡤ؿ(API)ҤƤޤ
 *
 * 饤֥󶡤ؿϲΤ褦ʤΤޤ
 * (1)饤֥Τνλ
 * (2)ѴƥȤκ
 * (3)ѴƥȤФʸꡢʸĹѹμ
 *
 * 󥿡ե˴ؤƤ doc/LIB򻲾ȤƤ
 * AnthyΥɤ򤷤褦Ȥ
 * doc/GLOSSARY Ѹİ뤳Ȥ򴫤ޤ
 */
#if 0		/* Patched by G-HAL */
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include <anthy/dic.h>
#include <anthy/splitter.h>
#include <anthy/conf.h>
#include <anthy/ordering.h>
#include <anthy/logger.h>
#include <anthy/record.h>
#include <anthy/anthy.h>
#include <anthy/record.h>
#include <anthy/xchar.h> /* for KK_VU */
#include "main.h"
#include "config.h"
#else
#if defined(HAVE_CONFIG_H)
# include "config.h"
# include "revision_header.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif
#if defined(HAVE_STRING_H)
# include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
# include <strings.h>
#endif
#if defined(HAVE_STDIO_H)
# include <stdio.h>
#endif
#if defined(TIME_WITH_SYS_TIME)
# include <sys/time.h>
# include <time.h>
#else
# if defined(HAVE_SYS_TIME_H)
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif
#if defined(HAVE_SYS_STAT_H)
# include <sys/stat.h>		/* Patched by G-HAL, Thu,16 Oct,2008 */
#endif
#if defined(HAVE_ALLOCA_H)
# include <alloca.h>
#elif defined(HAVE_ALLOCA)
#else
# error	"alloca() was not found."
#endif

#include "anthy/settings.h"	/* Patched by G-HAL, Fri,17 Oct,2008 */
#include "anthy/dic.h"
#include "anthy/splitter.h"
#include "anthy/conf.h"
#include "anthy/ordering.h"
#include "anthy/logger.h"
#include "anthy/record.h"
#include "anthy/anthy.h"
#include "anthy/record.h"
#include "anthy/xchar.h" /* for KK_VU */
#include "anthy/xstr.h"		/* Patched by G-HAL, Wed,29 Apr,2009 */
#include "src-worddic/record_adjustment.h"	/* Patched by G-HAL, Tue,14 Jul,2009 */
#include "main.h"
#endif


/** AnthyνλɤΥե饰 */
static int is_init_ok;
/** ƥΥ󥳡ǥ */
static int default_encoding;
/***/
static char *history_file;

/** (API) Τν */
int
anthy_init(void)
{
  char *hfn;
 #if defined(DEBUG) && (0 <= DEBUG)
  anthy_log(1, "TRACE: anthy_init();\n" );
 #endif
  if (is_init_ok) {
    /* 2ٽʤ褦 */
    return 0;
  }

  anthy_init_settings();	/* Patched by G-HAL, Sat,18 Oct,2008 */

  /* ƥ֥ƥ˽ */
  if (anthy_init_dic()) {
    anthy_log(0, "Failed to initialize dictionary.\n");
    return -1;
  }

  if (anthy_init_splitter()) {
    anthy_log(0, "Failed to init splitter.\n");
    return -1;
  }
  anthy_init_contexts();
  anthy_init_personality();
  anthy_infosort_init();
  anthy_relation_init();

  /**/
 #if 0	/* Patched by G-HAL, Mon,25 May,2009 */
  default_encoding = ANTHY_EUC_JP_ENCODING;
 #else
  default_encoding = anthy_settings.anthy_mode.encoding;
 #endif
  is_init_ok = 1;
  history_file = NULL;
  hfn = getenv("ANTHY_HISTORY_FILE");
  if (hfn) {
    history_file = strdup(hfn);
  }

  /**/
  return 0;
}

/** (API) ǡβ */
void
anthy_quit(void)
{
 #if defined(DEBUG) && (0 <= DEBUG)
  anthy_log(1, "TRACE: anthy_quit();\n" );
 #endif
  if (!is_init_ok) {
    return ;
  }
  anthy_quit_contexts();
  anthy_quit_personality();
  anthy_quit_splitter();
  /* ¿Υǡ¤ϤallocatorˤäƲ */
  anthy_quit_dic();

  is_init_ok = 0;
  /**/
  if (history_file) {
    free(history_file);
  }
  history_file = NULL;
}

/** (API) ܤξ */
void
anthy_conf_override(const char *var, const char *val)
{
 #if defined(DEBUG) && (0 <= DEBUG)
  anthy_log(1, "TRACE: anthy_conf_override();\n" );
 #endif
  anthy_do_conf_override(var, val);
}

/** (API) personality */
int
anthy_set_personality(const char *id)
{
 #if defined(DEBUG) && (0 <= DEBUG)
  anthy_log(1, "TRACE: anthy_set_personality();\n" );
 #endif
  return anthy_do_set_personality(id);
}

/** (API) Ѵcontextκ */
anthy_context_t
anthy_create_context(void)
{
 #if defined(DEBUG) && (0 <= DEBUG)
  anthy_log(1, "TRACE: anthy_create_context();\n" );
 #endif
  if (!is_init_ok) {
    return 0;
  }
  anthy_settings.timestamp.currentsession = time(NULL);	/* Patched by G-HAL, Wed,15 Oct,2008 */
  anthy_load_settings();			/* Patched by G-HAL, Sat,29 Nov,2008 */
  return anthy_do_create_context(default_encoding);
}

/** (API) ѴcontextΥꥻå */
void
anthy_reset_context(anthy_context_t ac)
{
 #if defined(DEBUG) && (0 <= DEBUG)
  anthy_log(1, "TRACE: anthy_reset_context();\n" );
 #endif
  anthy_do_reset_context(ac);
}

/** (API) Ѵcontextβ */
void
anthy_release_context(anthy_context_t ac)
{
 #if defined(DEBUG) && (0 <= DEBUG)
  anthy_log(1, "TRACE: anthy_release_context();\n" );
 #endif
  anthy_do_release_context(ac);
}

/**
 * ѴɬפɤȽ
 */
static int
need_reconvert(anthy_context_t ac, xstr *xs)
{
  int i;

  if (ac->reconversion_mode == ANTHY_RECONVERT_ALWAYS) {
    return 1;
  }
  if (ac->reconversion_mode == ANTHY_RECONVERT_DISABLE) {
    return 0;
  }

  for (i = 0; i < xs->len; ++i) {
    xchar xc = xs->str[i];
    int type = anthy_get_xchar_type(xc);

    /* ʸξϵѴ
     * ֥פϥեȥɤʿ̾⡼ɤʸȤäƤΤǡ
     * ѴоݤȤϤʤ
     */
    if (!(type & (XCT_HIRA | XCT_SYMBOL | XCT_NUM |
		  XCT_WIDENUM | XCT_OPEN | XCT_CLOSE |
		  XCT_ASCII)) &&
	xc != KK_VU) {
      return 1;
    }
  }
  return 0;
}


/** (API) Ѵʸ */
int
anthy_set_string(anthy_context_t ac, const char *s)
{
 #if !defined(USE_ICONV)	/* Patched by G-HAL, Sun,14 Jun,2009 - Mon,15 Jun,2009 */
  xstr *xs;
 #else
  size_t len = strlen(s);
  xstr xs;
 #endif
  int retval;

 #if defined(DEBUG) && (0 <= DEBUG)
  anthy_log(1, "TRACE: anthy_set_string();\n" );
 #endif
  if (!ac) {
    return -1;
  }

  /**/
  anthy_do_reset_context(ac);
  anthy_settings.timestamp.currentsession = time(NULL);	/* Patched by G-HAL, Wed,15 Oct,2008 */

  /* 񥻥åγ */
  if (!ac->dic_session) {
    ac->dic_session = anthy_dic_create_session();
    if (!ac->dic_session) {
      return -1;
    }
  }

  anthy_dic_activate_session(ac->dic_session);
  /* Ѵ򳫻Ϥ˸Ŀͼreload */
  anthy_reload_record();

 #if !defined(USE_ICONV)	/* Patched by G-HAL, Sun,14 Jun,2009 - Mon,15 Jun,2009 */
  xs = anthy_cstr_to_xstr(s, ac->encoding);
 #else
  xs.str = (xchar*) alloca( sizeof(xchar) * (len+1) );
  anthy_snputcstr( &xs, len+1, s, ac->encoding );
 #endif
  /**/
 #if 0	/* Patched by G-HAL, Sun,19 Apr,2009 */
  if (!need_reconvert(ac, xs)) {
 #else
 # if !defined(USE_ICONV)	/* Patched by G-HAL, Sun,14 Jun,2009 - Mon,15 Jun,2009 */
  if ((ANTHY_LATTICE_HINTING_NONE != anthy_settings.anthy_mode.lattice.hinting)
      || !need_reconvert(ac, xs)
  ) {
 # else
    if ((ANTHY_LATTICE_HINTING_NONE != anthy_settings.anthy_mode.lattice.hinting)
	|| !need_reconvert(ac, &xs)
    ) {
 # endif
 #endif
    /* ̤Ѵ */
   #if !defined(USE_ICONV)	/* Patched by G-HAL, Sun,14 Jun,2009 - Mon,15 Jun,2009 */
    retval = anthy_do_context_set_str(ac, xs, 0);
   #else
    retval = anthy_do_context_set_str( ac, &xs, 0 );
   #endif
  } else {
    /* 䥫ʤäƤѴƤߤ */
    struct anthy_conv_stat stat;
    struct seg_ent *seg;
    int i;
    xstr* hira_xs;
    /* Ϳ줿ʸѴ򤫤 */
   #if !defined(USE_ICONV)	/* Patched by G-HAL, Sun,14 Jun,2009 - Mon,15 Jun,2009 */
    retval = anthy_do_context_set_str(ac, xs, 1);
   #else
    retval = anthy_do_context_set_str( ac, &xs, 1 );
   #endif

    /* ʸʿ̾ */
    anthy_get_stat(ac, &stat);
    hira_xs = NULL;
    for (i = 0; i < stat.nr_segment; ++i) {
      seg = anthy_get_nth_segment(&ac->seg_list, i);
      hira_xs = anthy_xstrcat(hira_xs, &seg->cands[0]->str);
    }
    /* ѴԤʤ */
    anthy_release_segment_list(ac);
    retval = anthy_do_context_set_str(ac, hira_xs, 0);
    anthy_free_xstr(hira_xs);
  }

 #if !defined(USE_ICONV)	/* Patched by G-HAL, Sun,14 Jun,2009 - Mon,15 Jun,2009 */
  anthy_free_xstr(xs);
 #else
 #endif
  return retval;
}

/** (API) ʸĹѹ */
void
anthy_resize_segment(anthy_context_t ac, int nth, int resize)
{
 #if defined(DEBUG) && (0 <= DEBUG)
  anthy_log(1, "TRACE: anthy_resize_segment();\n" );
 #endif
  anthy_dic_activate_session(ac->dic_session);
  anthy_do_resize_segment(ac, nth, resize);
}

/** (API) Ѵξ֤μ */
int
anthy_get_stat(anthy_context_t ac, struct anthy_conv_stat *s)
{
 #if defined(DEBUG) && (0 <= DEBUG)
  anthy_log(1, "TRACE: anthy_get_stat();%d\n", ac->seg_list.nr_segments );
 #endif
  s->nr_segment = ac->seg_list.nr_segments;
  return 0;
}

/** (API) ʸξ֤μ */
int
anthy_get_segment_stat(anthy_context_t ac, int n,
		       struct anthy_segment_stat *s)
{
  struct seg_ent *seg;
 #if defined(DEBUG) && (0 <= DEBUG)
  anthy_log(1, "TRACE: anthy_get_segment_stat(%d);\n", n );
 #endif
  seg = anthy_get_nth_segment(&ac->seg_list, n);
  if (seg) {
    s->nr_candidate = seg->nr_cands;
    s->seg_len = seg->str.len;
    return 0;
  }
  return -1;
}

static int
get_special_candidate_index(int nth, struct seg_ent *seg)
{
  int i;
  int mask = XCT_NONE;
  if (nth >= 0) {
    return nth;
  }
  if (nth == NTH_UNCONVERTED_CANDIDATE ||
      nth == NTH_HALFKANA_CANDIDATE) {
    return nth;
  }
  if (nth == NTH_KATAKANA_CANDIDATE) {
    mask = XCT_KATA;
  } else if (nth == NTH_HIRAGANA_CANDIDATE) {
    mask = XCT_HIRA;
  }
  for (i = 0; i < seg->nr_cands; i++) {
    if (anthy_get_xstr_type(&seg->cands[i]->str) & mask) {
      return i;
    }
  }
  return NTH_UNCONVERTED_CANDIDATE;
}

/** (API) ʸμ */
int
anthy_get_segment(anthy_context_t ac, int nth_seg,
		  int nth_cand, char *buf, int buflen)
{
  struct seg_ent *seg;
  char *p;
  int len;
 #if defined(DEBUG) && (0 <= DEBUG)
  anthy_log(1, "TRACE: anthy_get_segment(%d,%d,%p,%d);\n", nth_seg, nth_cand, buf, buflen );
 #endif

  /* ʸФ */
  if (nth_seg < 0 || nth_seg >= ac->seg_list.nr_segments) {
    return -1;
  }
  seg = anthy_get_nth_segment(&ac->seg_list, nth_seg);

  /* ʸᤫФ */
  p = NULL;
  if (nth_cand < 0) {
    nth_cand = get_special_candidate_index(nth_cand, seg);
  }
  if (nth_cand == NTH_HALFKANA_CANDIDATE) {
    xstr *xs = anthy_xstr_hira_to_half_kata(&seg->str);
    p = anthy_xstr_to_cstr(xs, ac->encoding);
    anthy_free_xstr(xs);
  } else if (nth_cand == NTH_UNCONVERTED_CANDIDATE) {
    /* Ѵʸ */
    p = anthy_xstr_to_cstr(&seg->str, ac->encoding);
  } else if (nth_cand >= 0 && nth_cand < seg->nr_cands) {
    p = anthy_xstr_to_cstr(&seg->cands[nth_cand]->str, ac->encoding);
  }
  if (!p) {
    return -1;
  }

 #if 1	/* Patched by G-HAL, Sat,25 Jul,2009, Tue,04 Aug,2009, Sun,25 Oct,2009, Thu,12 Nov,2009 */
  if (anthy_settings.anthy_mode.enable_provisional_committed) {
    if ((0 < buflen) && (seg->provisional_committed != nth_cand)) {
      const int	rebuild_seg_num = nth_seg + 1;
      seg->provisional_committed = nth_cand;
      if (rebuild_seg_num < ac->seg_list.nr_segments) {
	int i;
       #if defined(DEBUG) && (0 <= DEBUG)
	anthy_log(1, "TRACE: anthy_get_segment();rebuild=%d\n", rebuild_seg_num );
       #endif
	for (i = rebuild_seg_num; i < ac->seg_list.nr_segments; ++i) {
	  struct seg_ent* const seg_tmp = anthy_get_nth_segment( &(ac->seg_list), i );
	  seg_tmp->provisional_committed = -1;
	}
	for (i = rebuild_seg_num; i < ac->seg_list.nr_segments; ++i) {
	  struct seg_ent* const seg_tmp = anthy_get_nth_segment( &(ac->seg_list), i );
	  anthy_do_make_candidates( &(ac->split_info), seg_tmp, 0 );
	}
	anthy_sort_candidate( &(ac->split_info), &(ac->seg_list), rebuild_seg_num );
      }
    }
  }
 #endif

  /* Хåե˽񤭹 */
  len = strlen(p);
  if (!buf) {
    free(p);
    return len;
  }
  if (len + 1 > buflen) {
    /* Хåե­ޤ */
    free(p);
    return -1;
  }
  strcpy(buf, p);
  free(p);
  return len;
}

/* ٤Ƥʸ᤬ߥåȤ줿check */
static int
commit_all_segment_p(anthy_context_t ac)
{
  int i;
  struct seg_ent *se;
  for (i = 0; i < ac->seg_list.nr_segments; i++) {
    se = anthy_get_nth_segment(&ac->seg_list, i);
    if (se->committed < 0) {
      return 0;
    }
  }
  return 1;
}

/** (API) ʸγ */
int
anthy_commit_segment(anthy_context_t ac, int s, int c)
{
 #if 0	/* Patched by G-HAL, Wed,22 Apr,2009 */
 #else
  const int	c_arg = c;
 #endif
  struct seg_ent *seg;
 #if 0	/* Patched by G-HAL, Sat,25 Apr,2009 - Sun,26 Apr,2009, Wed,29 Apr,2009 */
  if (!ac->str.str) {
    return -1;
  }
  if (s < 0 || s >= ac->seg_list.nr_segments) {
    return -1;
  }
  if (commit_all_segment_p(ac)) {
    /* ǤƤΥȤߥåȤƤ */
    return -1;
  }
 #else
  if ((ac->str.len < 1) || (NULL == ac->str.str)) {
   #if defined(DEBUG) && (0 <= DEBUG)
    anthy_log(1, "TRACE: anthy_commit_segment(%d,%d); NUL\n", s, c );
   #endif
    anthy_do_release_prev_commit( ac );
    if (s < -1) {	/* G-HAL, Tue,14 Jul,2009 */
      if (0 < anthy_settings.timestamp.lastsession) {
	anthy_revert_record( anthy_settings.timestamp.lastsession - 1 );
	anthy_settings.timestamp.lastsession = 0;
      }
    }
    return -1;
  }
  if (s < 0) {
    /* Extended API.
     *	( ac, -1, -1 ) without seg-string	Reset.
     *	( ac, -1, -1 )				All unconverted.
     *	( ac, -1, -2 )				All katakana.
     *	( ac, -1, -3 )				All hiragana.
     *	( ac, -1, -4 )				All halfkana.
     */
   #if defined(DEBUG) && (0 <= DEBUG)
    anthy_log(1, "TRACE: anthy_commit_segment(%d,%d); Ex\n", s, c );
   #endif
    anthy_do_release_prev_commit( ac );
    anthy_xstrcat( &(ac->split_info.prev_commit.yomi), &(ac->str) );
    switch (c) {
    case NTH_UNCONVERTED_CANDIDATE:
      anthy_xstrcat( &(ac->split_info.prev_commit.cand), &(ac->str) );
      break;
    case NTH_KATAKANA_CANDIDATE:
      { xstr* const kata_xs = anthy_xstr_hira_to_kata( &(ac->str) );
	ac->split_info.prev_commit.cand.str = kata_xs->str;
	ac->split_info.prev_commit.cand.len = kata_xs->len;
	free( kata_xs );
      }
      break;
    case NTH_HIRAGANA_CANDIDATE:
      { xstr* const hira_xs = anthy_xstr_kata_to_hira( &(ac->str) );
	ac->split_info.prev_commit.cand.str = hira_xs->str;
	ac->split_info.prev_commit.cand.len = hira_xs->len;
	free( hira_xs );
      }
      break;
    case NTH_HALFKANA_CANDIDATE:
      { xstr* const hfka_xs = anthy_xstr_hira_to_half_kata( &(ac->str) );
	ac->split_info.prev_commit.cand.str = hfka_xs->str;
	ac->split_info.prev_commit.cand.len = hfka_xs->len;
	free( hfka_xs );
      }
      break;
    default:
      if (s < -1) {	/* G-HAL, Tue,14 Jul,2009 */
	if (0 < anthy_settings.timestamp.lastsession) {
	  anthy_revert_record( anthy_settings.timestamp.lastsession - 1 );
	  anthy_settings.timestamp.lastsession = 0;
	}
      }
      break;
    }
    anthy_settings.timestamp.lastsession = 0;
    return -1;
  }
  if ((ac->seg_list.nr_segments <= s)
      || commit_all_segment_p(ac)
  ) {
   #if defined(DEBUG) && (0 <= DEBUG)
    anthy_log(1, "TRACE: anthy_commit_segment(%d,%d); OV\n", s, c );
   #endif
    anthy_do_release_prev_commit( ac );
    anthy_settings.timestamp.lastsession = 0;
    return -1;
  }
 #endif
 #if defined(DEBUG) && (0 <= DEBUG)
  anthy_log(1, "TRACE: anthy_commit_segment(%d,%d);\n", s, c );
 #endif

  anthy_dic_activate_session(ac->dic_session);
  seg = anthy_get_nth_segment(&ac->seg_list, s);
  if (c < 0) {
    c = get_special_candidate_index(c, seg);
  }
  if (c == NTH_UNCONVERTED_CANDIDATE) {
    /*
     * Ѵʸ󤬥ߥåȤ줿Τǡбֹõ
     */
    int i;
    for (i = 0; i < seg->nr_cands; i++) {
      if (!anthy_xstrcmp(&seg->str, &seg->cands[i]->str)) {
	c = i;
      }
    }
  }
 #if 0	/* Patched by G-HAL, Sat,25 Apr,2009 */
  if (c < 0 || c >= seg->nr_cands) {
    return -1;
  }
 #else
  if (c < 0 || c >= seg->nr_cands) {
    anthy_do_release_prev_commit( ac );
    return -1;
  }
 #endif
  seg->committed = c;
 #if 1	/* Patched by G-HAL, Tue,04 Aug,2009 */
  seg->provisional_committed = c;
 #endif
 #if defined(DEBUG) && (1 <= DEBUG)
  anthy_log(1, "TRACE: anthy_commit_segment(%d); committed: %d\n", c_arg, c );
 #endif

  if (commit_all_segment_p(ac)) {
    /* ٤ƤΥȤߥåȤ줿 */
   #if 0	/* Patched by G-HAL, Wed,22 Apr,2009, Wed,15 Oct,2008, Wed,22 Apr,2009, Sat,25 Apr,2009 */
    anthy_proc_commit(&ac->seg_list, &ac->split_info);
   #else
    anthy_settings.timestamp.currentsession = time(NULL);
    anthy_settings.timestamp.lastsession = anthy_settings.timestamp.currentsession;
    anthy_proc_commit( &(ac->seg_list), &(ac->split_info),
		      (NTH_UNCONVERTED_CANDIDATE != c_arg) && ((0 <= c_arg) || anthy_settings.anthy_mode.learn.enable_autolearn)
		      );
   #endif
    /**/
    anthy_save_history(history_file, ac);
  }
  return 0;
}

/** (API) ͽ¬Ƥۤʸ */
int
anthy_set_prediction_string(anthy_context_t ac, const char* s)
{
  int retval;
  xstr *xs;
 #if defined(DEBUG) && (0 <= DEBUG)
  anthy_log(1, "TRACE: anthy_set_prediction_string();\n" );
 #endif

  anthy_dic_activate_session(ac->dic_session);
  /* ͽ¬򳫻Ϥ˸Ŀͼreload */
  anthy_reload_record();


  xs = anthy_cstr_to_xstr(s, ac->encoding);

  retval = anthy_do_set_prediction_str(ac, xs);

  anthy_free_xstr(xs);

  return retval;
}

/** (API) ͽ¬Ѵξ֤μ */
int
anthy_get_prediction_stat(anthy_context_t ac, struct anthy_prediction_stat * ps)
{
 #if defined(DEBUG) && (0 <= DEBUG)
  anthy_log(1, "TRACE: anthy_get_prediction_stat();\n" );
 #endif
  ps->nr_prediction = ac->prediction.nr_prediction;
  return 0;
}

/** (API) ͽ¬Ѵθμ */
int
anthy_get_prediction(anthy_context_t ac, int nth, char* buf, int buflen)
{
  struct prediction_cache* prediction = &ac->prediction;
  int nr_prediction = prediction->nr_prediction;
  char* p;
  int len;

 #if defined(DEBUG) && (0 <= DEBUG)
  anthy_log(1, "TRACE: anthy_get_prediction();\n" );
 #endif
  if (nth < 0 || nr_prediction <= nth) {
    return -1;
  }

  p = anthy_xstr_to_cstr(prediction->predictions[nth].str, ac->encoding);

  /* Хåե˽񤭹 */
  len = strlen(p);
  if (!buf) {
    free(p);
    return len;
  }
  if (len + 1 > buflen) {
    free(p);
    return -1;
  } else {
    strcpy(buf, p);
    free(p);
    return len;
  }
}

/** (API) ͽ¬η̤ꤹ
 */
int
anthy_commit_prediction(anthy_context_t ac, int nth)
{
  struct prediction_cache* pc = &ac->prediction;
 #if defined(DEBUG) && (0 <= DEBUG)
  anthy_log(1, "TRACE: anthy_commit_prediction();\n" );
 #endif
  if (nth < 0 || nth >= pc->nr_prediction) {
    return -1;
  }
  anthy_do_commit_prediction(pc->predictions[nth].src_str,
			     pc->predictions[nth].str);
  return 0;
}

/** (API) ȯ */
void
anthy_print_context(anthy_context_t ac)
{
 #if defined(DEBUG) && (0 <= DEBUG)
  anthy_log(1, "TRACE: anthy_print_context();\n" );
 #endif
  anthy_do_print_context(ac, default_encoding);
}

/** (API) Anthy 饤֥ΥСɽʸ֤
 * ͭ饤֥ǤϳѿΥݡȤϹޤʤΤǴؿˤƤ
 */
const char *
anthy_get_version_string(void)
{
 #if defined(DEBUG) && (0 <= DEBUG)
  anthy_log(1, "TRACE: anthy_get_version_string();\n" );
 #endif
#ifdef PACKAGE_VERSION
  return PACKAGE_VERSION;
#else  /* just in case */
  return "(unknown)";
#endif
}

/** (API) */
int
anthy_context_set_encoding(anthy_context_t ac, int encoding)
{
 #if defined(DEBUG) && (0 <= DEBUG)
  anthy_log(1, "TRACE: anthy_context_set_encoding();\n" );
 #endif
  if (!ac) {
    return ANTHY_EUC_JP_ENCODING;
  }
  if (encoding == ANTHY_UTF8_ENCODING ||
      encoding == ANTHY_EUC_JP_ENCODING) {
    ac->encoding = encoding;
  }
  return ac->encoding;
}

/** (API) */
int
anthy_set_reconversion_mode(anthy_context_t ac, int mode)
{
 #if defined(DEBUG) && (0 <= DEBUG)
  anthy_log(1, "TRACE: anthy_set_reconversion_mode();\n" );
 #endif
  if (!ac) {
   #if 0	/* Patched by G-HAL, Wed,25 Mar,2009 */
    return ANTHY_RECONVERT_AUTO;
   #else
    return anthy_settings.anthy_mode.reconversion_mode;
   #endif
  }
  if (mode == ANTHY_RECONVERT_AUTO ||
      mode == ANTHY_RECONVERT_DISABLE ||
      mode == ANTHY_RECONVERT_ALWAYS) {
    ac->reconversion_mode = mode;
  }
  return ac->reconversion_mode;
}
/* vim:ts=8 sw=2 nomodified:
 */
