/*
 * Ѵʸο̤ʤɤʹʸʤɤ
 * ޤȤѴƥȤȸƤ֡
 * AnthyΥƥȤФƤƤФ롣
 * ФѴѥץ饤ɬפʥ⥸塼˸ƤӤ
 *
 * personalityδ⤹롣
 *
 * Funded by IPA̤Ƨեȥ¤ 2001 10/29
 * Copyright (C) 2000-2007 TABATA Yusuke
 *
 * $Id: context.c,v 1.26 2002/11/17 14:45:47 yusuke Exp $
 */
/*
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
#if 0		/* Patched by G-HAL */
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <anthy/anthy.h>
#include <anthy/alloc.h>
#include <anthy/record.h>
#include <anthy/ordering.h>
#include <anthy/splitter.h>
#include <anthy/xstr.h>
#include "main.h"
#else
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_MALLOC_H)
# include <malloc.h>
#endif
#if defined(HAVE_STDIO_H)
# include <stdio.h>
#endif
#if defined(HAVE_UNISTD_H)
# include <unistd.h>
#endif
#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif
#if defined(HAVE_SYS_STAT_H)
# include <sys/stat.h>
#endif
#if defined(HAVE_FCNTL_H)
# include <fcntl.h>
#endif
#if defined(HAVE_STRING_H)
# include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
# include <strings.h>
#endif
#if defined(BENCHMARK)		/* Patched by G-HAL, Sun,21 Aug,2011 */
# if !defined(__STDC_FORMAT_MACROS)
#  define	__STDC_FORMAT_MACROS
# endif
#if defined(HAVE_INTTYPES_H)
# include <inttypes.h>
#endif
#if defined(HAVE_SYS_TIME_H)
# include <sys/time.h>
#endif
#endif

#include "anthy/settings.h"		/* Patched by G-HAL, Tue,28 Oct,2008 */
#include "anthy/anthy.h"
#include "anthy/alloc.h"
#include "anthy/record.h"
#include "anthy/ordering.h"
#include "anthy/splitter.h"
#include "anthy/xstr.h"
#include "anthy/segclass.h"		/* Patched by G-HAL, Sat,25 Apr,2009 */
#include "src-splitter/cand_wt_name.h"	/* Patched by G-HAL, Wed,28 Oct,2009 */
#include "src-splitter/depgraph_type_sym.h"	/* Patched by G-HAL, Tue,27 Oct,2009 */
#include "src-worddic/dic_main.h"	/* Patched by G-HAL, Wed,27 May,2009 */
#include "src-ordering/ucdict.h"	/* Patched by G-HAL, Thu,12 Nov,2009 */
#include "main.h"
#if defined(BENCHMARK)		/* Patched by G-HAL, Sun,21 Aug,2011 */
# include "anthy/calctime.h"
#endif
#endif


#if defined(BENCHMARK)		/* Patched by G-HAL, Sun,21 Aug,2011 */
static struct timeval total_tod_border;
static struct timeval total_tod_candidate;
#endif


/**/
static allocator context_ator;

/** ߤpersonality
 * ̤: null
 * ̤ΤޤѴ򳫻Ϥ: "default"
 * anonymousξ: ""
 */
static char *current_personality;

/**/
#define HISTORY_FILE_LIMIT 100000

#if 1	/* Patched by G-HAL, Sat,25 Apr,2009 - Sun,26 Apr,2009, Tue,20 Jul,2010 - Wed,21 Jul,2010 */
void anthy_do_release_prev_commit( struct anthy_context* const ac )
{
  ac->split_info.prev_commit.seg_dep_info.seg_class     = SEG_HEAD;
  ac->split_info.prev_commit.seg_dep_info.dep_class     = DEP_NONE;
  ac->split_info.prev_commit.seg_dep_info.dep_word_hash = 0;
  anthy_free_xstr_str( &(ac->split_info.prev_commit.yomi) );
  ac->split_info.prev_commit.yomi.str = NULL;
  ac->split_info.prev_commit.yomi.len = 0;
  anthy_free_xstr_str( &(ac->split_info.prev_commit.cand) );
  ac->split_info.prev_commit.cand.str = NULL;
  ac->split_info.prev_commit.cand.len = 0;
  if (ac->split_info.prev_commit.seg_ucinfo) {
    free( ac->split_info.prev_commit.seg_ucinfo );
    ac->split_info.prev_commit.seg_ucinfo = NULL;
  }
  return;
}
#endif

static void
context_dtor(void *p)
{
 #if 1	/* Patched by G-HAL, Sat,25 Apr,2009 - Sun,26 Apr,2009 */
  anthy_do_release_prev_commit( (struct anthy_context*)p );
 #endif
  anthy_do_reset_context((struct anthy_context *)p);
}

/** ߤpersonality֤ */
static char *
get_personality(void)
{
  if (!current_personality) {
    current_personality = strdup("default");
    anthy_dic_set_personality(current_personality);
  }
  return current_personality;
}

static void
release_segment(struct seg_ent *s)
{
  if (s->cands) {
    int i;
    for (i = 0; i < s->nr_cands; i++) {
      anthy_release_cand_ent(s->cands[i]);
    }
    free (s->cands);
  }
  if (s->mw_array) {
    free(s->mw_array);
  }
  free(s);

}

/** ʸꥹȤκǸǤ */
static void
pop_back_seg_ent(struct anthy_context *c)
{
  struct seg_ent *s;
  s = c->seg_list.list_head.prev;
  if (s == &c->seg_list.list_head) {
    return ;
  }
  s->prev->next = s->next;
  s->next->prev = s->prev;
  release_segment(s);
  c->seg_list.nr_segments --;
}


/** nܤʸʸindex */
static int
get_nth_segment_index(struct anthy_context *c, int n)
{
  int i,s;
  for (i = 0, s = 0; i < c->str.len; i++) {
    if (c->split_info.ce[i].seg_border) {
      if (s == n) {
	return i;
      }
      s++;
    }
  }
  return -1;
}

/** nܤʸĹ롥
 * segment_listƤʤƤ׻Ǥ褦ˤ롥
 */
static int
get_nth_segment_len(struct anthy_context *c, int sindex)
{
  int a,i,l;
  a = get_nth_segment_index(c, sindex);
  if ( a == -1){
    return -1;
  }
  l = 1;
  for (i = a+1; !c->split_info.ce[i].seg_border; i++) {
    l++;
  }
  return l;
}

/** metaword */
static void
make_metaword_array(struct anthy_context *ac,
		    struct seg_ent *se)
{
  int i;
  se->mw_array = NULL;
  for (i = se->len; i > 0; i--) {
    int j;
    /* ǸȤĤƤľʸ */
    if (i < se->len &&
	anthy_get_xchar_type(se->str.str[i]) & XCT_PART) {
      /* FIXME Ȥꤨʤ¤Ӥ򤷤Ƥ */
      i--;
      continue ;
    }

    se->nr_metaword = anthy_get_nr_metaword(&ac->split_info, se->from, i);
    if (!se->nr_metaword) {
      continue ;
    }
    /* metaword˼ */
    se->mw_array = (struct meta_word**) malloc(sizeof(struct meta_word*) * se->nr_metaword);
    for (j = 0; j < se->nr_metaword; j++) {
      se->mw_array[j] = anthy_get_nth_metaword(&ac->split_info, se->from, i, j);
    }
    return;
  }
}

static struct seg_ent*
create_segment(struct anthy_context *ac, int from, int len,
	       struct meta_word* best_mw)
{
  struct seg_ent* s;
  s = (struct seg_ent *)malloc(sizeof(struct seg_ent));
  s->str.str = &ac->str.str[from];
  s->str.len = len;
  s->from = from;
  s->len = s->str.len;
  s->nr_cands = 0;
  s->cands = NULL;
  s->best_seg_class = ac->split_info.ce[from].best_seg_class;
  s->best_mw = best_mw;
  make_metaword_array(ac, s);
  return s;
}

/** ѴƥȤʸɲä */
static void
push_back_segment(struct anthy_context *ac, struct seg_ent *se)
{
  se->next = &ac->seg_list.list_head;
  se->prev = ac->seg_list.list_head.prev;
  ac->seg_list.list_head.prev->next = se;
  ac->seg_list.list_head.prev = se;
  ac->seg_list.nr_segments ++;
  se->committed = -1;
  se->provisional_committed = -1;	/* Patched by G-HAL, Sat,25 Jul,2009 */
}

/** splitterˤäդ줿ʸᶭΥޡ顢
 * ʸΥꥹȤ
 */
static void
create_segment_list(struct anthy_context *ac, int from, int to)
{
  int i, n;
  struct seg_ent *s;
  /* from νޤǤˤĤʸ᤬뤫Ĵ٤ */
  i = 0; n = 0;
  while (i < from) {
    i += get_nth_segment_len(ac, n);
    n++;
  };
  /**/
  for (i = from; i < to; i++) {
    if (ac->split_info.ce[i].seg_border) {
      int len = get_nth_segment_len(ac, n);
      s = create_segment(ac, i, len, ac->split_info.ce[i].best_mw);

      push_back_segment(ac, s);
      n++;
    }
  }
}

/** ƥȤ */
struct anthy_context *
anthy_do_create_context(int encoding)
{
  struct anthy_context *ac;
  char *p = get_personality();

  if (!p) {
    return NULL;
  }

  ac = (struct anthy_context *)anthy_smalloc(context_ator);
  ac->str.str = NULL;
  ac->str.len = 0;
 #if 1	/* Patched by G-HAL, Sun,19 Apr,2009 - Mon,20 Apr,2009 */
  ac->lattice_hint = NULL;
 #endif
  ac->seg_list.nr_segments = 0;
  ac->seg_list.list_head.prev = &ac->seg_list.list_head;
  ac->seg_list.list_head.next = &ac->seg_list.list_head;
  ac->split_info.word_split_info = NULL;
  ac->split_info.ce = NULL;
 #if 1	/* Patched by G-HAL, Sat,25 Apr,2009, Thu,12 Nov,2009, Tue,20 Jul,2010 - Wed,21 Jul,2010 */
  ac->split_info.prev_commit.seg_dep_info.seg_class     = SEG_HEAD;
  ac->split_info.prev_commit.seg_dep_info.dep_class     = DEP_NONE;
  ac->split_info.prev_commit.seg_dep_info.dep_word_hash = 0;
  ac->split_info.prev_commit.yomi.str = NULL;
  ac->split_info.prev_commit.yomi.len = 0;
  ac->split_info.prev_commit.cand.str = NULL;
  ac->split_info.prev_commit.cand.len = 0;
  ac->split_info.prev_commit.seg_ucinfo = NULL;
 #endif
  ac->ordering_info.oc = NULL;
  ac->dic_session = NULL;
  ac->prediction.str.str = NULL;
  ac->prediction.str.len = 0;
  ac->prediction.nr_prediction = 0;
  ac->prediction.predictions = NULL;
  ac->encoding = encoding;
 #if 0	/* Patched by G-HAL, Wed,25 Mar,2009 */
  ac->reconversion_mode = ANTHY_RECONVERT_AUTO;
 #else
  ac->reconversion_mode = anthy_settings.anthy_mode.reconversion_mode;
 #endif

  return ac;
}

/** ƥȤΥ */
void
anthy_init_contexts(void)
{
  context_ator = anthy_create_allocator(sizeof(struct anthy_context),
					context_dtor);
}

void
anthy_quit_contexts(void)
{
  anthy_free_allocator(context_ator);
}

static void
release_prediction(struct prediction_cache *pc)
{
  int i;
  if (pc->str.str) {
    free(pc->str.str);
    pc->str.str = NULL;
  }
  if (pc->predictions) {
    for (i = 0; i < pc->nr_prediction; ++i) {
      anthy_free_xstr(pc->predictions[i].src_str);
      anthy_free_xstr(pc->predictions[i].str);
    }
    free(pc->predictions);
    pc->predictions = NULL;
  }
}

void
anthy_release_segment_list(struct anthy_context *ac)
{
  int i, sc;
  sc = ac->seg_list.nr_segments;
  for (i = 0; i < sc; i++) {
    pop_back_seg_ent(ac);
  }
  ac->seg_list.nr_segments = 0;
}

/* resetǤcontextΤ˳ݤ줿꥽Ʋ */
void
anthy_do_reset_context(struct anthy_context *ac)
{
  /* ޤ񥻥å */
  if (ac->dic_session) {
    anthy_dic_release_session(ac->dic_session);
    ac->dic_session = NULL;
  }
 #if 1	/* Patched by G-HAL, Sun,19 Apr,2009 - Mon,20 Apr,2009 */
  if (ac->lattice_hint) {
    free( ac->lattice_hint );
    ac->lattice_hint = NULL;
  }
 #endif
  if (!ac->str.str) {
    /* ʸꤵƤʤв٤ʪϤ⤦̵ */
    return ;
  }
  free(ac->str.str);
  ac->str.str = NULL;
  anthy_release_split_context(&ac->split_info);
  anthy_release_segment_list(ac);

  /* ͽ¬줿ʸβ */
  release_prediction(&ac->prediction);
}

void
anthy_do_release_context(struct anthy_context *ac)
{
 #if 1	/* Patched by G-HAL, Sat,25 Apr,2009 - Sun,26 Apr,2009 */
  anthy_do_release_prev_commit( ac );
 #endif
  anthy_sfree(context_ator, ac);
}

#if 0		/* Patched by G-HAL, Wed,15 Oct,2008, Sun,19 Apr,2009 */
static void
make_candidates(struct anthy_context *ac, int from, int from2, int is_reverse)
#else
static void make_candidates( struct anthy_context* ac, int from, int from2, int nth, int is_reverse, int is_resize )
#endif
{
  int i;
  int len = ac->str.len;

 #if defined(BENCHMARK)		/* Patched by G-HAL, Sun,21 Aug,2011 */
  {
    struct timeval start_tod;
    gettimeofday( &start_tod, NULL );
 #endif
  /* ʸζ */
  /* from  from2δ֤˶뤳Ȥػߤ */
 #if 0		/* Patched by G-HAL, Sun,19 Apr,2009 */
  anthy_mark_border(&ac->split_info, from, from2, len);
 #else
  anthy_mark_border( &(ac->split_info), from, from2, len, is_resize );
 #endif
  create_segment_list(ac, from, len);
 #if defined(BENCHMARK)		/* Patched by G-HAL, Sun,21 Aug,2011 */
    {
      struct timeval done_tod;
      gettimeofday( &done_tod, NULL );
      SubTime( &done_tod, &start_tod );
      AddTime( &total_tod_border, &done_tod );
    }
  }
 #endif
 #if defined(BENCHMARK)		/* Patched by G-HAL, Sun,21 Aug,2011 */
  {
    struct timeval start_tod;
    gettimeofday( &start_tod, NULL );
 #endif
 #if 0	/* Patched by G-HAL, Sat,25 Apr,2009, Tue,20 Jul,2010 */
  anthy_sort_metaword(&ac->seg_list);
 #else
  anthy_sort_metaword( &(ac->split_info.prev_commit), &(ac->seg_list) );
 #endif

  /*  */
 #if 0		/* Patched by G-HAL, Wed,15 Oct,2008 */
  for (i = 0; i < ac->seg_list.nr_segments; i++) {
 #else
  for (i = nth; i < ac->seg_list.nr_segments; i++) {
 #endif
    anthy_do_make_candidates(&ac->split_info,
			     anthy_get_nth_segment(&ac->seg_list, i),
			     is_reverse);
  }
  /* 򥽡 */
 #if 0		/* Patched by G-HAL, Wed,15 Oct,2008, Thu,12 Nov,2009 */
  anthy_sort_candidate(&ac->seg_list, 0);
 #else
  anthy_sort_candidate( &(ac->split_info), &(ac->seg_list), nth );
 #endif
  #if defined(BENCHMARK)		/* Patched by G-HAL, Sun,21 Aug,2011 */
    {
      struct timeval done_tod;
      gettimeofday( &done_tod, NULL );
      SubTime( &done_tod, &start_tod );
      AddTime( &total_tod_candidate, &done_tod );
    }
  }
  #endif
}

int
anthy_do_context_set_str(struct anthy_context *ac, xstr *s, int is_reverse)
{
  int i;

  /* ʸ򥳥ԡ(ʸʬ;פˤ0򥻥å) */
 #if 0	/* Patched by G-HAL, Sun,19 Apr,2009 - Thu,23 Apr,2009 */
  ac->str.str = (xchar *)malloc(sizeof(xchar)*(s->len+1));
  anthy_xstrcpy(&ac->str, s);
  ac->str.str[s->len] = 0;
 #else
  if (ANTHY_LATTICE_HINTING_NONE != anthy_settings.anthy_mode.lattice.hinting) {
    ac->lattice_hint = anthy_convert_hint_border( s, &(ac->str) );
    if (ac->str.len <= 0) {
      if (ac->lattice_hint) {
	free( ac->lattice_hint );
	ac->lattice_hint = NULL;
      }
      if (ac->str.str) {
	free(ac->str.str);
	ac->str.str = NULL;
      }
      ac->str.str = (xchar*) malloc( sizeof(xchar) * (s->len+1) );
      anthy_xstrcpy( &(ac->str), s );
      ac->str.str[s->len] = 0;
    }

  } else {
    ac->str.str = (xchar*) malloc( sizeof(xchar) * (s->len+1) );
    anthy_xstrcpy( &(ac->str), s );
    ac->str.str[s->len] = 0;
  }
 #endif

  /* splitterν*/
 #if 0	/* Patched by G-HAL, Sun,19 Apr,2009 - Mon,20 Apr,2009 */
  anthy_init_split_context(&ac->str, &ac->split_info, is_reverse);
 #else
  anthy_init_split_context( &(ac->str), ac->lattice_hint, &(ac->split_info), is_reverse );
 #endif

  /* θ */
 #if 0
  make_candidates(ac, 0, 0, is_reverse);
 #else
  make_candidates( ac, 0, 0, 0, is_reverse, 0 );
 #endif

  /* ǽꤷʸᶭФƤ */
  for (i = 0; i < ac->seg_list.nr_segments; i++) {
    struct seg_ent *s = anthy_get_nth_segment(&ac->seg_list, i);
    ac->split_info.ce[s->from].initial_seg_len = s->len;
  }

  return 0;
}

void
anthy_do_resize_segment(struct anthy_context *ac,
			int nth, int resize)
{
  int i;
  int index, len, sc;

  /* resizeǽ */
  if (nth >= ac->seg_list.nr_segments) {
    return ;
  }
  index = get_nth_segment_index(ac, nth);
  len = get_nth_segment_len(ac, nth);
  if (index + len + resize > ac->str.len) {
    return ;
  }
  if (len + resize < 1) {
    return ;
  }

  /* nthʹߤseg_ent */
  sc = ac->seg_list.nr_segments;
  for (i = nth; i < sc; i++) {
    pop_back_seg_ent(ac);
  }

  /* resizeseg_borderޡ */
  /* ߤΥޡäƿޡĤ */
  ac->split_info.ce[index+len].seg_border = 0;
  ac->split_info.ce[ac->str.len].seg_border = 1;
  for (i = index+len+resize+1; i < ac->str.len; i++) {
    ac->split_info.ce[i].seg_border = 0;
  }
  ac->split_info.ce[index+len+resize].seg_border = 1;
  for (i = index; i < ac->str.len; i++) {
    ac->split_info.ce[i].best_mw = NULL;
  }

  /* θ */
 #if 0		/* Patched by G-HAL, Wed,15 Oct,2008 */
  make_candidates(ac, index, index+len+resize, 0);
 #else
  make_candidates( ac, index, index+len+resize, nth, 0, 1 );
 #endif
}

/*
 * n֤ʸ롢̵ˤNULL֤
 */
struct seg_ent *
anthy_get_nth_segment(struct segment_list *sl, int n)
{
  int i;
  struct seg_ent *se;
  if (n >= sl->nr_segments ||
      n < 0) {
    return NULL;
  }
  for (i = 0, se = sl->list_head.next; i < n; i++, se = se->next);
  return se;
}

int
anthy_do_set_prediction_str(struct anthy_context *ac, xstr* xs)
{
  struct prediction_cache* prediction = &ac->prediction;
  int nr_prediction;

  /* ޤ񥻥å */
  if (ac->dic_session) {
    anthy_dic_release_session(ac->dic_session);
    ac->dic_session = NULL;
  }
  /* ͽ¬줿ʸβ */
  release_prediction(&ac->prediction);

  /* 񥻥åγ */
  if (!ac->dic_session) {
    ac->dic_session = anthy_dic_create_session();
    if (!ac->dic_session) {
      return -1;
    }
  }

  prediction->str.str = (xchar*)malloc(sizeof(xchar*)*(xs->len+1));
  anthy_xstrcpy(&prediction->str, xs);
  prediction->str.str[xs->len]=0;

  nr_prediction = anthy_traverse_record_for_prediction(xs, NULL);
  prediction->nr_prediction = nr_prediction;

  if (nr_prediction) {
    prediction->predictions = (struct prediction_t*)malloc(sizeof(struct prediction_t) *
							   nr_prediction);
    anthy_traverse_record_for_prediction(xs, prediction->predictions);
  }
  return 0;
}

static const char *
get_change_state(struct anthy_context *ac)
{
  int resize = 0, cand_change = 0;
  int i;
  for (i = 0; i < ac->seg_list.nr_segments; i++) {
    struct seg_ent *s = anthy_get_nth_segment(&ac->seg_list, i);
    if (ac->split_info.ce[s->from].initial_seg_len != s->len) {
      resize = 1;
    }
    if (s->committed > 0) {
      cand_change = 1;
    }
  }
  /**/
  if (resize && cand_change) {
    return "SC";
  }
  if (resize) {
    return "S";
  }
  if (cand_change) {
    return "C";
  }
  return "-";
}

static void
write_history(FILE *fp, struct anthy_context *ac)
{
  int i;
  /* ɤ */
  fprintf(fp, "|");
  for (i = 0; i < ac->seg_list.nr_segments; i++) {
    struct seg_ent *s = anthy_get_nth_segment(&ac->seg_list, i);
    char *c = anthy_xstr_to_cstr(&s->str, ANTHY_EUC_JP_ENCODING);
    fprintf(fp, "%s|", c);
    free(c);
  }
  fprintf(fp, " |");
  /*  */
  for (i = 0; i < ac->seg_list.nr_segments; i++) {
    struct seg_ent *s = anthy_get_nth_segment(&ac->seg_list, i);
    char *c;
    /**/
    if (s->committed < 0) {
      fprintf(fp, "?|");
      continue ;
    }
    c = anthy_xstr_to_cstr(&s->cands[s->committed]->str,
			   ANTHY_EUC_JP_ENCODING);
    fprintf(fp, "%s|", c);
    free(c);
  }
}

void
anthy_save_history(const char *fn, struct anthy_context *ac)
{
  FILE *fp;
  struct stat st;

  if (!fn) {
    return ;
  }
 #if 0		/* Patched by G-HAL, Tue,28 Oct,2008, Tue,17 May,2011 */
  fp = fopen(fn, "a");
  if (!fp) {
    return ;
  }
 #else
  const int fd_flags = (O_WRONLY | O_APPEND | O_CREAT | O_EXLOCK);
  const mode_t fd_mode = (~anthy_settings.file_umask) & (S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH);
  const int fd = open( fn, fd_flags, fd_mode );
  if (fd < 0) {
    return;
  }
  fp = fdopen( fd, "a" );
  if (NULL == fp) {
    close( fd );
    return;
  }
 #endif
  if (stat(fn, &st) ||
      st.st_size > HISTORY_FILE_LIMIT) {
    fclose(fp);
    return ;
  }
  /**/
  fprintf(fp, "anthy-%s ", anthy_get_version_string());
  fprintf(fp, "%s ", get_change_state(ac));
  write_history(fp, ac);
  fprintf(fp, "\n");
  fclose(fp);
  /**/
  chmod(fn, S_IREAD | S_IWRITE);
}

/** ɽ */
void
anthy_print_candidate(struct cand_ent *ce)
{
  /* int mod = (ce->score % 1000); */	/* Patched by G-HAL, Fri,14 Nov,2008 */
  int seg_score = 0;

  if (ce->mw) {
    seg_score = ce->mw->score;
  }
  anthy_putxstr(&ce->str);
  printf(":(");
  /*if (ce->nr_words == 1) {printf("%d,", ce->elm[0].id);    }*/
  if (ce->flag & CEF_OCHAIRE) {
    putchar('o');
    if (ce->flag & CEF_OCHAIREwithINDEP) {	/* Patched by G-HAL, Sun,08 Feb,2009 */
      putchar('i');
    } else {
      putchar('-');
    }
    if (ce->flag & CEF_OCHAIREwithDEP) {	/* Patched by G-HAL, Sat,24 Jan,2009 */
      putchar('d');
    } else {
      putchar('-');
    }
    putchar(':');	/* Patched by G-HAL, Sun,08 Feb,2009 */
  }
  if (ce->mw && (0 < ce->mw->ochaire_opposite)) {	/* Patched by G-HAL, Thu,29 Jan,2009 */
    putchar('+');
  }
  if (ce->flag & CEF_CANDHISTORY) {	/* Patched by G-HAL, Fri,14 Nov,2008 */
    putchar('c');
  }
  if (ce->flag & CEF_AddScoreByLEARNstrong) {	/* Patched by G-HAL, Wed,14 Jan,2009 */
    putchar('s');
  } else if (ce->flag & CEF_AddScoreByLEARN) {	/* Patched by G-HAL, Wed,14 Jan,2009 */
    putchar('w');
  }
  if (ce->flag & CEF_SINGLEWORD) {
    putchar('1');
  }
 #if 0		/* Patched by G-HAL, Tue,19 May,2009 */
  if (ce->flag & CEF_GUESS) {
 #else
  if (ce->flag & (CEF_GUESS | CEF_GUESS_XCT_PART)) {
 #endif
    putchar('g');
  }
  if (ce->flag & (CEF_KATAKANA | CEF_HIRAGANA)) {
    putchar('N');
  }
  if (ce->flag & CEF_USEDICT) {
    putchar('U');
  }
  if (ce->flag & CEF_CONTEXT) {
    putchar('C');
  }
  printf(",%d,", seg_score);


  if (ce->mw) {
   #if 0	/* Patched by G-HAL, Thu,20 Nov,2008, Sat,24 Jan,2009, Wed,04 Feb,2009, Sat,21 Feb,2009, Fri,01 May,2009, Wed,27 May,2009, Tue,27 Oct,2009 - Wed,28 Oct,2009 */
    printf("%s,%d", anthy_seg_class_sym(ce->mw->seg_class),
	   ce->mw->struct_score);
   #else
    const char* wt_name;
    if (0 != anthy_get_ce_wtname(ce, &wt_name)) {
      wt_name = "#?";
    }
    printf("%s,%d,%s,%s,H%sC%sS%s,E:%d,F:%d,LF:%d,D:%d,L:%d",
	   anthy_seg_class_sym(ce->mw->seg_class),
	   ce->mw->struct_score,
	   anthy_dep_class_sym(ce->mw->dep_class),
	   wt_name,
	   anthy_depgraph_pos_class_sym(ce->mw),
	   anthy_depgraph_ct_class_sym(ce->mw),
	   anthy_depgraph_dep_class_sym(ce->mw),
	   ce->mw->extra_score,
	   ce->mw->cand_hint_freq / FREQ_RATIO,
	   ce->mw->cand_hint_learned_freq,
	   ce->mw->cand_hint_depth_of_dep,
	   ce->mw->cand_hint_length_of_dep );
   #endif
   #if 1		/* Patched by G-HAL, Wed,22 Jul,2009 */
    switch (ce->mw->type) {
    case MW_DUMMY:				printf(",%s", "-" ); break;
    case MW_SINGLE:				printf(",%s", "S" ); break;
    case MW_WRAP:				printf(",%s", "W" ); break;
    case MW_COMPOUND_HEAD:			printf(",%s", "Ch" ); break;
    case MW_COMPOUND:				printf(",%s", "C" ); break;
    case MW_COMPOUND_LEAF:			printf(",%s", "Cl" ); break;
    case MW_COMPOUND_PART:			printf(",%s", "Cp" ); break;
    case MW_V_RENYOU_A:				printf(",%s", "Va" ); break;
    case MW_V_RENYOU_NOUN:			printf(",%s", "Vn" ); break;
    case MW_NUMBER:				printf(",%s", "N" ); break;
    case MW_learned_min:			printf(",%s", "l-" ); break;
    case MW_ochaire_min:			printf(",%s", "o-" ); break;
    case MW_OCHAIRE:				printf(",%s", "O++" ); break;
    case MW_OCHAIREwithoutDEP:			printf(",%s", "O+-" ); break;
    case MW_OCHAIREwithoutINDEP:		printf(",%s", "O-+" ); break;
    case MW_OCHAIREwithoutINDEPwithoutDEP:	printf(",%s", "O--" ); break;
    case MW_ochaire_max:			printf(",%s", "o+" ); break;
    case MW_CANDHISTORY:			printf(",%s", "H" ); break;
    case MW_learned_max:			printf(",%s", "l+" ); break;
    case MW_END:				printf(",%s", "*" ); break;
    }
   #endif
  } else {
    putchar('-');
  }
  printf(")");

  if (ce->score >= 1000) {
   #if 0		/* Patched by G-HAL, Fri,14 Nov,2008 */
    printf("%d,", ce->score/1000);
    if (mod < 100) {
      printf("0");
    }
    if (mod < 10) {
      printf("0");
    }
    printf("%d ", mod);
   #else
    if (ce->score >= 1000000) {
      printf("%d,", ce->score /1000000 );
      printf("%03d,", (ce->score /1000) % 1000 );
    } else {
      printf("%d,", ce->score /1000 );
    }
    printf("%03d ", (ce->score % 1000) );
   #endif
  } else {
    printf("%d ", ce->score);
  }
}

/** ʸɽ */
static void
print_segment(struct seg_ent *e)
{
  int i;

  anthy_putxstr(&e->str);
  printf("(");
  for ( i = 0 ; i < e->nr_cands ; i++) {
    anthy_print_candidate(e->cands[i]);
    printf(",");
  }
  printf(")");
  printf(":\n");
}

/** ƥȤɽ */
void
anthy_do_print_context(struct anthy_context *ac, int encoding)
{
  int i;
 #ifdef __cplusplus
  struct splitter_context::char_ent *ce;
 #else
  struct char_ent *ce;
 #endif
  anthy_xstr_set_print_encoding(encoding);

 #ifdef __cplusplus
  ce = (struct splitter_context::char_ent*) ac->split_info.ce;
 #else
  ce = (struct char_ent*) ac->split_info.ce;
 #endif
  if (!ce) {
    printf("(invalid)\n");
    return ;
  }
  /* ʸɽ */
  for (i = 0, ce = ac->split_info.ce; i < ac->str.len; i++, ce++) {
    if (ce->seg_border) {
      printf("|");
    }
    anthy_putxchar(*(ce->c));
  }
  printf("\n");
  /* ʸɽ */
  for (i = 0; i < ac->seg_list.nr_segments; i++) {
    print_segment(anthy_get_nth_segment(&ac->seg_list, i));
  }
  printf("\n");
}

void
anthy_release_cand_ent(struct cand_ent *ce)
{
  if (ce->elm) {
    free(ce->elm);
  }
  if (&ce->str) {
    anthy_free_xstr_str(&ce->str);
  }
  free(ce);
}

int
anthy_do_set_personality(const char *id)
{
  if (current_personality) {
    /* ǤꤵƤ */
    return -1;
  }
  if (!id || strchr(id, '/')) {
    return -1;
  }
  current_personality = strdup(id);
  anthy_dic_set_personality(current_personality);
  return 0;
}

void
anthy_init_personality(void)
{
  current_personality = NULL;
 #if defined(BENCHMARK)		/* Patched by G-HAL, Sun,21 Aug,2011 */
  total_tod_border.tv_sec  = 0;
  total_tod_border.tv_usec = 0;
  total_tod_candidate.tv_sec  = 0;
  total_tod_candidate.tv_usec = 0;
 #endif
}

void
anthy_quit_personality(void)
{
  if (current_personality) {
    free(current_personality);
    current_personality = NULL;
  }

 #if defined(BENCHMARK)		/* Patched by G-HAL, Sun,21 Aug,2011 */
  anthy_log(1, "Total time of splitter:%11"PRId64".%06"PRId64".\n",
	    (int64_t)(total_tod_border.tv_sec),
	    (int64_t)(total_tod_border.tv_usec)
  );
  anthy_log(1, "Total time of candidate:%11"PRId64".%06"PRId64".\n",
	    (int64_t)(total_tod_candidate.tv_sec),
	    (int64_t)(total_tod_candidate.tv_usec)
  );
 #endif
}
/* vim:ts=8 sw=2 nomodified:
 */
