#if 0		/* Patched by G-HAL */
#include <stdio.h>
#include <string.h>

#include <anthy/diclib.h>
#include <anthy/filemap.h>
#include <anthy/alloc.h>
#include <anthy/conf.h>
#include <anthy/logger.h>
#include "diclib_inner.h"
#else
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if defined(HAVE_STDIO_H)
# include <stdio.h>
#endif
#if defined(HAVE_STRING_H)
# include <string.h>
#endif
#if defined(HAVE_STRINGS_H)
# include <strings.h>
#endif
#if defined(HAVE_ARPA_INET_H)
# include <arpa/inet.h>
#endif
#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif
#if defined(HAVE_NETINET_IN_H)
# include <netinet/in.h>
#endif

#include "anthy/diclib.h"
#include "anthy/filemap.h"
#include "anthy/alloc.h"
#include "anthy/conf.h"
#include "anthy/logger.h"
#include "diclib_inner.h"
#endif

/**
   ʣ󤬥󥯤줿
 */
struct file_dic
{
  struct filemapping *mapping;
};

static struct file_dic fdic;

#if 0	/* Patched by G-HAL, Sat,17 Sep,2011 */
void*
anthy_file_dic_get_section(const char* section_name)
{
  int i;
  char* head = (char*) anthy_mmap_address(fdic.mapping);
  int* p = (int*)head;
  int entry_num = anthy_dic_ntohl(*p++);

  for (i = 0; i < entry_num; ++i) {
    int hash_offset = anthy_dic_ntohl(*p++);
    int key_len =  anthy_dic_ntohl(*p++);
    int contents_offset = anthy_dic_ntohl(*p++);
    if (strncmp(section_name, head + hash_offset, key_len) == 0) {
      return (void*)(head + contents_offset);
    }
  }
  return NULL;
}
#else
void* anthy_file_dic_get_section( const char* const section_name )
{
  char* const head = (char* const) anthy_mmap_address( fdic.mapping );
  const int* p = (const int*)head;
  const int entry_num = ntohl( *p++ );

  int i;
  for (i = 0; i < entry_num; ++i) {
    const int hash_offset     = ntohl( *p++ );
    const int key_len         = ntohl( *p++ );
    const int contents_offset = ntohl( *p++ );
    if (0 == strncmp(section_name, (head + hash_offset), key_len)) {
      return (void*)(head + contents_offset);
    }
  }
  return NULL;
}
#endif

int
anthy_init_file_dic(void)
{
  const char *fn;
  fn = anthy_conf_get_str("DIC_FILE");
  if (!fn) {
    anthy_log(0, "dictionary is not specified.\n");
    return -1;
  }

  /* map */
  fdic.mapping = anthy_mmap(fn, 0);
  if (!fdic.mapping) {
    anthy_log(0, "failed to init file dic.\n");
    return -1;
  }

  return 0;
}

void
anthy_quit_file_dic(void)
{
  anthy_munmap(fdic.mapping);
}

/* vim:ts=8 sw=2 nomodified:
 */
