#ifndef _mkdic_h_included_
#define _mkdic_h_included_

#if 0		/* Patched by G-HAL */
#include <stdio.h>
#include <anthy/xstr.h>
#else
#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDIO_H)
# include <stdio.h>
#endif

#include "anthy/anthy.h"	/* Patched by G-HAL, Mon,08 Jun,2009 */
#include "anthy/xstr.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif


/** ñ */
struct word_entry {
  /** ʻ̾ */
  const char *wt_name;
  /**  */
  int raw_freq;
  int source_order;
  int freq;
  /*  */
  int feature;
  /** ñ */
  char *word_utf8;
  /** եΥեå */
  int offset;
  /** °yomi_entry*/
  struct yomi_entry* ye;
};

/** ɤ */
struct yomi_entry {
  /* ɤߤʸ */
  xstr *index_xstr;
  /* ɤߤʸ(եΥǥå) */
  char *index_str;
  /* եΥڡΥեå */
  int offset;
  /* ƥȥ */
  int nr_entries;
  struct word_entry *entries;
  /**/
  struct yomi_entry *next;
  struct yomi_entry *hash_next;
};

#define YOMI_HASH (16384 * 16)

/*  */
struct yomi_entry_list {
  /* ФΥꥹ */
  struct yomi_entry *head;
  /* եθФο */
  int nr_entries;
  /* ФñĤΤο */
  int nr_valid_entries;
  /* ñο */
  int nr_words;
  /**/
  struct yomi_entry *hash[YOMI_HASH];
  struct yomi_entry **ye_array;
  /**/
 #if !defined(USE_ICONV)	/* Patched by G-HAL, Mon,08 Jun,2009 */
  int index_encoding;
  int body_encoding;
 #else
  enum ANTHY_ENCODING index_encoding;
  enum ANTHY_ENCODING body_encoding;
 #endif
};

#define ADJUST_FREQ_UP 1
#define ADJUST_FREQ_DOWN 2
#define ADJUST_FREQ_KILL 3

/* ѥޥ */
struct adjust_command {
  int type;
  xstr *yomi;
  const char *wt;
  char *word;
  struct adjust_command *next;
};

/**/
extern struct yomi_entry *find_yomi_entry(struct yomi_entry_list *yl,
				   xstr *index, int create);

/* 񤭽ФѤ */
extern void write_nl(FILE *fp, int i);

/**/
extern const char *get_wt_name(const char *name);

/* mkudic.c
 * 㼭 */
#if 0	/* Patched by G-HAL, Sun,18 Oct,2009 */
extern struct uc_dict *create_uc_dict(void);
extern void read_uc_file(struct uc_dict *ud, const char *fn);
extern void make_ucdict(FILE *out, struct uc_dict *uc);
#else
extern struct uc_dict* const init_ucdic( const struct yomi_entry_list* const dic );
# if !defined(USE_ICONV)
extern int parse_ucdic_file( struct uc_dict* const ucdic, FILE* const fp, int input_encoding );
# else
extern int parse_ucdic_file( struct uc_dict* const ucdic, FILE* const fp, enum ANTHY_ENCODING input_encoding );
# endif
extern void write_ucdic( FILE* const out, const struct uc_dict* const ucdic );
#endif
/**/

/* writewords.c */
extern void output_word_dict(struct yomi_entry_list *yl);

/* calcfreq.c */
extern void calc_freq(struct yomi_entry_list *yl);


#ifdef __cplusplus
}
#endif

#endif /* _mkdic_h_included_ */
/* [ End of File ] */
/* vim:ts=8 sw=2 nomodified:
 */
