/**@file
 *			Patches for Anthy, by G-HAL
 *@brief	Anthy Ⱦǡ
 *@date		Thu,21 Aug,2008 - Fri,29 Aug,2008
 *@date		Fri,17 Oct,2008 - Sat,18 Oct,2008
 *@date		Tue,21 Oct,2008 - Thu,23 Oct,2008
 *@date		Tue,28 Oct,2008
 *@date		Fri,31 Oct,2008
 *@date		Sat,01 Nov,2008 - Tue,04 Nov,2008
 *@date		Fri,14 Nov,2008 - Wed,19 Nov,2008
 *@date		Sat,22 Nov,2008, Thu,27 Nov,2008
 *@date		Sat,29 Nov,2008
 *@date		Tue,30 Dec,2008
 *@date		Tue,13 Jan,2009
 *@date		Mon,19 Jan,2009
 *@date		Sat,24 Jan,2009, Sun,25 Jan,2009
 *@date		Mon,26 Jan,2009, Thu,29 Jan,2009
 *@date		Tue,03 Feb,2009, Wed,04 Feb,2009, Fri,06 Feb,2009
 *@date		Sun,08 Feb,2009 - Mon,09 Feb,2009
 *@date		Wed,11 Feb,2009
 *@date		Wed,18 Feb,2009, Sat,21 Feb,2009, Tue,24 Feb,2009, Sat,28 Feb,2009
 *@date		Sat,14 Mar,2009, Wed,25 Mar,2009
 *@date		Sat,18 Apr,2009 - Mon,20 Apr,2009
 *@date		Sat,22 Apr,2009
 *@date		Mon,25 May,2009 - Mon,08 Jun,2009
 *@date		Fri,12 Jun,2009
 *@date		Wed,17 Jun,2009
 *@date		Wed,24 Jun,2009 - Thu,25 Jun,2009
 *@date		Tue,14 Jul,2009
 *@date		Sat,25 Jul,2009
 *@date		Wed,21 Oct,2009 - Thu,22 Oct,2009
 *@date		Sun,25 Oct,2009
 *@date		Wed,04 Nov,2009
 *@date		Sun,08 Nov,2009
 *@date		Tue,10 Nov,2009
 *@date		Thu,12 Nov,2009
 *@date		Sat,14 Nov,2009 - Sun,15 Nov,2009
 *@date		Wed,21 Jul,2010
 *@date		Mon,16 Aug,2010 - Fri,20 Aug,2010
 *@date		Fri,03 Sep,2010
 *@date		Wed,13 Oct,2010 - Thu,14 Oct,2010
 *@date		Sun,31 Jul,2011 - Fri,05 Aug,2011
 *@author	Copyright(C)2008-2011 G-HAL
 */
#ifndef _settings_h_included_
#define _settings_h_included_

#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDLIB_H)
# include <stdlib.h>
#endif
#if !defined(__STDC_LIMIT_MACROS)
# define __STDC_LIMIT_MACROS
#endif
#if !defined(__STDC_CONSTANT_MACROS)
# define __STDC_CONSTANT_MACROS
#endif
#if defined(HAVE_STDINT_H)
# include <stdint.h>
#endif
#if !defined(__STDC_FORMAT_MACROS)
# define __STDC_FORMAT_MACROS
#endif
#if defined(HAVE_INTTYPES_H)
# include <inttypes.h>
#endif
#if defined(HAVE_LIMITS_H)
# include <limits.h>
#endif
#if defined(HAVE_SYS_LIMITS_H)
# include <sys/limits.h>
#endif
#if defined(TIME_WITH_SYS_TIME)
# include <sys/time.h>
# include <time.h>
#else
# if defined(HAVE_SYS_TIME_H)
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif
#if defined(HAVE_SYS_STAT_H)
# include <sys/stat.h>
#endif
#if defined(HAVE_SYS_TYPES_H)
# include <sys/types.h>
#endif

#include "anthy/anthy.h"
#include "anthy/xstr.h"

#ifdef __cplusplus
extern "C" {
#endif


#if !defined(SIZEOF_TIME_T) || (SIZEOF_TIME_T < 8)
	typedef		int64_t		anthy_time_t;
#else
	typedef		time_t		anthy_time_t;
#endif



/** Anthy γؽΥ
 *@note
 *		ե뵭Ͽ anthy_settings_record[] Υ̾
 *		ϿΤǡ֤ϤɤǤ褤
 *		դ˸ȡanthy_settings_record[] 
 *		enum ν˰¸ϹԤʤȡ
 */
enum ANTHY_SECTIONS_ {
	NONE_SECTION,	/**< ʼ */
	EXPANDPAIR,
	UNKNOWN_WORD,
	SUFFIX_HISTORY,
	INDEPPAIR,
	OCHAIRE,
	CAND_HISTORY,
	PREDICTION,
	INDEP_HISTORY,
	DEP_HISTORY,
	PREFIX_HISTORY,
	DATA_SAMPLING,
	ERROR,
	MAX_SECTION		/**< ʼ */
};

#ifdef __cplusplus
inline ANTHY_SECTIONS_& operator ++ ( ANTHY_SECTIONS_& arg )
{
	arg = static_cast<ANTHY_SECTIONS_>(arg + 1);
	return arg;
}

inline ANTHY_SECTIONS_& operator -- ( ANTHY_SECTIONS_& arg )
{
	arg = static_cast<ANTHY_SECTIONS_>(arg - 1);
	return arg;
}
#endif



/** ʸڤΥ⡼
 */
enum ANTHY_LATTICE_MODE_T {
	ANTHY_LATTICE_MODE_VITERBI,				/**< ꥸʥ Anthy ɤʥӥӥ르ꥺˤ뱣ޥ륳եǥѷˡ̵ */
	ANTHY_LATTICE_MODE_MAXLEN_BY_N_PHRASES,	/**< ʸĹסʸ */
	ANTHY_LATTICE_MODE_MANUAL,				/**< ưʸڤԤҲ̾ʸƬ˰̵ */
};

/** ʸڤΥҥƥ󥰤Υ⡼
 */
enum ANTHY_LATTICE_HINTING_T {
	ANTHY_LATTICE_HINTING_NONE,			/**< ҥƥ̵ */
	ANTHY_LATTICE_HINTING_BY_KATAKANA,	/**< ϤʸƬȤߤʤ */
	ANTHY_LATTICE_HINTING_BY_CHARACTER,	/**< ʸʸζڤȤߤʤ */
};



/** Anthy Ⱦǡ */
struct ANTHY_SETTINGS_ {

								/** ܻ */
	xchar	GETA_UCS4;				/**< ѴǽʸʸUCS-4ɽ */

								/** ॹ׾ */
	struct {
		time_t	conffile;			/**< Ķեκɤ߹߸ */
		time_t	initial;			/**< ưΥॹסʽѡ */
		time_t	currentsession;		/**< ߽ѴåΥॹ */
		time_t	lastsession;		/**< Ǹ˳ؽϿॹ */
	} timestamp;

								/** ե롿ǥ쥯ȥ̾ */
	struct {
		char	user_conffile[PATH_MAX];		/**< 桼Ķե */
		char	PathSeparator[PATH_MAX];		/**< ǥ쥯ȥζڤʸ */
		char	user_dir[PATH_MAX];				/**< ե뷲֤ǥ쥯ȥ */
		char	lock_file[PATH_MAX];			/**< åե̾ */
		char	private_dic[PATH_MAX];			/**< Ŀɲü̾ */
		char	private_dic_ext[PATH_MAX];		/**< Ŀɲüγĥ */
		char	imported_words[PATH_MAX];		/**< imported_words ǥ쥯ȥ̾ */
		char	imported_words_ext[PATH_MAX];	/**< imported_words ǥ쥯ȥ̾γĥ */
		char	record1[PATH_MAX];				/**< last-record1_* δ̾ */
		char	record1_bin_ext[PATH_MAX];		/**< last-record1_* ΥХʥγĥ */
		char	record2[PATH_MAX];				/**< last-record2_* δ̾ */
		char	record_ext[PATH_MAX];			/**< last-record?_*  UTF äγĥ */
		char	logfile[PATH_MAX];				/**< ǥХåѥ */
	} filename;

	mode_t	file_umask;				/**< ե°ޥѡߥåΡ黻ʤΤա */

	size_t	recordfile2_limit;		/**< last-record2_* 礭ۤ顢եå夷 last-record1_default إޡ */
	size_t	recordfile1_limit;		/**< last-record1_* 礭ۤ顢ȥߤ */

								/** ƳؽΥҥȾ */
	struct {
		const char* const	name;			/**< ̾ */
		ssize_t				max_entry;		/**< 票ȥʳؽѡ */
		size_t				default_nr_num;	/**< ȥǤɸ५ʹ®ΰ٤ΥԳѡ */
		size_t				inc_nr_num;		/**< ȥǤɸ५ÿʹ®ΰ٤Υѡ */
	} section[MAX_SECTION];

								/** ͤ */
	struct {
		size_t		ochaire_mindepth;			/**< OCHAIREؽκǾʸ */
		size_t		ochaire_maxdepth;			/**< OCHAIREؽκʸ */
		size_t		historyrecord_maxdepth;		/**< ؽκϿ */
	} limit;

								/** ɲõǽ̵ͭ */
	struct {
		int		anonymous;				/**< anonymous ⡼ɡؽκϿڹԤʤ */
		int		proccorpus;				/**< proccorpus ⡼ɡʣ졿Ѥʤ */

		int		enable_error_record;	/**< 顼 last-record* ˵Ͽ(1)(0) */
	  #if defined(USE_ICONV)
		enum ANTHY_ENCODING	encoding;	/**< եȥɥեȤȤϤѤʸ */
		const char*	encoding_name;		/**< եȥɥեȤȤϤѤʸɡ̾ľܻ */
		enum ANTHY_ENCODING	default_eucjp_encoding;	/**< ꤷƤʤ EUC-JP 򡢤ɤηȤư */
	  #else
		int		encoding;				/**< եȥɥեȤȤϤѤʸ(ANTHY_EUC_JP_ENCODING/ANTHY_UTF8_ENCODING) */
	  #endif
		int		reconversion_mode;		/**< ǥեȤεѴ⡼(ANTHY_RECONVERT_AUTO/ANTHY_RECONVERT_DISABLE/ANTHY_RECONVERT_ALWAYS) */

		int		enable_provisional_committed;	/**< β굡ǽͭ(1)̵(0)  */

									/** ľϤ줿Ƥ򻲹;Ȥݻ³뵡ǽ̵ͭ */
		struct {
			int		enable;					/**< ݻǽ̤ͭ(1)̵(0)  */
			int		enable_refer_compound;	/**< ʣѤͭ(1)̵(0)  */
			int		enable_refer_ucdic_for_lattice;		/**< 㼭ʸڤѡˤѤͭ(1)̵(0)  */
			int		enable_refer_ucdic_for_candidate;	/**< 㼭ʸ¤ӽѡˤѤͭ(1)̵(0)  */
			int		enable_refer_ochaire;	/**< OCHAIREؽѤͭ(1)̵(0)  */
			int		enable_refer_corpus;	/**< ѥѤͭ(1)̵(0)  */
			int		enable_learn_ochaire;	/**< OCHAIREؽؤεϿͭ(1)̵(0)  */
		} keepalive;

									/** ؽǽ̵ͭ */
		struct {
			int		enable_autolearn;					/**< uim-1.5.5 ˤɲä줿ʸ졿ʿ̾μưؽͭˤ(1)ݤ(0) */
			int		enable_unlearn;						/**< CAND_HISTORYOCHAIREˤơؽ褦ȤƤȿ¸γؽĴ¸γؽ⤫ä硢¸γؽΥŪ˲ */
			int		enable_release;						/**< OCHAIREˤơؽ褦ȤʸƤ򤵤˺ʬͤʴ¸γؽä硢 */
			int		enable_prediction;					/**< PREDICTIONؽͭ(1)̵(0)  */
			int		enable_candhistory;					/**< CAND_HISTORYؽͭ(1)̵(0)  */
			int		enable_indeppair;					/**< INDEPPAIRؽͭ(1)̵(0)  */
			int		enable_indephistory;				/**< INDEP_HISTORYؽͭ(1)̵(0)  */
			int		enable_dephistory;					/**< DEP_HISTORYؽͭ(1)̵(0)  */
			int		enable_expandpair;					/**< EXPANDPAIRؽͭ(1)̵(0)  */
			int		enable_prefix_history;				/**< PREFIX_HISTORYؽͭ(1)̵(0)  */
			int		enable_suffix_history;				/**< SUFFIX_HISTORYؽͭ(1)̵(0)  */
			int		enable_ochaire1;					/**< ñʸOCHAIREؽͭ(1)̵(0)  */
			int		enable_ochaire1_wo_dep;				/**< °̵ñʸOCHAIREؽͭ(1)̵(0)  */
			int		enable_ochaire2;					/**< Ω졦°դʸOCHAIREؽͭ(1)̵(0)  */
			int		enable_ochaire2_wo_dep;				/**< °̵ʸOCHAIREؽͭ(1)̵(0)  */
			int		enable_ochaire2_wo_indep;			/**< Ω̵ʸOCHAIREؽͭ(1)̵(0)  */
			int		enable_ochaire2_wo_indep_wo_dep;	/**< Ω졦°̵ʸOCHAIREؽͭ(1)̵(0)  */
			int		enable_ochaire3;					/**< Ω졦°դʸʾOCHAIREؽͭ(1)̵(0)  */
			int		enable_ochaire3_wo_dep;				/**< °̵ʸʾOCHAIREؽͭ(1)̵(0)  */
			int		enable_ochaire3_wo_indep;			/**< Ω̵ʸʾOCHAIREؽͭ(1)̵(0)  */
			int		enable_ochaire3_wo_indep_wo_dep;	/**< Ω졦°̵ʸʾOCHAIREؽͭ(1)̵(0)  */
			int		enable_datasampling;				/**< ץǡѥ */
		} learn;
									/** ʸڤ */
		struct {
			enum ANTHY_LATTICE_MODE_T	mode;			/**< ʸڤΥ⡼ */
			enum ANTHY_LATTICE_HINTING_T	hinting;	/**< ʸڤΥҥƥ󥰤Υ⡼ */
			xchar	hinting_character;			/**< ANTHY_LATTICE_HINTING_BY_CHARACTER ǻѤʸ */
			int		with_ochaire_strong;	/**< ʸڤ OCHAIRE ɬ⤯ɾ(1)(0) */
			int		with_ochaire;			/**< ʸڤ OCHAIRE ɾ⤯(1)(0) */
			int		with_candhistory_strong;	/**< ʸڤ CAND_HISTORY ɬ⤯ɾ(1)(0) */
			int		with_candhistory;			/**< ʸڤ CAND_HISTORY ɾ⤯(1)(0) */
			int		with_cand_score;			/**< ʸڤκݤʸδܥȤơñΥѤ(1)ñνм̥OCHAIREݤդˤѤ(0) */
			int		with_candstruct_score;		/**< ʸڤκݤˡ°ˤʸδܥԤ(1)(0) */
			int		with_cand_corpus;			/**< ʸڤκݤˡcand_info ѥˤʸδܥԤ(1)(0)false == with_candstruct_score ξ϶Ū̵ */
			double	corpus_adj_by_count_numerator;		/**< ѥγΨͤʸи͡ʬҡ */
			double	corpus_adj_by_count_denominator;	/**< ѥγΨͤʸи͡ʬ */
			double	biasprob_by_ochaire;		/**< ʸڤˤơOCHAIRE ͳʸܳΨ夲 */
			double	biasscore_by_compound;		/**< ʸڤˤơʣ˳ʸΥ˲û */
			double	biasscore_by_ucdic;			/**< ʸڤˤơ㼭˳ʸΥ˲û */
			double	biasscore_by_ochaire;		/**< ʸڤˤơOCHAIRE ͳʸδܥ˲û */
			double	biasscore_by_learnedfreq;	/**< ʸڤˤơؽ줿ʸΥ˲û */
			double	biasscore_by_dephistory;	/**< ʸڤˤơ°ؽˤäʸΥ˲û */
			int		autoexpand_deps;			/**< °μưĥԤ(1)(0) */
			double	mw_max_score;				/**< mw_score κ͡ʼư׻ưԲġ */
												/** ӥӥ⡼ͭ */
			struct {
				int	with_poisson;					/**< ݥ諒ʬۤѤʸĹˤΨͭˤ(1)(0) */
				double	bias_substitutes_poisson;	/**< ݥ諒ʬۤѤХ */
				int	metaword_effects_sentence;		/**< ñɾʸΤȵڤ(1)(0) */
													/**< ӥӥ⡼ɻΡƬ⤷ʸθ */
				struct {
					int		sw;							/**< ӥӥ⡼ɻˡƬ⤷ʸ(1)(0) */
					double	with_pre_and_post;			/**< ƬξդƤʸθСʸγΨˡʤλ͡ˡ */
					double	with_pre;					/**< ƬΤդƤʸθСʸγΨˡʤλ͡ˡ */
					double	with_post;					/**< ΤդƤʸθСʸγΨˡʤλ͡ˡ */
				} decrease_probability_phrase_with_pre_post;
			} viterbi;
												/** ʸĹץ⡼ͭ */
			struct {
				int		phrases;					/**< ʸ */
				int		phrase_with_pre_post_as_2;	/**< ʸĹץ⡼ɻˡƬξʸ򡢣ʸȿ(1)(0) */
				int		puremode;					/**< ΣʸĹץ르ꥺɤνˤ(1)(0) */
			} maxlen_mode;
		} lattice;

									/** ° */
		struct {
			int		with_xct_symbol;		/**< XCT_SYMBOLʸ°ȤϢ뤹(1)(0) */
			int		with_xct_part;			/**< XCT_PARTʸʤáˤ°ȤϢ뤹(1)(0) */
											/** °ʸ᥹ؤαƶ */
			struct {
				double	decrease_ratio;					/**< ʸṽ¤򲼤Ψ°죱 */
				double	decrease_ratio_by_length;		/**< ʸṽ¤򲼤Ψ°죱ʸ */
				double	decrease_biasratio;				/**< ʸṽ¤򲼤Ψʲط̵Ψ */
				int		decrease_biasratio_threshold;	/**< decrease_biasratio ͭˤ롢°κ */
				int		decrease_score;					/**< ʸṽ¤˲û°죱 */
				int		decrease_biasscore;				/**< ʸṽ¤˲ûʲط̵ */
				int		decrease_biasscore_threshold;	/**< decrease_biasscore ͭˤ롢°κ */
				int		decrease_biasscore_xct_part;	/**< ʻ쥹˲ûXCT_PARTʸʤáˤ°ȤƻѤˡʲط̵ */
				int		increase_biasscore_by_learn;	/**< DEP_HISTORYؽ˥ҥåȤʸṽ¤˲ûʤ * log(1.0 + ޤǤѲ) */
			} score;
		} depgraph;

									/** Ƭ */
		struct {
											/** ʸ᥹ؤαƶ */
			struct {
				double	increase_ratio_by_learn;		/**< ʸ᥹夲 */
			} score;
		} prefix_suffix;

									/** Ѵ */
		struct {
			double	struct_prob_without_corpus;					/**< ѥ˳̵γΨ */
			double	struct_prob_default;						/**< ѥȤʤγΨ */
			int		trim_kana_score;	/**< Ѵˤơʤθ䤬ƬǤʤкǸ˲(1)ƥ༭ɤν֤ˤ(0) */
			int		disable_indepscore_with_prefix_or_postfix;	/**< ΩƬդƤ硢ΩؽŬѤߤ(1)(0) */
			enum {
				CANDIDATE_RENYOU_SCORE_FIRSTWORD,				/**< ƬθưˤΥˤ롣 */
				CANDIDATE_RENYOU_SCORE_LASTWORD,				/**< Ǹθ̾졿ƻˤΥˤ롣 */
				CANDIDATE_RENYOU_SCORE_GEOMETRICMEAN,			/**< ʿѤˤ롣 */
			} renyou_score;									/**< ϢѷʸΥη */
			int		ucdict_score_ratio;						/**< 㼭(udict)ɲå */
			int		udict_corpus_score;						/**< 㼭(corpus)Υ */
		} candidate;

									/** ʸФüɲ */
		struct {
										/** ޤʸؽʤ(1)ؽ(0)cf:src-worddic/exception_word_list.c */
			struct {
				int		indep_history;			/**< INDEPPAIR/INDEP_HISTORY/DEP_HISTORY ˳ؽʤ */
				int		ochaire;				/**< OCHAIRE ˳ؽʤ */
				int		cand_history;			/**< CAND_HISTORY ˳ؽʤ */
				int		prediction;				/**< PREDICTION ˳ؽʤ */
			} exception_word;
			uint16_t	guess;					/**< üե饰ɲáư줿Ǹʸʳʤʸ */
			uint16_t	hiragana;				/**< üե饰ɲáư줿Ҥ餬ʤΤߤʸ */
			uint16_t	katakana;				/**< üե饰ɲáư줿ʤΤߤʸ */
			uint16_t	kigou;					/**< üե饰ɲáư줿εΤߤʸsrc-diclib/xchar.c  half_wide_tab 򻲾ȡ */
			uint16_t	muhenkan;				/**< üե饰ɲáư줿̵Ѵʸ */
			uint16_t	zenhan;					/**< üե饰ɲáư줿ѤȤȾѤؤʪ */
			uint16_t	num_ank;				/**< üե饰ɲáư줿ȾѤο(ANK) */
			uint16_t	num_jis;				/**< üե饰ɲáư줿Ѥο(JIS X 0208 ) */
			uint16_t	num_kansuuzi;			/**< üե饰ɲáư줿 */
			uint16_t	num_separated_ank;		/**< üե饰ɲáư줿ڤ(ANK) */
			uint16_t	num_separated_jis;		/**< üե饰ɲáư줿ڤ(JIS X 0208 ) */
			uint16_t	num_zipcode;			/**< üե饰ɲá͹ֹ漭񤫤Ѵ */
		} extra_flag;
	} anthy_mode;
};

/** Anthy Ⱦǡ */
extern struct ANTHY_SETTINGS_ anthy_settings;



/** ѥ᡼μ */
extern void anthy_init_settings( void );

/** ƥĶμ */
extern void anthy_load_settings_from_systemconf( void );

/** 桼Ķμ */
extern void anthy_load_settings( void );


#ifdef __cplusplus
}
#endif

#endif /* _settings_h_included_ */
/* [ End of File ] */
/* vim:ts=4 sw=4 nomodified:
 */
