/**@file
 *
 *@brief	黻
 *@date		Sat,30 Dec,2006 - Thu,11 Jan,2007
 *@date		Mon,21 Apr,2008
 *@date		Fri,27 Jun,2008
 *@author	Copyright(C)2006-2008 G-HAL. All rights reserved.
 */
#ifndef	_CALCTIME_H_
#define	_CALCTIME_H_

#if defined(HAVE_CONFIG_H)
# include "config.h"
#endif

#if defined(HAVE_STDINT_H)
# include <stdint.h>
#endif
#if defined(HAVE_MATH_H)
# include <math.h>
#endif
#if defined(HAVE_SYS_TIME_H)
# include <sys/time.h>
#endif


#define		TIME_UNIT_MS		INT32_C(1000)
#define		TIME_UNIT_US		INT32_C(1000000)
#define		TIME_UNIT_NS		INT32_C(1000000000)


/** ʲû
 *@param[in,out]	tp			
 */
inline static void NormalizeTime_atAdd( struct timeval* const tp )
{
	const int	adj = (int)(floor((double)(tp->tv_usec) / TIME_UNIT_US));
	if (0 < adj) {
		tp->tv_sec  += adj;
		tp->tv_usec -= (adj * TIME_UNIT_US);
	}
	return;
}

/** ʸ
 *@param[in,out]	tp			
 */
inline static void NormalizeTime_atSub( struct timeval* const tp )
{
	if (tp->tv_usec < 0) {
		const int	adj = - (int)(floor((double)(tp->tv_usec) / TIME_UNIT_US));
		tp->tv_sec  -= adj;
		tp->tv_usec += (adj * TIME_UNIT_US);
	}
	return;
}

/** βû
 *@param[in,out]	src1		浪ӷ̡
 *@param[in]		src2		­
 *@return						ʷ̡
 */
inline static void AddTime( struct timeval* const src1, const struct timeval* const src2 )
{
	src1->tv_sec  += src2->tv_sec;
	src1->tv_usec += src2->tv_usec;
	NormalizeTime_atAdd( src1 );
	return;
}

/** ΰ
 *@param[in,out]	src1		浪ӷ̡
 *@param[in]		src2		
 *@return						ʷ̡
 */
inline static void SubTime( struct timeval* const src1, const struct timeval* const src2 )
{
	src1->tv_sec  -= src2->tv_sec;
	src1->tv_usec -= src2->tv_usec;
	NormalizeTime_atSub( src1 );
	return;
}


#endif	// _CALCTIME_H_
/* [ End of File ] */
