/**
 * @file
 * @brief readconf() 使用サンプル。
 * @author tsntsumi
 * @since v1.0 2013
 */
#include <stdio.h>
#include <stdlib.h>
#include "readconf.h"

RCConfItem SampleConfItems[] =
  {
    { "StringConf", RCValueTypeString, "default string" },
    { "NumberConf", RCValueTypeInteger, "14" },
    { "HexNumberConf", RCValueTypeInteger, "0x0000ffff" },
    { "OctalNumberConf", RCValueTypeInteger, "017" },
    { "RealNumberConf", RCValueTypeReal, "-.987e-1" },
  };

enum SampleConfItemNo
  {
    StringConf = 0,
    NumberConf,
    HexNumberConf,
    OctalNumberConf,
    RealNumberConf,
    NumSampleConfItem
  };

int main(int argc, char *argv[])
{
  if (argc < 1)
    {
      printf("sample CONFFILE...\n");
      exit(EXIT_SUCCESS);
    }
  for (int i = 1; i < argc; i ++)
    {
      readconf(SampleConfItems, ELEMENTSOF(SampleConfItems), argv[i]);
      for (int j = 0; j < RCNumRisedErrors; j ++)
	{
	  printf("%s:%lu: %s\n", 
		 argv[i], RCRisedErrors[j].lineNo, RCRisedErrors[j].reason);
	}
      for (int k = 0; k < ELEMENTSOF(SampleConfItems); k ++)
	{
	  if (SampleConfItems[k].type == RCValueTypeString)
	    {
	      printf("%s: %s = \"%s\" (default:%s)\n",
		     argv[0],
		     SampleConfItems[k].name,
		     SampleConfItems[k].value.string,
		     SampleConfItems[k].defaultValue);
	    }
	  else if (SampleConfItems[k].type == RCValueTypeInteger)
	    {
	      printf("%s: %s = %ld (0x%lx, %03lo) (default:%s)\n",
		     argv[0],
		     SampleConfItems[k].name,
		     SampleConfItems[k].value.integer,
		     SampleConfItems[k].value.integer,
		     SampleConfItems[k].value.integer,
		     SampleConfItems[k].defaultValue);
	    }
	  else if (SampleConfItems[k].type == RCValueTypeReal)
	    {
	      printf("%s: %s = %g (default:%s)\n",
		     argv[0],
		     SampleConfItems[k].name,
		     SampleConfItems[k].value.real,
		     SampleConfItems[k].defaultValue);
	    }
	}
      RCFreeStringValueInItems(SampleConfItems, ELEMENTSOF(SampleConfItems));
      RCFreeRisedErrors();
    }
  return EXIT_SUCCESS;
}
