﻿//
//  BroadcastUdpServer.cs
//
//  Author:
//       tsntsumi <tsntsumi at tsntsumi.com>
//
//  Copyright (c) 2015 tsntsumi
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU Lesser General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.

/// @file
/// <summary>
/// Broadcast UDP server.
/// </summary>
/// @since 2015.8.20
using System;
using System.Net;
using System.Net.Sockets;

namespace SocketNet
{
	/// <summary>
	/// UDP Broadcast server.
	/// </summary>
	public class UdpBroadcastServer: UdpServer
	{
		/// <summary>
		/// コンストラクタ。
		/// </summary>
		/// <param name="port">バインドするポート番号。</param>
		public UdpBroadcastServer(int port)
			: base(IPAddress.Any, port, TransmissionType.Broadcast)
		{
		}
	}
}

