﻿// Program.cs
//
// Author:
// tsntsumi <tsntsumi at tsntsumi.com>
//
// Copyright (c) 2015 tsntsumi
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.

/// @file
/// <summary>
/// SocketNet ライブラリのサンプルプログラム (GTK# ベースの簡単なチャットクライアント)。
/// </summary>
/// @since 2015.8.14
using System;
using Gtk;

/// <summary>
/// SocketNet ライブラリのサンプルプログラム (GTK# ベースの簡単なチャットクライアント)。
/// </summary>
namespace SampleChatGtkClient
{
	/// <summary>
	/// SocketNet ライブラリのサンプルプログラム (GTK# ベースの簡単なチャットクライアント)。
	/// </summary>
	/// <remarks>
	/// Mac のターミナルから実行するには:
	/// <code>
	/// DYLD_FALLBACK_LIBRARY_PATH=/Library/Frameworks/Mono.framework/Versions/Current/lib:/usr/lib mono SampleChatGtkClient.exe
	/// </code>
	/// のようにします。
	/// </remarks>
	class MainClass
	{
		/// <summary>
		/// チャットクライアントプログラムのエントリポイント。
		/// </summary>
		public static void Main()
		{
			Application.Init();
			MainWindow win = new MainWindow();
			win.Show();
			Application.Run();
		}
	}
}
