﻿// ChatMessageReceivedEventArgs.cs
//
// Author:
// tsntsumi <tsntsumi at tsntsumi.com>
//
// Copyright (c) 2015 tsntsumi
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public License
//	along with this program.  If not, see <http://www.gnu.org/licenses/>.

/// @file
/// <summary>
/// チャットメッセージ庾信イベントのデータ。
/// </summary>
/// @since 2015.8.14
using System;
using SocketNet;

namespace SampleChatClient
{
	/// <summary>
	/// チャットメッセージ受信イベントのデータ。
	/// </summary>
	public class ChatMessageReceivedEventArgs
	{
		/// <summary>
		/// 関連付けられたチャットメセージを取得します。
		/// </summary>
		public ChatMessage ChatMessage { get; private set; }

		/// <summary>
		/// コンストラクタ。
		/// </summary>
		/// <param name="chatMessage">チャットメッセージ。</param>
		public ChatMessageReceivedEventArgs(ChatMessage chatMessage)
		{
			ChatMessage = chatMessage;
		}
	}
}

