using System;
using System.Collections.Generic;
using System.Text;

using System.Diagnostics;

using System.Threading;
using System.Net;
using System.Net.Sockets;
using System.IO;
using System.Xml.Serialization;

namespace LocalMessenger
{
    delegate void NotifiedHandler(Member member);
    
    class Notifier
    {
        public event NotifiedHandler notified;  // M̃Cxg

        private UdpClient client;               // Ԓʒmp UDP NCAg
        private XmlSerializer serializer;       // Ԃ̃VACU
        private Notice notice;                  // Ԓʒmp̃f[^
        private Thread thread;                  // ԊǗp̃Xbh
        private Int32 port;                     // ԒʒmɎg|[gԍ
        private IPAddress localhost;            //  IP AhX

        public Notifier(Member user)
        {
            try
            {
                port = Properties.Settings.Default.PortNumber;
            } catch (NullReferenceException) {
                Properties.Settings.Default.PortNumber = Manager.DefaultPort;
                port = Properties.Settings.Default.PortNumber;
            }

            localhost = NetAdapter.GetAddress();
            IPEndPoint endPoint = new IPEndPoint(localhost, port);
            client = new UdpClient(endPoint);

            serializer = new XmlSerializer(typeof(Notice));
            notice = new Notice();
            notice.Member = user;
        }

        public void Start()
        {
            thread = new Thread(listen);
            thread.Start();
        }

        public void Stop()
        {
            client.Close();
            thread.Abort();
        }

        private void Notify(IPAddress address, Notice.Type type)
        {
            try
            {
                using (MemoryStream stream = new MemoryStream())
                {
                    notice.Tag = type;
                    serializer.Serialize(stream, notice);

                    byte[] sendBytes = new byte[stream.Length];
                    stream.Seek(0, SeekOrigin.Begin);
                    int count = stream.Read(sendBytes, 0, (int)stream.Length);
#region
                    string debug = string.Format
                    (
                        "[Send]\t{0}:{1:00000}", address.ToString(), port
                    );

                    Debug.WriteLine(debug);
                    Debug.WriteLine(Encoding.UTF8.GetString(sendBytes));
#endregion
                    client.Send(sendBytes, count, address.ToString(), port);
                }   // stream IuWFNg𖾎Iɔj
            }
            catch (SocketException exception)
            {
                Debug.WriteLine("Notifier [Send]: " + exception.ToString());
            }
        }

        public void Broadcast()
        {
            Notify(IPAddress.Broadcast, Notice.Type.BROADCAST);
        }

        private void listen()
        {
            Notice notice;
            IPEndPoint endPoint = new IPEndPoint(IPAddress.Any, port);
            endPoint.Address = IPAddress.Any;

            // Ԃu[hLXg
            Notify(IPAddress.Broadcast, Notice.Type.BROADCAST);

            // ̐l̏ԒʒmM
            while (true)
            {
                try
                {
                    byte[] receiveBytes = client.Receive(ref endPoint);
                    bool me = false;

                    if (endPoint.Address.Equals(localhost))
                        me = true;

#region
                    byte[] ip = endPoint.Address.GetAddressBytes();
                    string debug = string.Format
                    (
                        "[Recv]\t{0:000}.{1:000}.{2:000}.{3:000}:{4:00000}",
                        ip[0], ip[1], ip[2], ip[3], endPoint.Port
                    );
                    Debug.WriteLine(debug);
                    Debug.WriteLine(Encoding.UTF8.GetString(receiveBytes));
#endregion
                    using (MemoryStream stream = new MemoryStream(receiveBytes))
                    {
                        notice = (Notice)serializer.Deserialize(stream);
                    }   // stream IuWFNg𖾎Iɔj

                    notice.Member.Address = endPoint.Address.ToString();

                    if (notified != null)
                        notified(notice.Member);

                    if (!me)
                    {   // ȊÕu[hLXgMԐM
                        if (notice.Tag == Notice.Type.BROADCAST)
                            Notify(endPoint.Address, Notice.Type.NOTIFY);
                    }
                }
                catch (SocketException exception)
                {
                    Debug.WriteLine("Notifier [Recv]: " + exception.ToString());
                    continue;
                }
            }
        }
    }
}
