using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

using System.Diagnostics;

using System.Runtime.InteropServices;
using System.IO;

namespace LocalMessenger
{
    public partial class Messenger : Form
    {
        [DllImport("USER32.dll")]

        private static extern IntPtr SendMessage(IntPtr hWnd, int msg, int wp, out Point lp);
        private const int EM_GETSCROLLPOS = 0x04DD;
        private const int EM_SETSCROLLPOS = 0x04DE;

        private List<FileButton> buttonList = new List<FileButton>();

        public static string GetFileName(string path)
        {
            int index = path.LastIndexOf('\\');
            return path.Substring(index + 1);
        }

        private int GetCurrentPos()
        {
            Point pt;
            SendMessage(messageLog.Handle, EM_GETSCROLLPOS, 0, out pt);
            return pt.Y;
        }

        private void messageLog_VScroll(object sender, EventArgs e)
        {
            // List ̃{^SĂ炷
            int dy = GetCurrentPos();
            foreach (FileButton button in buttonList)
            {
                button.SetButtonPos(dy);
            }
        }

        public void AddFileButton(Member member, List<string> paths)
        {
            // ݂̈ʒu̎擾
            int index = messageLog.SelectionStart;
            Point pt = messageLog.GetPositionFromCharIndex(index);
            int dy = pt.Y + GetCurrentPos();
            FileButton button = new FileButton(manager, member, paths, pt.X, dy);
            buttonList.Add(button);
            messageLog.Controls.Add(button.Button);
            messageLog.AppendText("\r\n");
            // t@C̒ǉ
            int num = 0;
            foreach (string path in paths)
            {
                if (num++ > 0)
                    messageLog.AppendText(", ");

                messageLog.AppendText(GetFileName(path));
            }
            messageLog.AppendText("\r\n");
        }
    }
}

// 
