using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Diagnostics;

using System.Net;
using System.Net.Sockets;
using System.Security.Cryptography;

namespace LocalMessenger
{
    public delegate void UpdatedHandler(List<ContactMember> list);

    public partial class Manager : Form
    {
        public event UpdatedHandler updated;

        public const Int32 DefaultPort = 9991;   // ftHg|[g9991H

        delegate void NotifierHandler(Member member);
        delegate TcpClient InviteHandler(Member member, List<Member> list);

        // o[̏ԕύX郁\bh
        private void Notified(Member member)
        {
            NotifierHandler d = new NotifierHandler(updateMemberList);
            this.Invoke(d, new object[] { member });
        }

        // ̃o[ڑꂽꍇɃR}h郁\bh
        private void Connected(Command command, TcpClient client)
        {
            CommandHandler d = new CommandHandler(procedure);
            this.Invoke(d, new object[] { command, client });
        }

        // ݒύX𔽉f郁\bh
        private void Configured(bool restart)
        {
            ConfiguredHandler d = new ConfiguredHandler(updateConfig);
            this.Invoke(d, new object[] {restart});
        }

        // ̏
        private Member user;
        public Member User
        {
            get { return user; }
        }

        // lbg[N̎擾o[̃Xg
        private List<ContactMember> memberList = new List<ContactMember>();
        public List<ContactMember> MemberList
        {
            get { return memberList; }
        }

        private Notifier notifier;      // ԕύXʒm
        private Commander commander;    // R}h
        private IdleChecker idle;       // AChԌm

        // JĂ郁bZW[̃Xg
        private List<Messenger> chatWindowList;

        // ʌp RSA T[rXvoC_
        private RSACryptoServiceProvider rsa;
        public RSACryptoServiceProvider Rsa
        {
            get { return rsa; }
        }

        // ÍʐMɎg AES 
        private RijndaelManaged aes;

        ///<summary>
        ///o[Xgɂ郁o[̃CX^X𓾂
        ///</summary>
        public Member GetMember(string username, string address)
        {   // o[XgɃ[U[ IP AhXvGg
            // 炻̒̃o[Ԃ
            foreach (ContactMember contact in memberList)
                if (contact.Member.Name.Equals(username) &&
                    contact.Member.Address.Equals(address))
                    return contact.Member;

            if (User.Name.Equals(username))
            {   // g擾悤ƂĂꍇ
                if (User.Address == null)
                {    
                    IPAddress ip = NetAdapter.GetAddress();
                    if (ip.ToString() == address)
                       return user;
                }
                else
                {
                    if (User.Address.Equals(address))
                        return user;
                }
            }

            return null;
        }

        // o[̃CX^X𓾂
        public ContactMember GetContact(string username, string address)
        {   // o[XgɃ[U[ IP AhXvGg
            // 炻Ԃ

            foreach (ContactMember contact in memberList)
                if (contact.Member.Name.Equals(username) &&
                    contact.Member.Address.Equals(address))
                    return contact;

            return null;
        }

        private void initializeProperties()
        {
            if (Properties.Settings.Default.NickName.Trim() == "")
                Properties.Settings.Default.NickName = Environment.UserName;

            if (Properties.Settings.Default.Folder.Trim() == "")
                Properties.Settings.Default.Folder = Environment.CurrentDirectory;
        }

        public Manager()
        {
            InitializeComponent();
            InitializeListView();

            initializeProperties();

            // ACh`FbJ̏
            idle = new IdleChecker();

            // JĂ郁bZW[̃Xg̏
            chatWindowList = new List<Messenger>();

            // ̏̏
            user = new Member();

            user.Name = Environment.UserName;
            user.Machine = Environment.MachineName;
//            user.Status = Member.State.ONLINE;
            ICToolStripMenuItem.Checked = true;

            // jbNl[ݒ肳ĂȂ̓[U[ݒ
            if (Properties.Settings.Default.NickName != "")
                user.NickName = Properties.Settings.Default.NickName;
            else
                user.NickName = Environment.UserName;

            // Õ𕜌
            user.Memo = Properties.Settings.Default.Memo;
            this.memo.Text = user.Memo;

            // ȌԂ𕜌
            user.Status = (Member.State)Properties.Settings.Default.Status;

            // RSA ̐
            CspParameters@CSPParam = new CspParameters();
            CSPParam.Flags = CspProviderFlags.UseMachineKeyStore;
            rsa = new RSACryptoServiceProvider(CSPParam);
            user.PublicKey = rsa.ExportParameters(false);

            // AES ̐
            aes = new RijndaelManaged();

            // }l[W[EBhE̖Oݒ
            this.Text = user.NickName + " (" + user.Name + "@" + user.Machine + ")";

            // R}hMIuWFNg̏
            commander = new Commander(this);
            commander.received += new CommandHandler(Connected);
            commander.Start();

            // o[̏Ԏ擾IuWFNg̏
            notifier = new Notifier(User);
            notifier.notified += new NotifiedHandler(Notified);
            notifier.Start();

            // AChԌmIuWFNg̏
            idle.running += new RunningHandler(idleState);
            idle.Run(12 * 1000);          // Ƃ肠12bƂɒׂ
        }

        private void updateMemberList(Member update)
        {
            ContactMember contact = GetContact(update.Name, update.Address);

            // VKo[o[Xgɒǉ
            if (contact == null)
                memberList.Add(new ContactMember(this, update));
            else
                update.CopyTo(contact.Member);

            UpdateListView();

            if (updated != null)
                updated(MemberList);
        }

        private void updateConfig(bool restart)
        {
            if (restart)
            {
                this.restart();
            }
            else
            {
                user.NickName = Properties.Settings.Default.NickName;
                notifier.Broadcast();
            }

            // }l[W[EBhE̖Oݒ
            this.Text = user.NickName + " (" + user.Name + "@" + user.Machine + ")";
        }

        private void idleState(bool state)
        {
            if (state)
            {   // XN[Z[o[Ă鎞
                if (user.Status == Member.State.ONLINE)
                {   // ICԂAChԂɂ
                    user.Status = Member.State.IDLE;
                    notifier.Broadcast();
                }
            }
            else
            {   // XN[Z[o[ĂȂ
                if (user.Status == Member.State.IDLE)
                {   // AChԂICԂɂ
                    user.Status = Member.State.ONLINE;
                    notifier.Broadcast();
                }
            }
        }

        private void finish()
        {
            managerIcon.Visible = false;

            // Ԃ̕ۑ
            Properties.Settings.Default.Status = (int)user.Status;
            Properties.Settings.Default.Memo = user.Memo;
            Properties.Settings.Default.Save();

            user.Status = Member.State.OFFLINE;            // Iʒm
            notifier.Broadcast();

            notifier.Stop();
            commander.Stop();

            Environment.Exit(0);
        }

        private void restart()
        {
            // Ԃ̕ۑ
            Properties.Settings.Default.Status = (int)user.Status;
            Properties.Settings.Default.Memo = user.Memo;
            Properties.Settings.Default.Save();

            user.Status = Member.State.OFFLINE;            // Iʒm
            notifier.Broadcast();

            notifier.Stop();
            commander.Stop();

            // ȌԂ𕜌
            user.Status = (Member.State)Properties.Settings.Default.Status;
            user.Address = null;

            // R}hMIuWFNg̏
            commander = new Commander(this);
            commander.received += new CommandHandler(Connected);
            commander.Start();

            // o[̏Ԏ擾IuWFNg̏
            notifier = new Notifier(user);
            notifier.notified += new NotifiedHandler(Notified);
            notifier.Start();
        }

        private void connect()
        {
            if (listView.SelectedItems.Count != 0)
            {
                List<Member> list = new List<Member>();

                foreach (ListViewItem item in listView.SelectedItems)
                {
                    Member member = (Member)item.Tag;
                    list.Add(GetMember(member.Name, member.Address));
                }

                Connect(list);
            }
        }
    }
}
