using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace LocalMessenger
{
    public partial class TransferWindow : Form
    {
        private FileTransfer transfer;
        
        public TransferWindow(FileTransfer transfer)
        {
            InitializeComponent();

            this.transfer = transfer;
        }

        private void button_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        public int FileLength
        {
            get { return progressFile.Value; }
            set { progressFile.Maximum = value; }
        }

        public int TotalLength
        {
            get { return progressTotal.Maximum; }
            set { progressTotal.Maximum = value; }
        }

        public int FileProgress
        {
            get { return progressFile.Value; }
            set { progressFile.Value = value; }
        }

        public int TotalProgress
        {
            get { return progressTotal.Value; }
            set { progressTotal.Value = value; }
        }

        public string Filename
        {
            get { return filename.Text; }
            set { filename.Text = value; }
        }

        public string Total
        {
            get { return total.Text; }
            set { total.Text = value; }
        }
    }
}