using System;
using System.Collections.Generic;
using System.Text;

using System.IO;
using System.Threading;
using System.Net.Sockets;
using System.Security.Cryptography;

namespace LocalMessenger
{
    public delegate void TransferHandler(List<Member> member, string text);

    public class FileTransfer
    {
        private TcpClient client;
        private List<Member> member;
        private byte[] key;
        private byte[] iv;
        private RijndaelManaged aes;
        private TransferWindow info;
        public event TransferHandler transferred;    // M̃Cxg

        // t@C]NX
        public FileTransfer(Command command, TcpClient client)
        {
            this.client = client;
            this.key    = command.Key;
            this.iv     = command.IV;
            this.member = command.With;

            aes = new RijndaelManaged();
        }

        // t@C̎MXbh
        public void ReceiveFiles(List<TargetFile> files)
        {
            Thread thread = new Thread(receive);
            thread.Start(files);
        }

        // t@C̑MXbh
        public void SendFiles(List<string> files)
        {
            Thread thread = new Thread(send);
            thread.Start(files);
        }

        // t@C̎M
        private void receive(object param)
        {
            List<TargetFile> files = (List<TargetFile>)param;

            NetworkStream ns = client.GetStream();
            BufferedStream bs = new BufferedStream(ns);
            ICryptoTransform transform = aes.CreateDecryptor(key, iv);
            CryptoStream cs =
                new CryptoStream(bs, transform, CryptoStreamMode.Read);

            info = new TransferWindow(this);
            info.Text = "t@CMc";
            info.Filename = "";
            info.TotalLength = files.Count;
            info.Total = string.Format("(0/{0})", files.Count);
            info.Show();
            info.Activate();

            int total = 0;              // Mς݃t@C

            foreach (TargetFile file in files)
            {
                string fileName = Messenger.GetFileName(file.Name);
                string path = Properties.Settings.Default.Folder +
                    Path.DirectorySeparatorChar.ToString() + fileName;
                FileStream fs = new FileStream(path, FileMode.Create);

                byte[] buf = new byte[4096];    // Ƃ肠 4096 oCg
                long remain = file.Length;
                int offset = 0;
                int count;

                info.Filename = fileName; // t@Ĉݕ\
                info.FileLength = (int)remain;
                info.Total = string.Format("({0}/{1})", total, files.Count);
                info.Update();          // EBhE̍XV

                while (remain > 0)
                {
                    if (remain > buf.Length)
                        count = cs.Read(buf, 0, buf.Length);
                    else
                        count = cs.Read(buf, 0, (int)remain);

                    fs.Write(buf, 0, count);
                    offset += count;
                    remain -= count;
                    info.FileProgress = offset;
                }

                fs.Close();
                info.TotalProgress = ++total;
                if (transferred != null)
                {
                    transferred(member, string.Format(
                        "  -- {0}M܂B--  \r\n",fileName));
                }
            }

            cs.Close();
            info.Close();
        }

        // t@C̑M
        private void send(object param)
        {
            List<string> files = (List<string>)param;

            // Ƃ肠肩Ԏ܂őҋ@


            NetworkStream ns = client.GetStream();
            BufferedStream bs = new BufferedStream(ns);
            ICryptoTransform transform = aes.CreateEncryptor(key, iv);
            CryptoStream cs =
                new CryptoStream(bs, transform, CryptoStreamMode.Write);

            info = new TransferWindow(this);
            info.Text = "t@C𑗐Mc";
            info.Filename = "";
            info.TotalLength = files.Count;
            info.Total = string.Format("(0/{0})", files.Count);
            info.Show();
            info.Activate();

            int total = 0;              // Mς݃t@C

            foreach (string file in files)
            {
                FileStream fs =
                    new FileStream(file, FileMode.Open, FileAccess.Read, FileShare.Read);

                byte[] buf = new byte[4096];    // Ƃ肠 4096 oCg
                long remain = fs.Length;
                int offset = 0;
                int count;

                info.Filename = fs.Name;
                info.FileLength = (int)remain;
                info.Total = string.Format("({0}/{1})", total, files.Count);
                info.Update();          // EBhE̍XV

                while (remain > 0)
                {
                    if (remain > buf.Length)
                        count = fs.Read(buf, 0, buf.Length);
                    else
                        count = fs.Read(buf, 0, (int)remain);

                    cs.Write(buf, 0, count);
                    offset += count;
                    remain -= count;
                    info.FileProgress = offset;
                }

                fs.Close();
                info.TotalProgress = ++total;
            }

            cs.FlushFinalBlock();
            cs.Close();
            info.Close();
        }
    }
}
