using System;
using System.Collections.Generic;
using System.Text;

using Eyes.Properties;

using System.Diagnostics;

using System.Threading;
using System.Net;
using System.Net.Sockets;
using System.IO;
using System.Xml.Serialization;

namespace Eyes
{
    delegate void NotifiedHandler(Member member);
    
    class Notifier
    {
        public event NotifiedHandler notified;  // M̃Cxg

        private UdpClient client;               // Ԓʒmp UDP NCAg
        private XmlSerializer serializer;       // Ԃ̃VACU
        private Member user;                    // Ԓʒmp̎̏
        private Thread thread;                  // ԊǗp̃Xbh
        private Int32 port;                     // ԒʒmɎg|[gԍ
        private IPAddress localhost;            //  IP AhX

        public Notifier(Member user)
        {
            try
            {
                port = Settings.Default.PortNumber;
            } catch (NullReferenceException) {
                Settings.Default.PortNumber = Manager.DefaultPort;
                port = Settings.Default.PortNumber;
            }

            this.user = user;
            serializer = new XmlSerializer(typeof(Notice));

            localhost = NetAdapter.GetAddress();
            IPEndPoint endPoint = new IPEndPoint(localhost, port);
            client = new UdpClient(endPoint);
            user.Address = endPoint.Address.ToString();
        }

        public void Start()
        {
            thread = new Thread(listen);
            thread.Start();
        }

        public void Stop()
        {
            thread.Abort();
            client.Close();
        }

        private void Notify(IPAddress address, Notice.Type type)
        {
            try
            {
                using (MemoryStream stream = new MemoryStream())
                {
                    Notice notice = new Notice();
                    notice.CopyFrom(user);
                    notice.Tag = type;
                    serializer.Serialize(stream, notice);

                    byte[] sendBytes = new byte[stream.Length];
                    stream.Seek(0, SeekOrigin.Begin);
                    int count = stream.Read(sendBytes, 0, (int)stream.Length);
#region
                    string debug = string.Format
                    (
                        "[Send]\t{0}:{1:00000}", address.ToString(), port
                    );

                    Debug.WriteLine(debug);
                    Debug.WriteLine(Encoding.UTF8.GetString(sendBytes));
#endregion
                    client.Send(sendBytes, count, address.ToString(), port);
                }   // stream IuWFNg𖾎Iɔj
            }
            catch (SocketException exception)
            {
                Debug.WriteLine("Notifier [Send]: " + exception.ToString());
            }
        }

        public void Broadcast()
        {
            Notify(IPAddress.Broadcast, Notice.Type.BROADCAST);
        }

        private void listen()
        {
            Notice notice;
            IPEndPoint endPoint = new IPEndPoint(IPAddress.Any, port);
            endPoint.Address = IPAddress.Any;

            // Ԃu[hLXg
            Notify(IPAddress.Broadcast, Notice.Type.BROADCAST);

            // ̐l̏ԒʒmM
            while (true)
            {
                try
                {
                    byte[] receiveBytes = client.Receive(ref endPoint);
                    bool me = false;

                    if (endPoint.Address.Equals(localhost))
                        me = true;
#region
                    byte[] ip = endPoint.Address.GetAddressBytes();
                    string debug = string.Format
                    (
                        "[Recv]\t{0:000}.{1:000}.{2:000}.{3:000}:{4:00000}",
                        ip[0], ip[1], ip[2], ip[3], endPoint.Port
                    );
                    Debug.WriteLine(debug);
                    Debug.WriteLine(Encoding.UTF8.GetString(receiveBytes));
#endregion
                    using (MemoryStream stream = new MemoryStream(receiveBytes))
                    {
                        notice = (Notice)serializer.Deserialize(stream);
                    }   // stream IuWFNg𖾎Iɔj

                    notice.Address = endPoint.Address.ToString();

                    if ((me == false) && (notified != null))
                        notified(notice);

                    if (!me)
                    {   // ȊÕu[hLXgMԐM
                        if (notice.Tag == Notice.Type.BROADCAST)
                            Notify(endPoint.Address, Notice.Type.NOTIFY);
                    }
                }
                catch (SocketException e)
                {
                    Debug.WriteLine("Notifier [Recv]: " + e.ToString());
                }
                catch (Exception e)
                {
                    Debug.WriteLine("Notifier [Recv]: " + e.ToString());
                }
            }
        }
    }
}
