using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Eyes.Properties;

using System.Diagnostics;
using System.Net.Sockets;

namespace Eyes
{
    public partial class Manager : Form
    {
        private List<History> balloonMessage = new List<History>(); 

        private void addHistory(string message)
        {
            History history = new History();
            history.Time = DateTime.Now;
            history.Message = message;

            if (balloonMessage.Count > 5)
            {
                balloonMessage.Sort
                (
                    delegate(History a, History b)
                    {
                        TimeSpan total = (a.Time - b.Time);

                        return (int)total.TotalSeconds;
                    }
                );

                balloonMessage.RemoveAt(0);
            }

            balloonMessage.Add(history);
        }

        private string getHistory()
        {
            string message = "";

            foreach (History history in balloonMessage)
            {
                TimeSpan span = (DateTime.Now - history.Time);
                // Settings.Default.Balloon bȏoĂ\Ȃ
                if (span.TotalSeconds > Settings.Default.Balloon)
                    continue;

                message += history.Time.ToString("[HH:mm] ");
                message += (history.Message + "\n");
            }

            return message;
        }

        // o[\
        private void showBalloonTip(String message)
        {
            addHistory(message);

            managerIcon.BalloonTipTitle = "Eyes";
            managerIcon.BalloonTipText = getHistory();
            managerIcon.BalloonTipIcon = ToolTipIcon.Info;
            //\鎞Ԃ~bŎw肷
            if (Settings.Default.Balloon != 0)
                managerIcon.ShowBalloonTip(Settings.Default.Balloon * 1000);
        }

        private void LocalMessenger_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (e.CloseReason == CloseReason.UserClosing)
            {
                e.Cancel = true;
                this.Visible = false;
            }
            else
            {
                finish();
            }
        }

        private void managerIcon_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            this.Visible = true;

            if (this.WindowState == FormWindowState.Minimized)
                this.WindowState = FormWindowState.Normal;

            this.Activate();
        }

        private void update()
        {
            user.Memo = memo.Text;

            if (memo.Items.Contains(memo.Text))
                memo.Items.Remove(memo.Text);

            memo.Items.Insert(0, memo.Text);

            notifier.Broadcast();
            updateButton.Focus();
            updateListView();
        }

        private void Memo_KeyPress(object sender, KeyPressEventArgs e)
        {
            //EnterEscapeL[Ńr[vȂ悤ɂ
            if (e.KeyChar == (char)Keys.Enter)
            {
                e.Handled = true;
                update();
            }
            
            if (e.KeyChar == (char)Keys.Escape)
            {
                e.Handled = true;
                memo.Text = user.Memo;
            }
        }

        private void wvToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Help.ShowHelp(this, "LocalMessenger.chm");
        }

        private void UpdateButton_Click(object sender, EventArgs e)
        {
            update();
        }

        private void ̏ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            memo.Items.Clear();
        }

        private void managerIcon_BalloonTipClicked(object sender, EventArgs e)
        {
            this.Activate();
        }

        private void O[vXgToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ToolStripMenuItem item = (ToolStripMenuItem)sender;
            splitContainer.Panel1Collapsed = !splitContainer.Panel1Collapsed;
            item.Checked = !splitContainer.Panel1Collapsed;
        }

        private void groupToolStripMenuItem_Click(object sender, EventArgs e)
        {
            foreach (ToolStripMenuItem item in O[vXgToolStripMenuItem.DropDownItems)
            {
                item.Checked = (item == (ToolStripMenuItem)sender) ? true : false;

                if (item.Checked)
                    foreach (Group group in groupList)
                        if (group.Name == item.Text)
                            this.group = group;
            }

            updateTreeView();
        }

        private void listMenuUp_Click(object sender, EventArgs e)
        {
            if (listView.Items == null)
                return;

            // i = 0 ͎Ŏ͏Ɉԏɕ\
            // i = 1 IĂ炻ȏɂ͈ړłȂ̂ŕԂ
            if (listView.Items[1].Selected)
                return;

            for (int i = 2; i < listView.Items.Count; i++)
                if (listView.Items[i].Selected)
                {
                    int index = (i - 1);
                    ContactMember member = group.Members[index];
                    group.Members.RemoveAt(index);
                    group.Members.Insert(index - 1, member);
                }

            updateListView();
            updateGroupNode(group.Name);
        }

        private void listMenuDown_Click(object sender, EventArgs e)
        {
            if (listView.Items == null)
                return;

            int lastIndex = (listView.Items.Count - 1);

            // i = 0 ͎Ŏ͏Ɉԏɕ\
            // ŌオIĂ炻ȏ㉺ɂ͈ړłȂ̂ŕԂ
            if (listView.Items[lastIndex].Selected)
                return;

            for (int i = lastIndex; i > 0; i--)
                if (listView.Items[i].Selected)
                {
                    int index = (i - 1);
                    ContactMember member = group.Members[index];
                    group.Members.RemoveAt(index);
                    group.Members.Insert(index + 1, member);
                }

            updateListView();
            updateGroupNode(group.Name);
        }

        private void treeMenuUp_Click(object sender, EventArgs e)
        {
            // O[ṽm[hIĂ鎞Ȃ͂ǔÔ
            TreeNode node = treeView.SelectedNode;

            if (node.Tag.GetType() != typeof(Group))
                return;

            Group group = (Group)node.Tag;
            int index = groupList.IndexOf(group);
            groupList.Remove(group);
            groupList.Insert(index - 1, group);
            delGroupFromTree(group);
            insertGroupToTree(index - 1, group);
        }

        private void treeMenuDown_Click(object sender, EventArgs e)
        {
            // O[ṽm[hIĂ鎞Ȃ͂ǔÔ
            TreeNode node = treeView.SelectedNode;

            if (node.Tag.GetType() != typeof(Group))
                return;

            Group group = (Group)node.Tag;
            int index = groupList.IndexOf(group);
            groupList.Remove(group);
            groupList.Insert(index + 1, group);
            delGroupFromTree(group);
            insertGroupToTree(index + 1, group);
        }

        private void treeMenuRename_Click(object sender, EventArgs e)
        {
            Group group = (Group)treeView.SelectedNode.Tag;
            FormGroupName dialog = new FormGroupName(groupList);
            dialog.Text = "O[v̕ύX";
            dialog.Label = "ύX̃O[v";
            dialog.Button = "ύX";
            dialog.GroupName = group.Name;
            DialogResult result = dialog.ShowDialog();

            if (result == DialogResult.OK)
            {
                group.Name = dialog.GroupName;
                treeView.SelectedNode.Text = dialog.GroupName;
                updateGroupNode(group.Name);
            }
        }
    }
}
