using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Eyes.Properties;

using System.Diagnostics;

using System.Net;
using System.Net.Sockets;
using System.Security.Cryptography;

namespace Eyes
{
    public delegate void UpdatedHandler(List<ContactMember> list);

    public partial class Manager : Form
    {
        public const Int32 DefaultPort = 9991;   // ftHg|[g9991H
        public const Int32 GROUP_ALL = 0;
        public const string GroupAll = "S";

        delegate void NotifierHandler(Member member);

        // o[̏ԕύX郁\bh
        private void Notified(Member member)
        {
            NotifierHandler d = new NotifierHandler(updateMemberList);
            this.Invoke(d, new object[] { member });
        }

        // ݒύX𔽉f郁\bh
        private void Configured(bool restart)
        {
            ConfiguredHandler d = new ConfiguredHandler(updateConfig);
            this.Invoke(d, new object[] { restart });
        }

        // ̏
        private ContactMember user;

        // O[ṽXg
        private List<Group> groupList = new List<Group>();
        
        // ݃Xgr[ɕ\ĂO[v
        private Group group;

        // lbg[N̎擾o[̃Xg
        // groupList[GROUP_ALL].Members ւ̃GCAX
        private List<ContactMember> memberList;

        private Notifier notifier;      // ԕύXʒmIuWFNg
        private IdleChecker idle;       // AChԌmIuWFNg

        ///<summary>
        ///o[Xgɂ郁o[̃CX^X𓾂
        ///</summary>
        public Member GetMember(string username, string address)
        {   // o[XgɃ[U[ IP AhXvGg
            // 炻̒̃o[Ԃ
            foreach (Member contact in memberList)
                if ((contact.Name == username) &&
                    (contact.Address == address))
                    return contact;

            if (user.Name == username)
            {   // g擾悤ƂĂꍇ
                if (user.Address == null)
                {    
                    IPAddress ip = NetAdapter.GetAddress();

                    if (ip.ToString() == address)
                       return user;
                }
                else
                {
                    if (user.Address.ToString() == address)
                        return user;
                }
            }

            return null;
        }

        // o[̃CX^X𓾂
        public ContactMember GetContact(string username, string address)
        {   // o[XgɃ[U[ IP AhXvGg
            // 炻Ԃ

            foreach (ContactMember contact in memberList)
                if ((contact.Name == username) &&
                    (contact.Address == address))
                    return contact;

            return null;
        }

        private void InitializeImage()
        {
            for (int num = 0; ; num++)
            {
                string name = String.Format("status{0:D2}", num);
                Bitmap img = (Bitmap)Properties.Resources.ResourceManager.GetObject(name);
                if (img == null)
                    break;
                imageStatus.Images.Add(img);
            }
        }

        private void InitializeProperties()
        {
            // jbNl[ݒ肳ĂȂ̓[U[ݒ
            if (Settings.Default.NickName.Trim() == "")
                Settings.Default.NickName = Environment.UserName;

            // ̗ݒ肳ĂȂ̗̓̃Xg𐶐
            if (Settings.Default.Memos == null)
                Settings.Default.Memos = new List<string>();

            // O[vXgݒ肳ĂȂ̓O[vXg𐶐
            if (Settings.Default.GroupList == null)
                Settings.Default.GroupList = new List<Group>();
        }

        private void InitializeGroupList()
        {
            // ݒς݂̃O[vXg炻O[vXgɐݒ肷
            groupList = Settings.Default.GroupList;

            // O[vXgɉȂftHg̑SO[vǉ
            if (groupList.Count == 0)
            {
                Group group = new Group();
                group.Name = GroupAll;
                group.Members = new List<ContactMember>();
                group.IsExpanded = false;
                groupList.Add(group);
            }

            // 擾ς݂̃o[Xg memberList ɐݒ肷
            memberList = groupList[GROUP_ALL].Members;

            // O[ṽoo[Xg̃CX^XŒu
            foreach (Group group in groupList)
                for (int i = 0; i < group.Members.Count; i++)
                    group.Members[i] =
                        GetContact(group.Members[i].Name, group.Members[i].Address);

            // ݂̃O[vS֐ݒ
            this.group = groupList[Settings.Default.GroupIndex];

            // O[vXg̕\ݒ
            splitContainer.Panel1Collapsed = !Settings.Default.GroupListPanel;
            O[vXgToolStripMenuItem.Checked = Settings.Default.GroupListPanel;

        }

        private void InitializeUser()
        {
            // ̏̏
            user = new ContactMember();

            user.Name = Environment.UserName;
            user.Machine = Environment.MachineName;
            user.NickName = Settings.Default.NickName;

            // Õ̗𕜌
            foreach (string item in Settings.Default.Memos)
                memo.Items.Add(item);

            // Õ𕜌
            user.Memo = Settings.Default.Memo;
            memo.Text = user.Memo;

            // ȌԂ𕜌
            user.Status = (Member.State)Settings.Default.Status;
            ToolStripMenuItem status =
                (ToolStripMenuItem)ToolStripMenuItem.DropDownItems[(int)user.Status];
            if (user.Status < Member.State.IDLE)
                status.Checked = true;

            // ʒm邩Ȃ̃tOݒ(͊{I falsej
            user.Notify = false;
        }

        public Manager()
        {
            InitializeComponent();
            InitializeImage();
            InitializeProperties();
            InitializeUser();
            InitializeGroupList();

            this.ClientSize = new System.Drawing.Size(Properties.Settings.Default.ClientSize);

            // o[̏Ԏ擾IuWFNg̏
            try
            {
                notifier = new Notifier(user);
            }
            catch (SocketException e)
            {
                if (e.ErrorCode == 10048)
                {
                    MessageBox.Show("Ƀ|[ggpĂ܂");
                    finish();
                }
            }

            notifier.notified += new NotifiedHandler(Notified);
            notifier.Start();
            
            // ACh`FbJ̏
            idle = new IdleChecker();

            // AChԌmIuWFNg̏
            idle.running += new RunningHandler(idleState);
            idle.Run(12 * 1000);          // Ƃ肠12bƂɒׂ

            // }l[W[EBhE̖Oݒ
            this.Text = user.NickName + " (" + user.Name + "@" + user.Machine + ")";

            InitializeTreeView();
            InitializeListView();
            updateTreeView();
        }

        private void updateMemberList(Member update)
        {
            ContactMember contact = GetContact(update.Name, update.Address);

            // VKo[o[Xgɒǉ
            if (contact == null)
            {
                contact = new ContactMember();
                contact.CopyFrom(update);
                memberList.Add(contact);

                if (contact.Notify)
                    showBalloonTip(contact.NickName + " u" + contact.GetStatus() + "v");

                addMemberToTree(GROUP_ALL, contact);
            }
            else
            {
                string message = null;

                if (update.Memo != contact.Memo)
                    message += (contact.NickName + " u" + update.Memo + "v");

                if (update.NickName != contact.NickName)
                    message += (contact.NickName + " u" + update.NickName + "v");
               
                if (update.Status != contact.Status)
                    message += (contact.NickName + " u" + update.GetStatus() + "v");

                if ((message != null) && (contact.Notify))
                    showBalloonTip(message);

                contact.CopyFrom(update);

                if (!memberList.Contains(contact))
                    memberList.Add(contact);
            }

            updateTreeView();
        }

        private void updateConfig(bool restart)
        {
            if (restart)
                this.restart();
            else
                notifier.Broadcast();

            user.NickName = Settings.Default.NickName;
            // }l[W[EBhE̖Oݒ
            this.Text = user.NickName + " (" + user.Name + "@" + user.Machine + ")";
            updateListView();
        }

        private void idleState(bool state)
        {
            if (state)
            {   // XN[Z[o[Ă鎞
                if (user.Status == Member.State.ONLINE)
                {   // ICԂAChԂɂ
                    user.Status = Member.State.IDLE;
                    notifier.Broadcast();
                }
            }
            else
            {   // XN[Z[o[ĂȂ
                if (user.Status == Member.State.IDLE)
                {   // AChԂICԂɂ
                    user.Status = Member.State.ONLINE;
                    notifier.Broadcast();
                }
            }
        }

        private void saveSettings()
        {
            // Ԃ̕ۑ
            Settings.Default.Status = (int)user.Status;
            Settings.Default.Memo = user.Memo;
            Settings.Default.Memos = new List<string>();
            foreach (string item in memo.Items)
                Settings.Default.Memos.Add(item);
            foreach (ContactMember contact in memberList)
                contact.Status = Member.State.OFFLINE;
            Settings.Default.GroupList = groupList;
            Settings.Default.GroupIndex = groupList.IndexOf(group);
            Settings.Default.GroupListPanel = !splitContainer.Panel1Collapsed;
            Settings.Default.Location = Location;
            Settings.Default.ClientSize = new Point(ClientSize);
            Settings.Default.SplitterDistance = splitContainer.SplitterDistance;
            Settings.Default.NameWidth = listView.Columns[0].Width;
            Settings.Default.MemoWidth = listView.Columns[1].Width;
            Settings.Default.Save();
        }

        private void finish()
        {
            saveSettings();

            user.Status = Member.State.OFFLINE;            // Iʒm

            if (notifier != null)
            {
                notifier.Broadcast();
                notifier.Stop();
            }

            managerIcon.Visible = false;
            Environment.Exit(0);
        }

        private void restart()
        {
            // ȌԂۑ
            saveSettings();

            user.Status = Member.State.OFFLINE;            // Iʒm
            notifier.Broadcast();
            notifier.Stop();

            // ȌԂ𕜌
            InitializeUser();
            user.Address = null;

            // o[̏Ԏ擾IuWFNg̏
            try
            {
                notifier = new Notifier(user);
            }
            catch (SocketException e)
            {
                if (e.ErrorCode == 10048)
                {
                    MessageBox.Show("Ƀ|[ggpĂ܂");
                    finish();
                }
            }

            notifier.notified += new NotifiedHandler(Notified);
            notifier.Start();
        }
    }
}
