﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Eyes
{
    public partial class FormGroupName : Form
    {
        private List<Group> groupList;

        public string Label
        {
            set { label.Text = value; }
        }

        public string Button
        {
            set { btnOK.Text = value; }
        }

        private string groupName;
        public string GroupName
        {
            set { textName.Text = value; }
            get { return groupName; }
        }

        public FormGroupName(List<Group> groupList)
        {
            InitializeComponent();

            this.groupList = groupList;
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            int i;
            for (i =0; i < groupList.Count; i++)
                if (groupList[i].Name == textName.Text)
                {
                    MessageBox.Show("同じ名前のグループが既に存在します。");
                    this.DialogResult = DialogResult.None;
                    break;
                }

            if (i == groupList.Count)
            {
                groupName = textName.Text;
                this.DialogResult = DialogResult.OK;
            }
        }

        private void textName_KeyPress(object sender, KeyPressEventArgs e)
        {
            //EnterやEscapeキーでビープ音が鳴らないようにする
            if (e.KeyChar == (char)Keys.Enter)
                e.Handled = true;
            
            if (e.KeyChar == (char)Keys.Escape)
                e.Handled = true;
        }
    }
}