﻿#CSV_IOテスト

use strict;
use warnings;

use Text::CSV_XS;
use IO::File;
use Data::Dumper;
use Getopt::Long;
use utf8;
use Encode;
use Test::More;

use CSVAsHash;
use HashWithKeyCheck;

binmode STDOUT => ":encoding(sjis)";
binmode STDERR => ":encoding(sjis)";
my $g_enc=find_encoding('cp932');
plan (tests=>2);

&test1;
&test2;

#hoh
sub test1{
    my $csv_io=CSVAsHash->new();
    my $hoh=$csv_io->csv2hoh("test.txt","商品コード");
    is($hoh->{a1}->{商品名},'あああ',$g_enc->encode('a1=>あああ'));
    $csv_io->hoh2csv($hoh,"output/test_hoh.txt");
}

#aoh
sub test2{
    my $csv_io=CSVAsHash->new();
    my $aoh=$csv_io->csv2aoh("test.txt");
    is($aoh->[0]->{商品名},'あああ',$g_enc->encode('a1=>あああ'));    
    $csv_io->aoh2csv($aoh,"output/test_aoh.txt");
}
