use strict;
use warnings;
use Archive::ZIP;
use File::Find;
use Cwd;
use Getopt::Long;
use Data::Dumper;
use Encode;
use utf8;

binmode(STDERR,":encoding(shift-jis)");
binmode(STDOUT,":encoding(shift-jis)");

my %opts=();
my $zip=Archive::Zip->new();;
&main_proc();

sub main_proc{
    my $res=GetOptions(\%opts,'exclude_file_pattern=s','exclude_file_exts=s');
    print decode("cp932",Dumper(\%opts));
    
    my $APP_NAME="";
    if (Cwd::getcwd() =~ /([^\/]+)$/){
        $APP_NAME=$1;
    }
    
    $ENV{'TZ'}="JST-9";
    my @tm = localtime(time());
    my $ZIP_FILE=sprintf("${APP_NAME}_%04d%02d%02d_%02d%02d.zip",$tm[5]+1900,$tm[4]+1,$tm[3],$tm[2],$tm[1]);
    
    chdir("../");
    my @files = glob "$APP_NAME*.zip";
    for my $file (@files){
        unlink($file);
    }
    # オブジェクト作成
    find({wanted=>\&process_file,no_chdir=>1}, ($APP_NAME));
    # Zipファイルに書き出す
    $zip->writeToFileNamed($ZIP_FILE);
    
    print decode('cp932',$ZIP_FILE) . "を作成しました。\n";
    #my $dummy = <STDIN>;
}

sub process_file{
    #$File::Find::dir   #カレントディレクトリ
    #$_                 #ファイル名

    #フルパスのファイル名
    my $path=  $File::Find::name;

    if (-d $path){
        $zip->addDirectory($path);
        return;
    }

    if (&hantei($path)==1) {
        $zip->addFile($path);
    }else{
        print decode('cp932',"skip:$path\n");
    }
}

sub hantei{
    my $path=decode('cp932',shift); #unicodeで比較
    my $bRet=1;

    #除外ファイル名
    my $regexp = decode('cp932',$opts{exclude_file_pattern});
    if (defined($opts{exclude_file_pattern}) &&  $path =~ /$regexp/) {
        $bRet= 0;
    }
    #除外拡張子
    $regexp=decode('cp932',$opts{exclude_file_exts});
    if (defined($opts{exclude_file_exts}) && $path =~ /$regexp/) {
        $bRet= 0;
    }

    return $bRet;
}
