#指定されたパターンにファイル名が一致するファイルの中で最新のものをコピー

use strict;
use warnings;

use utf8;
use Encode;
use IO::Handle;
use Data::Dumper;
use Getopt::Long;
use File::Copy 'copy';

use Util;

STDOUT->autoflush(1);

binmode STDOUT => ":encoding(sjis)";
binmode STDERR => ":encoding(sjis)";

#グローバル変数
my %opts=();

eval{
    &main_proc();
};
if ($@) {
    printf "エラー：$@\n";
    exit(1);
}

sub main_proc{
	#引数処理
	my $res=GetOptions(\%opts,'in_file_pattern=s','out_file=s');
	print decode("cp932",Dumper(\%opts));
    my $files = Util::get_file_list_sorted( $opts{in_file_pattern},dir=>'desc');
	if (scalar(@$files)==0){
		die sprintf "%sがありません\n",decode("cp932",$opts{in_file_pattern});
	}
	copy $files->[0], $opts{out_file};
	printf "%s\n↓\n%sにコピーしました\n",decode("cp932",$files->[0]),decode("cp932",$opts{out_file});
}
